/*
 * Decompiled with CFR 0.152.
 */
package circlet.platform.api;

import circlet.platform.api.ADateJvmKt;
import circlet.platform.api.ATimeZone;
import circlet.platform.api.JodaDate;
import circlet.platform.api.JodaDateTime;
import circlet.platform.api.Weekday;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\u001a\u001a\u0010\u0016\u001a\u00060\u0001j\u0002`\u0002*\u00060\u0001j\u0002`\u00022\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u001a\u0010\u0019\u001a\u00020\u001a*\u00060\u0001j\u0002`\u00022\n\u0010\u001b\u001a\u00060\u0001j\u0002`\u0002\u001a\u000e\u0010\u001c\u001a\u00020\u001a*\u00060\u0001j\u0002`\u0002\u001a\u000e\u0010\u001d\u001a\u00020\u001a*\u00060\u0001j\u0002`\u0002\u001a\u001a\u0010\u001e\u001a\u00020\u0011*\u00060\u001fj\u0002` 2\n\u0010\u001b\u001a\u00060\u001fj\u0002` \u001a\u001a\u0010!\u001a\u00020\u0011*\u00060\u001fj\u0002` 2\n\u0010\u001b\u001a\u00060\u001fj\u0002` \u001a\u001a\u0010\"\u001a\u00060\u0001j\u0002`\u0002*\u00060\u0001j\u0002`\u00022\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0012\u0010#\u001a\u00060\u001fj\u0002` *\u00060\u0001j\u0002`\u0002\u001a\u001a\u0010#\u001a\u00060\u001fj\u0002` *\u00060\u0001j\u0002`\u00022\u0006\u0010$\u001a\u00020\u0006\u001a@\u0010%\u001a\u00060\u001fj\u0002` *\u00060\u0001j\u0002`\u00022\u0006\u0010&\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\u00062\u0010\b\u0002\u0010(\u001a\n\u0018\u00010\u0001j\u0004\u0018\u0001`\u00022\n\b\u0002\u0010)\u001a\u0004\u0018\u00010\u0006\u001a4\u0010*\u001a\u00020\u0011*\u00060\u001fj\u0002` 2\u0006\u0010'\u001a\u00020\u00062\u0010\b\u0002\u0010(\u001a\n\u0018\u00010\u0001j\u0004\u0018\u0001`\u00022\n\b\u0002\u0010)\u001a\u0004\u0018\u00010\u0006\u001a8\u0010+\u001a\u00060\u001fj\u0002` *\u00060\u001fj\u0002` 2\u0006\u0010'\u001a\u00020\u00062\u0010\b\u0002\u0010(\u001a\n\u0018\u00010\u0001j\u0004\u0018\u0001`\u00022\n\b\u0002\u0010)\u001a\u0004\u0018\u00010\u0006\u001a\u001e\u0010,\u001a\n\u0018\u00010\u0001j\u0004\u0018\u0001`\u0002*\u00060\u0001j\u0002`\u00022\u0006\u0010-\u001a\u00020\u0011\"\u0015\u0010\u0000\u001a\u00060\u0001j\u0002`\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\t\u001a\u00020\u0006*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u001d\u0010\r\u001a\u00060\u0001j\u0002`\u0002*\u00060\u0001j\u0002`\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\"\u0019\u0010\u0010\u001a\u00020\u0011*\u00060\u0001j\u0002`\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\"\u001d\u0010\u0014\u001a\u00060\u0001j\u0002`\u0002*\u00060\u0001j\u0002`\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000f*\n\u0010.\"\u00020\n2\u00020\n\u00a8\u0006/"}, d2={"aTomorrow", "Lcirclet/platform/api/JodaDate;", "Lcirclet/platform/api/ADate;", "getATomorrow", "()Lcirclet/platform/api/JodaDate;", "utcTimeZone", "Lcirclet/platform/api/ATimeZone;", "getUtcTimeZone", "()Lcirclet/platform/api/ATimeZone;", "aTimeZone", "", "getATimeZone", "(Ljava/lang/String;)Lcirclet/platform/api/ATimeZone;", "endOfMonth", "getEndOfMonth", "(Lcirclet/platform/api/JodaDate;)Lcirclet/platform/api/JodaDate;", "numberOfDaysInMonth", "", "getNumberOfDaysInMonth", "(Lcirclet/platform/api/JodaDate;)I", "startOfMonth", "getStartOfMonth", "endOfWeek", "firstDayOfWeek", "Lcirclet/platform/api/Weekday;", "isSame", "", "other", "isToday", "isTomorrow", "minutesDifference", "Lcirclet/platform/api/JodaDateTime;", "Lcirclet/platform/api/ADateTime;", "minutesDifferenceAbs", "startOfWeek", "toDateTimeAtEndOfDay", "zone", "toDateTimeFromClientLocalMinutes", "minutes", "timezone", "targetDate", "clientZone", "toLocalMinutesOnDate", "toLocalTimeOnDate", "withDayIfExist", "day", "AYearMonth", "platform-api"})
public final class ADateKt {
    @NotNull
    private static final ATimeZone utcTimeZone = new ATimeZone("UTC");

    @NotNull
    public static final ATimeZone getUtcTimeZone() {
        return utcTimeZone;
    }

    public static final int getNumberOfDaysInMonth(@NotNull JodaDate $this$numberOfDaysInMonth) {
        Intrinsics.checkNotNullParameter((Object)$this$numberOfDaysInMonth, (String)"<this>");
        return ADateJvmKt.getLastMonthDay($this$numberOfDaysInMonth);
    }

    @Nullable
    public static final JodaDate withDayIfExist(@NotNull JodaDate $this$withDayIfExist, int day) {
        Intrinsics.checkNotNullParameter((Object)$this$withDayIfExist, (String)"<this>");
        int maxDay = ADateJvmKt.getLastMonthDay($this$withDayIfExist);
        return day <= maxDay ? ADateJvmKt.withDay($this$withDayIfExist, day) : null;
    }

    @NotNull
    public static final JodaDate startOfWeek(@NotNull JodaDate $this$startOfWeek, @NotNull Weekday firstDayOfWeek) {
        Intrinsics.checkNotNullParameter((Object)$this$startOfWeek, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)firstDayOfWeek, (String)"firstDayOfWeek");
        Weekday currentWeekday = ADateJvmKt.getWeekday($this$startOfWeek);
        return ADateJvmKt.getWeekday($this$startOfWeek) == firstDayOfWeek ? $this$startOfWeek : ADateJvmKt.minusDays($this$startOfWeek, (currentWeekday.getOrderNumber() + Weekday.values().length - firstDayOfWeek.getOrderNumber()) % Weekday.values().length);
    }

    @NotNull
    public static final JodaDate endOfWeek(@NotNull JodaDate $this$endOfWeek, @NotNull Weekday firstDayOfWeek) {
        Intrinsics.checkNotNullParameter((Object)$this$endOfWeek, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)firstDayOfWeek, (String)"firstDayOfWeek");
        return ADateJvmKt.plusDays($this$endOfWeek, (Weekday.values().length + firstDayOfWeek.getOrderNumber() - ADateJvmKt.getWeekday($this$endOfWeek).getOrderNumber() - 1) % Weekday.values().length);
    }

    @NotNull
    public static final JodaDate getStartOfMonth(@NotNull JodaDate $this$startOfMonth) {
        Intrinsics.checkNotNullParameter((Object)$this$startOfMonth, (String)"<this>");
        int day = ADateJvmKt.getDayOfMonth($this$startOfMonth);
        return day == 1 ? $this$startOfMonth : ADateJvmKt.minusDays($this$startOfMonth, day - 1);
    }

    @NotNull
    public static final JodaDate getEndOfMonth(@NotNull JodaDate $this$endOfMonth) {
        Intrinsics.checkNotNullParameter((Object)$this$endOfMonth, (String)"<this>");
        int diffDays = ADateKt.getNumberOfDaysInMonth($this$endOfMonth) - ADateJvmKt.getDayOfMonth($this$endOfMonth);
        return diffDays == 0 ? $this$endOfMonth : ADateJvmKt.plusDays($this$endOfMonth, diffDays);
    }

    @NotNull
    public static final JodaDateTime toDateTimeAtEndOfDay(@NotNull JodaDate $this$toDateTimeAtEndOfDay, @NotNull ATimeZone zone) {
        Intrinsics.checkNotNullParameter((Object)$this$toDateTimeAtEndOfDay, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)zone, (String)"zone");
        return ADateJvmKt.plusSeconds(ADateJvmKt.toDateTimeAtStartOfDay(ADateJvmKt.plusDays($this$toDateTimeAtEndOfDay, 1), zone), -1);
    }

    @NotNull
    public static final JodaDateTime toDateTimeAtEndOfDay(@NotNull JodaDate $this$toDateTimeAtEndOfDay) {
        Intrinsics.checkNotNullParameter((Object)$this$toDateTimeAtEndOfDay, (String)"<this>");
        return ADateJvmKt.plusSeconds(ADateJvmKt.toDateTimeAtStartOfDay(ADateJvmKt.plusDays($this$toDateTimeAtEndOfDay, 1)), -1);
    }

    @NotNull
    public static final ATimeZone getATimeZone(@NotNull String $this$aTimeZone) {
        Intrinsics.checkNotNullParameter((Object)$this$aTimeZone, (String)"<this>");
        return new ATimeZone($this$aTimeZone);
    }

    @NotNull
    public static final JodaDate getATomorrow() {
        return ADateJvmKt.plusDays(ADateJvmKt.getToday(), 1);
    }

    public static final boolean isSame(@NotNull JodaDate $this$isSame, @NotNull JodaDate other) {
        Intrinsics.checkNotNullParameter((Object)$this$isSame, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return ADateJvmKt.getYear($this$isSame) == ADateJvmKt.getYear(other) && ADateJvmKt.getMonth($this$isSame) == ADateJvmKt.getMonth(other) && ADateJvmKt.getDayOfMonth($this$isSame) == ADateJvmKt.getDayOfMonth(other);
    }

    public static final boolean isToday(@NotNull JodaDate $this$isToday) {
        Intrinsics.checkNotNullParameter((Object)$this$isToday, (String)"<this>");
        return ADateKt.isSame($this$isToday, ADateJvmKt.getToday());
    }

    public static final boolean isTomorrow(@NotNull JodaDate $this$isTomorrow) {
        Intrinsics.checkNotNullParameter((Object)$this$isTomorrow, (String)"<this>");
        return ADateKt.isSame($this$isTomorrow, ADateKt.getATomorrow());
    }

    public static final int minutesDifferenceAbs(@NotNull JodaDateTime $this$minutesDifferenceAbs, @NotNull JodaDateTime other) {
        Intrinsics.checkNotNullParameter((Object)$this$minutesDifferenceAbs, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        long first = ADateJvmKt.getMillis($this$minutesDifferenceAbs) / (long)1000 / (long)60;
        long second = ADateJvmKt.getMillis(other) / (long)1000 / (long)60;
        long l = second - first;
        boolean bl = false;
        return (int)Math.abs(l);
    }

    public static final int minutesDifference(@NotNull JodaDateTime $this$minutesDifference, @NotNull JodaDateTime other) {
        Intrinsics.checkNotNullParameter((Object)$this$minutesDifference, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        long first = ADateJvmKt.getMillis($this$minutesDifference) / (long)1000 / (long)60;
        long second = ADateJvmKt.getMillis(other) / (long)1000 / (long)60;
        return (int)(second - first);
    }

    public static final int toLocalMinutesOnDate(@NotNull JodaDateTime $this$toLocalMinutesOnDate, @NotNull ATimeZone timezone, @Nullable JodaDate targetDate, @Nullable ATimeZone clientZone) {
        Intrinsics.checkNotNullParameter((Object)$this$toLocalMinutesOnDate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)timezone, (String)"timezone");
        JodaDateTime thisInTimezone = ADateJvmKt.withZone($this$toLocalMinutesOnDate, timezone);
        JodaDate thisDateInTimezone = ADateJvmKt.toDate(thisInTimezone);
        JodaDate jodaDate = targetDate;
        JodaDate targetDateInTimezone = jodaDate == null ? ADateJvmKt.toDate(ADateJvmKt.withZone(ADateJvmKt.getANow(), timezone)) : jodaDate;
        int daySinceStart = ADateJvmKt.daysBetween(thisDateInTimezone, targetDateInTimezone);
        ATimeZone aTimeZone = clientZone;
        JodaDateTime desiredStartTime = ADateJvmKt.withZone(ADateJvmKt.plusDays(thisInTimezone, daySinceStart), aTimeZone == null ? ADateJvmKt.getClientTimeZone() : aTimeZone);
        return ADateJvmKt.getHour(desiredStartTime) * 60 + ADateJvmKt.getMinute(desiredStartTime);
    }

    public static /* synthetic */ int toLocalMinutesOnDate$default(JodaDateTime jodaDateTime, ATimeZone aTimeZone, JodaDate jodaDate, ATimeZone aTimeZone2, int n, Object object) {
        if ((n & 2) != 0) {
            jodaDate = ADateJvmKt.toDate(jodaDateTime);
        }
        if ((n & 4) != 0) {
            aTimeZone2 = null;
        }
        return ADateKt.toLocalMinutesOnDate(jodaDateTime, aTimeZone, jodaDate, aTimeZone2);
    }

    @NotNull
    public static final JodaDateTime toLocalTimeOnDate(@NotNull JodaDateTime $this$toLocalTimeOnDate, @NotNull ATimeZone timezone, @Nullable JodaDate targetDate, @Nullable ATimeZone clientZone) {
        Intrinsics.checkNotNullParameter((Object)$this$toLocalTimeOnDate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)timezone, (String)"timezone");
        JodaDateTime thisInTimezone = ADateJvmKt.withZone($this$toLocalTimeOnDate, timezone);
        JodaDate thisDateInTimezone = ADateJvmKt.toDate(thisInTimezone);
        JodaDate jodaDate = targetDate;
        JodaDate targetDateInTimezone = jodaDate == null ? ADateJvmKt.toDate(ADateJvmKt.withZone(ADateJvmKt.getANow(), timezone)) : jodaDate;
        int daySinceStart = ADateJvmKt.daysBetween(thisDateInTimezone, targetDateInTimezone);
        ATimeZone aTimeZone = clientZone;
        return ADateJvmKt.withZone(ADateJvmKt.plusDays(thisInTimezone, daySinceStart), aTimeZone == null ? ADateJvmKt.getClientTimeZone() : aTimeZone);
    }

    public static /* synthetic */ JodaDateTime toLocalTimeOnDate$default(JodaDateTime jodaDateTime, ATimeZone aTimeZone, JodaDate jodaDate, ATimeZone aTimeZone2, int n, Object object) {
        if ((n & 2) != 0) {
            jodaDate = null;
        }
        if ((n & 4) != 0) {
            aTimeZone2 = null;
        }
        return ADateKt.toLocalTimeOnDate(jodaDateTime, aTimeZone, jodaDate, aTimeZone2);
    }

    @NotNull
    public static final JodaDateTime toDateTimeFromClientLocalMinutes(@NotNull JodaDate $this$toDateTimeFromClientLocalMinutes, int minutes, @NotNull ATimeZone timezone, @Nullable JodaDate targetDate, @Nullable ATimeZone clientZone) {
        Intrinsics.checkNotNullParameter((Object)$this$toDateTimeFromClientLocalMinutes, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)timezone, (String)"timezone");
        Object object = targetDate;
        Object object2 = object == null ? ADateJvmKt.getToday() : object;
        object = clientZone;
        JodaDateTime todayInTimezone = ADateJvmKt.withZone(ADateJvmKt.withTime(ADateJvmKt.toDateTimeAtStartOfDay((JodaDate)object2, (ATimeZone)(object == null ? ADateJvmKt.getClientTimeZone() : object)), minutes / 60, minutes % 60, 0, 0), timezone);
        JodaDate dateInTimezone = ADateJvmKt.toDate(todayInTimezone);
        int days = ADateJvmKt.daysBetween($this$toDateTimeFromClientLocalMinutes, dateInTimezone);
        return ADateJvmKt.plusDays(todayInTimezone, -days);
    }

    public static /* synthetic */ JodaDateTime toDateTimeFromClientLocalMinutes$default(JodaDate jodaDate, int n, ATimeZone aTimeZone, JodaDate jodaDate2, ATimeZone aTimeZone2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            jodaDate2 = null;
        }
        if ((n2 & 8) != 0) {
            aTimeZone2 = null;
        }
        return ADateKt.toDateTimeFromClientLocalMinutes(jodaDate, n, aTimeZone, jodaDate2, aTimeZone2);
    }
}

