/*
 * Decompiled with CFR 0.152.
 */
package circlet.platform.api;

import circlet.platform.api.ADateKt;
import circlet.platform.api.ADateObsolete;
import circlet.platform.api.ATimeZone;
import circlet.platform.api.ATimeZoneWithOffset;
import circlet.platform.api.JodaDate;
import circlet.platform.api.JodaDateCompat;
import circlet.platform.api.JodaDateImpl;
import circlet.platform.api.JodaDateTime;
import circlet.platform.api.JodaDateTimeImpl;
import circlet.platform.api.KDateTime;
import circlet.platform.api.PrimitivesExKt;
import circlet.platform.api.Weekday;
import circlet.platform.api.WorkingDaysKt;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.Months;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.Years;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import runtime.date.DateTimeMode;
import runtime.date.DatesKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000~\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u001f\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\"\u0010\u0010\u001a\u00060\nj\u0002`\u000b2\u0006\u0010O\u001a\u00020'2\u0006\u0010F\u001a\u00020'2\u0006\u0010Q\u001a\u00020'\u001a\u0012\u0010\u0010\u001a\u00060\nj\u0002`\u000b2\u0006\u0010-\u001a\u00020#\u001a:\u0010\u0014\u001a\u00060\u0001j\u0002`\u00022\u0006\u0010O\u001a\u00020'2\u0006\u0010F\u001a\u00020'2\u0006\u0010Q\u001a\u00020'2\u0006\u0010R\u001a\u00020'2\u0006\u0010S\u001a\u00020'2\u0006\u0010T\u001a\u00020\u0006\u001a\u0012\u0010\u0014\u001a\u00060\u0001j\u0002`\u00022\u0006\u0010<\u001a\u00020=\u001a\u0012\u0010\u0014\u001a\u00060\u0001j\u0002`\u00022\u0006\u0010-\u001a\u00020#\u001a\u001e\u0010U\u001a\u00020'2\n\u0010V\u001a\u00060\nj\u0002`\u000b2\n\u0010W\u001a\u00060\nj\u0002`\u000b\u001a\u001e\u0010U\u001a\u00020'2\n\u0010V\u001a\u00060\u0001j\u0002`\u00022\n\u0010W\u001a\u00060\u0001j\u0002`\u0002\u001a\u001e\u0010X\u001a\u00020'2\n\u0010V\u001a\u00060\nj\u0002`\u000b2\n\u0010W\u001a\u00060\nj\u0002`\u000b\u001a\u001e\u0010X\u001a\u00020'2\n\u0010V\u001a\u00060\u0001j\u0002`\u00022\n\u0010W\u001a\u00060\u0001j\u0002`\u0002\u001a\u001e\u0010Y\u001a\u00020'2\n\u0010V\u001a\u00060\u0001j\u0002`\u00022\n\u0010W\u001a\u00060\u0001j\u0002`\u0002\u001a\u001c\u0010Z\u001a\u00020#*\u00060\nj\u0002`\u000b2\f\b\u0002\u0010[\u001a\u00060\nj\u0002`\u000b\u001a&\u0010\\\u001a\u00020#*\u00060\u0001j\u0002`\u00022\b\b\u0002\u0010]\u001a\u00020^2\f\b\u0002\u0010[\u001a\u00060\u0001j\u0002`\u0002\u001a\u000e\u0010_\u001a\u00020#*\u00060\u0001j\u0002`\u0002\u001a\u000e\u0010`\u001a\u00020'*\u00060\nj\u0002`\u000b\u001a\u001a\u0010a\u001a\u00060\nj\u0002`\u000b*\u00060\nj\u0002`\u000b2\u0006\u0010b\u001a\u00020'\u001a\u001a\u0010c\u001a\u00060\nj\u0002`\u000b*\u00060\nj\u0002`\u000b2\u0006\u0010d\u001a\u00020'\u001a\u001e\u0010e\u001a\n\u0018\u00010\u0001j\u0004\u0018\u0001`\u0002*\u00020\u00062\n\u0010f\u001a\u00060\u0001j\u0002`\u0002\u001a\u0016\u0010g\u001a\u00020'*\u00020\u00062\n\u0010h\u001a\u00060\u0001j\u0002`\u0002\u001a\u001a\u0010i\u001a\u00060\nj\u0002`\u000b*\u00060\nj\u0002`\u000b2\u0006\u0010b\u001a\u00020'\u001a\u001a\u0010i\u001a\u00060\u0001j\u0002`\u0002*\u00060\u0001j\u0002`\u00022\u0006\u0010b\u001a\u00020'\u001a\u001a\u0010j\u001a\u00060\u0001j\u0002`\u0002*\u00060\u0001j\u0002`\u00022\u0006\u0010R\u001a\u00020'\u001a\u001a\u0010k\u001a\u00060\u0001j\u0002`\u0002*\u00060\u0001j\u0002`\u00022\u0006\u0010<\u001a\u00020'\u001a\u001a\u0010l\u001a\u00060\u0001j\u0002`\u0002*\u00060\u0001j\u0002`\u00022\u0006\u0010S\u001a\u00020'\u001a\u001a\u0010m\u001a\u00060\nj\u0002`\u000b*\u00060\nj\u0002`\u000b2\u0006\u0010d\u001a\u00020'\u001a\u001a\u0010m\u001a\u00060\u0001j\u0002`\u0002*\u00060\u0001j\u0002`\u00022\u0006\u0010d\u001a\u00020'\u001a\u001a\u0010n\u001a\u00060\u0001j\u0002`\u0002*\u00060\u0001j\u0002`\u00022\u0006\u0010o\u001a\u00020'\u001a\u001a\u0010p\u001a\u00060\nj\u0002`\u000b*\u00060\nj\u0002`\u000b2\u0006\u0010q\u001a\u00020'\u001a\u001a\u0010p\u001a\u00060\u0001j\u0002`\u0002*\u00060\u0001j\u0002`\u00022\u0006\u0010q\u001a\u00020'\u001a\u0012\u0010r\u001a\u00060\nj\u0002`\u000b*\u00060\u0001j\u0002`\u0002\u001a\u0012\u0010s\u001a\u00060\u0001j\u0002`\u0002*\u00060\nj\u0002`\u000b\u001a\u001a\u0010s\u001a\u00060\u0001j\u0002`\u0002*\u00060\nj\u0002`\u000b2\u0006\u0010t\u001a\u00020\u0006\u001a\u001a\u0010u\u001a\u00060\nj\u0002`\u000b*\u00060\nj\u0002`\u000b2\u0006\u0010Q\u001a\u00020'\u001a\u001a\u0010v\u001a\u00060\nj\u0002`\u000b*\u00060\nj\u0002`\u000b2\u0006\u0010Q\u001a\u00020'\u001a\u001c\u0010w\u001a\u00020\"*\u00020\u00062\u0010\b\u0002\u0010x\u001a\n\u0018\u00010\nj\u0004\u0018\u0001`\u000b\u001a2\u0010y\u001a\u00060\u0001j\u0002`\u0002*\u00060\u0001j\u0002`\u00022\u0006\u0010R\u001a\u00020'2\u0006\u0010S\u001a\u00020'2\u0006\u0010o\u001a\u00020'2\u0006\u0010z\u001a\u00020'\u001a\u001a\u0010{\u001a\u00060\u0001j\u0002`\u0002*\u00060\u0001j\u0002`\u00022\u0006\u0010t\u001a\u00020\u0006\u001a\u001a\u0010|\u001a\u00060\nj\u0002`\u000b*\u00060\nj\u0002`\u000b2\u0006\u0010}\u001a\u00020~\"\u0015\u0010\u0000\u001a\u00060\u0001j\u0002`\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\t\u001a\u00060\nj\u0002`\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u0015\u0010\u000e\u001a\u00060\nj\u0002`\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\r\"\u0019\u0010\u0010\u001a\u00060\nj\u0002`\u000b*\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\"\u0019\u0010\u0014\u001a\u00060\u0001j\u0002`\u0002*\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\"\u0019\u0010\u0014\u001a\u00060\u0001j\u0002`\u0002*\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0019\"\u001d\u0010\u001a\u001a\u00060\u0001j\u0002`\u0002*\u00060\nj\u0002`\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\"\u0015\u0010\u001d\u001a\u00020\u0006*\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \"\u0015\u0010!\u001a\u00020\"*\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\"\u0019\u0010&\u001a\u00020'*\u00060\nj\u0002`\u000b8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\"\u0019\u0010&\u001a\u00020'*\u00060\u0001j\u0002`\u00028F\u00a2\u0006\u0006\u001a\u0004\b(\u0010*\"\u0019\u0010+\u001a\u00020'*\u00060\u0001j\u0002`\u00028F\u00a2\u0006\u0006\u001a\u0004\b,\u0010*\"\u0019\u0010-\u001a\u00020#*\u00060\nj\u0002`\u000b8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\"\u0019\u00100\u001a\u000201*\u00060\nj\u0002`\u000b8F\u00a2\u0006\u0006\u001a\u0004\b2\u00103\"\u001d\u00104\u001a\n 5*\u0004\u0018\u00010\u001e0\u001e*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b6\u00107\"\u001d\u00104\u001a\n 5*\u0004\u0018\u00010\u001e0\u001e*\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b6\u00108\"\u0019\u00109\u001a\u00020\u0015*\u00060\u0001j\u0002`\u00028F\u00a2\u0006\u0006\u001a\u0004\b:\u0010;\"\u0019\u0010<\u001a\u00020=*\u00060\u0001j\u0002`\u00028F\u00a2\u0006\u0006\u001a\u0004\b>\u0010?\"\u0019\u0010@\u001a\u00020'*\u00060\u0001j\u0002`\u00028F\u00a2\u0006\u0006\u001a\u0004\bA\u0010*\"\u0019\u0010B\u001a\u00020'*\u00060\u0001j\u0002`\u00028F\u00a2\u0006\u0006\u001a\u0004\bC\u0010*\"\u0019\u0010D\u001a\u00020'*\u00060\u0001j\u0002`\u00028F\u00a2\u0006\u0006\u001a\u0004\bE\u0010*\"\u0019\u0010F\u001a\u00020'*\u00060\nj\u0002`\u000b8F\u00a2\u0006\u0006\u001a\u0004\bG\u0010)\"\u0019\u0010F\u001a\u00020'*\u00060\u0001j\u0002`\u00028F\u00a2\u0006\u0006\u001a\u0004\bG\u0010*\"\u0019\u0010H\u001a\u00020'*\u00060\u0001j\u0002`\u00028F\u00a2\u0006\u0006\u001a\u0004\bI\u0010*\"\u0019\u0010J\u001a\u00020K*\u00060\nj\u0002`\u000b8F\u00a2\u0006\u0006\u001a\u0004\bL\u0010M\"\u0019\u0010J\u001a\u00020K*\u00060\u0001j\u0002`\u00028F\u00a2\u0006\u0006\u001a\u0004\bL\u0010N\"\u0019\u0010O\u001a\u00020'*\u00060\nj\u0002`\u000b8F\u00a2\u0006\u0006\u001a\u0004\bP\u0010)\"\u0019\u0010O\u001a\u00020'*\u00060\u0001j\u0002`\u00028F\u00a2\u0006\u0006\u001a\u0004\bP\u0010**\n\u0010\u007f\"\u00020\n2\u00020\n*\u000b\u0010\u0080\u0001\"\u00020\u00012\u00020\u0001\u00a8\u0006\u0081\u0001"}, d2={"aNow", "Lcirclet/platform/api/JodaDateTime;", "Lcirclet/platform/api/ADateTime;", "getANow", "()Lcirclet/platform/api/JodaDateTime;", "clientTimeZone", "Lcirclet/platform/api/ATimeZone;", "getClientTimeZone", "()Lcirclet/platform/api/ATimeZone;", "epochStart", "Lcirclet/platform/api/JodaDate;", "Lcirclet/platform/api/ADate;", "getEpochStart", "()Lcirclet/platform/api/JodaDate;", "today", "getToday", "aDate", "Lorg/joda/time/LocalDate;", "getADate", "(Lorg/joda/time/LocalDate;)Lcirclet/platform/api/JodaDate;", "aDateTime", "Lcirclet/platform/api/KDateTime;", "getADateTime", "(Lcirclet/platform/api/KDateTime;)Lcirclet/platform/api/JodaDateTime;", "Lorg/joda/time/DateTime;", "(Lorg/joda/time/DateTime;)Lcirclet/platform/api/JodaDateTime;", "aDateTimeUnsafe", "getADateTimeUnsafe", "(Lcirclet/platform/api/JodaDate;)Lcirclet/platform/api/JodaDateTime;", "aTimeZone", "Lorg/joda/time/DateTimeZone;", "getATimeZone", "(Lorg/joda/time/DateTimeZone;)Lcirclet/platform/api/ATimeZone;", "aTimeZoneWithOffsetNow", "Lcirclet/platform/api/ATimeZoneWithOffset;", "", "getATimeZoneWithOffsetNow", "(Ljava/lang/String;)Lcirclet/platform/api/ATimeZoneWithOffset;", "dayOfMonth", "", "getDayOfMonth", "(Lcirclet/platform/api/JodaDate;)I", "(Lcirclet/platform/api/JodaDateTime;)I", "hour", "getHour", "internal", "getInternal", "(Lcirclet/platform/api/JodaDate;)Ljava/lang/String;", "internalCompat", "", "getInternalCompat", "(Lcirclet/platform/api/JodaDate;)Ljava/lang/Object;", "joda", "kotlin.jvm.PlatformType", "getJoda", "(Lcirclet/platform/api/ATimeZone;)Lorg/joda/time/DateTimeZone;", "(Lcirclet/platform/api/ATimeZoneWithOffset;)Lorg/joda/time/DateTimeZone;", "kDateTime", "getKDateTime", "(Lcirclet/platform/api/JodaDateTime;)Lcirclet/platform/api/KDateTime;", "millis", "", "getMillis", "(Lcirclet/platform/api/JodaDateTime;)J", "millisOfSecond", "getMillisOfSecond", "minute", "getMinute", "minuteOfDay", "getMinuteOfDay", "month", "getMonth", "second", "getSecond", "weekday", "Lcirclet/platform/api/Weekday;", "getWeekday", "(Lcirclet/platform/api/JodaDate;)Lcirclet/platform/api/Weekday;", "(Lcirclet/platform/api/JodaDateTime;)Lcirclet/platform/api/Weekday;", "year", "getYear", "day", "hours", "minutes", "timezone", "daysBetween", "a", "b", "monthsBetween", "yearsBetween", "formatDate", "now", "formatDateTime", "mode", "Lruntime/date/DateTimeMode;", "formatFullDateTime", "getLastMonthDay", "minusDays", "days", "minusMonths", "months", "nextTransition", "from", "offsetOnTime", "time", "plusDays", "plusHours", "plusMillis", "plusMinutes", "plusMonths", "plusSeconds", "seconds", "plusYears", "years", "toDate", "toDateTimeAtStartOfDay", "zone", "withDay", "withDayOrLastMonthDay", "withOffsetOnDate", "date", "withTime", "mills", "withZone", "wrapCompat", "supportsADate", "", "ADate", "ADateTime", "platform-api"})
public final class ADateJvmKt {
    @NotNull
    public static final JodaDateTime getADateTime(@NotNull DateTime $this$aDateTime) {
        Intrinsics.checkNotNullParameter((Object)$this$aDateTime, (String)"<this>");
        return JodaDateTimeImpl.box-impl(JodaDateTimeImpl.constructor-impl($this$aDateTime));
    }

    @NotNull
    public static final JodaDate getADate(@NotNull LocalDate $this$aDate) {
        Intrinsics.checkNotNullParameter((Object)$this$aDate, (String)"<this>");
        return JodaDateImpl.box-impl(JodaDateImpl.constructor-impl($this$aDate));
    }

    public static final DateTimeZone getJoda(@NotNull ATimeZoneWithOffset $this$joda) {
        Intrinsics.checkNotNullParameter((Object)$this$joda, (String)"<this>");
        return DateTimeZone.forID((String)$this$joda.getId());
    }

    public static final DateTimeZone getJoda(@NotNull ATimeZone $this$joda) {
        Intrinsics.checkNotNullParameter((Object)$this$joda, (String)"<this>");
        return DateTimeZone.forID((String)$this$joda.getId());
    }

    @NotNull
    public static final ATimeZone getATimeZone(@NotNull DateTimeZone $this$aTimeZone) {
        Intrinsics.checkNotNullParameter((Object)$this$aTimeZone, (String)"<this>");
        String string = $this$aTimeZone.getID();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.id");
        return new ATimeZone(string);
    }

    public static final int daysBetween(@NotNull JodaDateTime a, @NotNull JodaDateTime b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Days.daysBetween((ReadableInstant)((ReadableInstant)a.getDateTime()), (ReadableInstant)((ReadableInstant)b.getDateTime())).getDays();
    }

    public static final int daysBetween(@NotNull JodaDate a, @NotNull JodaDate b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Days.daysBetween((ReadablePartial)((ReadablePartial)a.getDate()), (ReadablePartial)((ReadablePartial)b.getDate())).getDays();
    }

    public static final int monthsBetween(@NotNull JodaDateTime a, @NotNull JodaDateTime b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Months.monthsBetween((ReadableInstant)((ReadableInstant)a.getDateTime()), (ReadableInstant)((ReadableInstant)b.getDateTime())).getMonths();
    }

    public static final int monthsBetween(@NotNull JodaDate a, @NotNull JodaDate b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Months.monthsBetween((ReadablePartial)((ReadablePartial)a.getDate()), (ReadablePartial)((ReadablePartial)b.getDate())).getMonths();
    }

    @NotNull
    public static final JodaDateTime withZone(@NotNull JodaDateTime $this$withZone, @NotNull ATimeZone zone) {
        Intrinsics.checkNotNullParameter((Object)$this$withZone, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)zone, (String)"zone");
        DateTime dateTime2 = $this$withZone.getDateTime().withZone(DateTimeZone.forID((String)zone.getId()));
        Intrinsics.checkNotNullExpressionValue((Object)dateTime2, (String)"dateTime.withZone(DateTimeZone.forID(zone.id))");
        return ADateJvmKt.getADateTime(dateTime2);
    }

    public static final int yearsBetween(@NotNull JodaDateTime a, @NotNull JodaDateTime b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Years.yearsBetween((ReadableInstant)((ReadableInstant)a.getDateTime()), (ReadableInstant)((ReadableInstant)b.getDateTime())).getYears();
    }

    @NotNull
    public static final JodaDateTime plusDays(@NotNull JodaDateTime $this$plusDays, int days) {
        Intrinsics.checkNotNullParameter((Object)$this$plusDays, (String)"<this>");
        DateTime dateTime2 = $this$plusDays.getDateTime().plusDays(days);
        Intrinsics.checkNotNullExpressionValue((Object)dateTime2, (String)"dateTime.plusDays(days)");
        return ADateJvmKt.getADateTime(dateTime2);
    }

    @NotNull
    public static final JodaDateTime plusMonths(@NotNull JodaDateTime $this$plusMonths, int months) {
        Intrinsics.checkNotNullParameter((Object)$this$plusMonths, (String)"<this>");
        DateTime dateTime2 = $this$plusMonths.getDateTime().plusMonths(months);
        Intrinsics.checkNotNullExpressionValue((Object)dateTime2, (String)"dateTime.plusMonths(months)");
        return ADateJvmKt.getADateTime(dateTime2);
    }

    @NotNull
    public static final JodaDateTime plusYears(@NotNull JodaDateTime $this$plusYears, int years) {
        Intrinsics.checkNotNullParameter((Object)$this$plusYears, (String)"<this>");
        DateTime dateTime2 = $this$plusYears.getDateTime().plusYears(years);
        Intrinsics.checkNotNullExpressionValue((Object)dateTime2, (String)"dateTime.plusYears(years)");
        return ADateJvmKt.getADateTime(dateTime2);
    }

    @NotNull
    public static final JodaDateTime plusHours(@NotNull JodaDateTime $this$plusHours, int hours) {
        Intrinsics.checkNotNullParameter((Object)$this$plusHours, (String)"<this>");
        DateTime dateTime2 = $this$plusHours.getDateTime().plusHours(hours);
        Intrinsics.checkNotNullExpressionValue((Object)dateTime2, (String)"dateTime.plusHours(hours)");
        return ADateJvmKt.getADateTime(dateTime2);
    }

    @NotNull
    public static final JodaDateTime plusMinutes(@NotNull JodaDateTime $this$plusMinutes, int minutes) {
        Intrinsics.checkNotNullParameter((Object)$this$plusMinutes, (String)"<this>");
        DateTime dateTime2 = $this$plusMinutes.getDateTime().plusMinutes(minutes);
        Intrinsics.checkNotNullExpressionValue((Object)dateTime2, (String)"dateTime.plusMinutes(minutes)");
        return ADateJvmKt.getADateTime(dateTime2);
    }

    @NotNull
    public static final JodaDateTime plusSeconds(@NotNull JodaDateTime $this$plusSeconds, int seconds) {
        Intrinsics.checkNotNullParameter((Object)$this$plusSeconds, (String)"<this>");
        DateTime dateTime2 = $this$plusSeconds.getDateTime().plusSeconds(seconds);
        Intrinsics.checkNotNullExpressionValue((Object)dateTime2, (String)"dateTime.plusSeconds(seconds)");
        return ADateJvmKt.getADateTime(dateTime2);
    }

    @NotNull
    public static final JodaDateTime plusMillis(@NotNull JodaDateTime $this$plusMillis, int millis) {
        Intrinsics.checkNotNullParameter((Object)$this$plusMillis, (String)"<this>");
        DateTime dateTime2 = $this$plusMillis.getDateTime().plusMillis(millis);
        Intrinsics.checkNotNullExpressionValue((Object)dateTime2, (String)"dateTime.plusMillis(millis)");
        return ADateJvmKt.getADateTime(dateTime2);
    }

    @NotNull
    public static final JodaDateTime toDateTimeAtStartOfDay(@NotNull JodaDate $this$toDateTimeAtStartOfDay, @NotNull ATimeZone zone) {
        Intrinsics.checkNotNullParameter((Object)$this$toDateTimeAtStartOfDay, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)zone, (String)"zone");
        DateTime dateTime2 = $this$toDateTimeAtStartOfDay.getDate().toDateTimeAtStartOfDay(ADateJvmKt.getJoda(zone));
        Intrinsics.checkNotNullExpressionValue((Object)dateTime2, (String)"date.toDateTimeAtStartOfDay(zone.joda)");
        return ADateJvmKt.getADateTime(dateTime2);
    }

    @NotNull
    public static final JodaDateTime toDateTimeAtStartOfDay(@NotNull JodaDate $this$toDateTimeAtStartOfDay) {
        Intrinsics.checkNotNullParameter((Object)$this$toDateTimeAtStartOfDay, (String)"<this>");
        DateTime dateTime2 = $this$toDateTimeAtStartOfDay.getDate().toDateTimeAtStartOfDay();
        Intrinsics.checkNotNullExpressionValue((Object)dateTime2, (String)"date.toDateTimeAtStartOfDay()");
        return ADateJvmKt.getADateTime(dateTime2);
    }

    @NotNull
    public static final JodaDateTime withTime(@NotNull JodaDateTime $this$withTime, int hours, int minutes, int seconds, int mills) {
        Intrinsics.checkNotNullParameter((Object)$this$withTime, (String)"<this>");
        DateTime dateTime2 = $this$withTime.getDateTime().withTime(hours, minutes, seconds, mills);
        Intrinsics.checkNotNullExpressionValue((Object)dateTime2, (String)"dateTime.withTime(hours, minutes, seconds, mills)");
        return ADateJvmKt.getADateTime(dateTime2);
    }

    @NotNull
    public static final JodaDate toDate(@NotNull JodaDateTime $this$toDate) {
        Intrinsics.checkNotNullParameter((Object)$this$toDate, (String)"<this>");
        LocalDate localDate = $this$toDate.getDateTime().toLocalDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"this.dateTime.toLocalDate()");
        return ADateJvmKt.getADate(localDate);
    }

    @NotNull
    public static final JodaDateTime getADateTimeUnsafe(@NotNull JodaDate $this$aDateTimeUnsafe) {
        Intrinsics.checkNotNullParameter((Object)$this$aDateTimeUnsafe, (String)"<this>");
        DateTime dateTime2 = $this$aDateTimeUnsafe.getDate().toDateTimeAtCurrentTime();
        Intrinsics.checkNotNullExpressionValue((Object)dateTime2, (String)"this.date.toDateTimeAtCurrentTime()");
        return ADateJvmKt.getADateTime(dateTime2);
    }

    @NotNull
    public static final JodaDateTime getADateTime(@NotNull KDateTime $this$aDateTime) {
        Intrinsics.checkNotNullParameter((Object)$this$aDateTime, (String)"<this>");
        return ADateJvmKt.getADateTime(PrimitivesExKt.dateTime($this$aDateTime));
    }

    @NotNull
    public static final KDateTime getKDateTime(@NotNull JodaDateTime $this$kDateTime) {
        Intrinsics.checkNotNullParameter((Object)$this$kDateTime, (String)"<this>");
        return PrimitivesExKt.toKDateTime($this$kDateTime.getDateTime());
    }

    @NotNull
    public static final JodaDate wrapCompat(@NotNull JodaDate $this$wrapCompat, boolean supportsADate) {
        Intrinsics.checkNotNullParameter((Object)$this$wrapCompat, (String)"<this>");
        return supportsADate ? $this$wrapCompat : (JodaDate)new JodaDateCompat($this$wrapCompat);
    }

    @NotNull
    public static final ATimeZoneWithOffset getATimeZoneWithOffsetNow(@NotNull String $this$aTimeZoneWithOffsetNow) {
        Intrinsics.checkNotNullParameter((Object)$this$aTimeZoneWithOffsetNow, (String)"<this>");
        DateTimeZone zone = DateTimeZone.forID((String)$this$aTimeZoneWithOffsetNow);
        String string = zone.getID();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"zone.id");
        return new ATimeZoneWithOffset(string, zone.getOffset(PrimitivesExKt.getNowMs()));
    }

    @NotNull
    public static final ATimeZoneWithOffset withOffsetOnDate(@NotNull ATimeZone $this$withOffsetOnDate, @Nullable JodaDate date2) {
        Intrinsics.checkNotNullParameter((Object)$this$withOffsetOnDate, (String)"<this>");
        JodaDate jodaDate = date2;
        DateTime dateTime2 = (jodaDate == null ? LocalDate.now() : jodaDate.getDate()).toDateTimeAtStartOfDay(DateTimeZone.forID((String)$this$withOffsetOnDate.getId()));
        Intrinsics.checkNotNullExpressionValue((Object)dateTime2, (String)"date?.date ?: LocalDate.now()).toDateTimeAtStartOfDay(DateTimeZone.forID(id))");
        int offset = PrimitivesExKt.utcOffset(dateTime2);
        return new ATimeZoneWithOffset($this$withOffsetOnDate.getId(), offset);
    }

    public static /* synthetic */ ATimeZoneWithOffset withOffsetOnDate$default(ATimeZone aTimeZone, JodaDate jodaDate, int n, Object object) {
        if ((n & 1) != 0) {
            jodaDate = null;
        }
        return ADateJvmKt.withOffsetOnDate(aTimeZone, jodaDate);
    }

    public static final int offsetOnTime(@NotNull ATimeZone $this$offsetOnTime, @NotNull JodaDateTime time) {
        Intrinsics.checkNotNullParameter((Object)$this$offsetOnTime, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        DateTime dateTime2 = time.getDateTime().withZone(DateTimeZone.forID((String)$this$offsetOnTime.getId()));
        Intrinsics.checkNotNullExpressionValue((Object)dateTime2, (String)"time.dateTime.withZone(DateTimeZone.forID(id))");
        return PrimitivesExKt.utcOffset(dateTime2);
    }

    @Nullable
    public static final JodaDateTime nextTransition(@NotNull ATimeZone $this$nextTransition, @NotNull JodaDateTime from) {
        Intrinsics.checkNotNullParameter((Object)$this$nextTransition, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        long fromMillis = ADateJvmKt.getMillis(from);
        long transitionMillis = DateTimeZone.forID((String)$this$nextTransition.getId()).nextTransition(fromMillis);
        return fromMillis == transitionMillis ? null : JodaDateTimeImpl.box-impl(JodaDateTimeImpl.constructor-impl(new DateTime(transitionMillis)));
    }

    public static final long getMillis(@NotNull JodaDateTime $this$millis) {
        Intrinsics.checkNotNullParameter((Object)$this$millis, (String)"<this>");
        return $this$millis.getDateTime().getMillis();
    }

    @NotNull
    public static final JodaDateTime getANow() {
        DateTime dateTime2 = DateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)dateTime2, (String)"now()");
        return JodaDateTimeImpl.box-impl(JodaDateTimeImpl.constructor-impl(dateTime2));
    }

    @NotNull
    public static final JodaDate getEpochStart() {
        return JodaDateImpl.box-impl(JodaDateImpl.constructor-impl(new LocalDate(0L)));
    }

    @NotNull
    public static final JodaDate getToday() {
        LocalDate localDate = LocalDate.now();
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"now()");
        return JodaDateImpl.box-impl(JodaDateImpl.constructor-impl(localDate));
    }

    @NotNull
    public static final JodaDateTime aDateTime(long millis) {
        return ADateJvmKt.getADateTime(new DateTime(millis));
    }

    @NotNull
    public static final JodaDateTime aDateTime(@NotNull String internal) {
        Intrinsics.checkNotNullParameter((Object)internal, (String)"internal");
        DateTime dateTime2 = DateTime.parse((String)internal, (DateTimeFormatter)ISODateTimeFormat.dateTimeParser());
        Intrinsics.checkNotNullExpressionValue((Object)dateTime2, (String)"parse(internal, ISODateTimeFormat.dateTimeParser())");
        return ADateJvmKt.getADateTime(dateTime2);
    }

    @NotNull
    public static final JodaDate aDate(@NotNull String internal) {
        Intrinsics.checkNotNullParameter((Object)internal, (String)"internal");
        LocalDate localDate = LocalDate.parse((String)internal);
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"parse(internal)");
        return ADateJvmKt.getADate(localDate);
    }

    @NotNull
    public static final JodaDate aDate(int year, int month, int day) {
        return ADateJvmKt.getADate(new LocalDate(year, month, day));
    }

    public static final int getDayOfMonth(@NotNull JodaDate $this$dayOfMonth) {
        Intrinsics.checkNotNullParameter((Object)$this$dayOfMonth, (String)"<this>");
        return $this$dayOfMonth.getDate().getDayOfMonth();
    }

    public static final int getMonth(@NotNull JodaDate $this$month) {
        Intrinsics.checkNotNullParameter((Object)$this$month, (String)"<this>");
        return $this$month.getDate().getMonthOfYear();
    }

    public static final int getYear(@NotNull JodaDate $this$year) {
        Intrinsics.checkNotNullParameter((Object)$this$year, (String)"<this>");
        return $this$year.getDate().getYear();
    }

    @NotNull
    public static final Weekday getWeekday(@NotNull JodaDate $this$weekday) {
        Intrinsics.checkNotNullParameter((Object)$this$weekday, (String)"<this>");
        return WorkingDaysKt.weekday($this$weekday.getDate().getDayOfWeek());
    }

    public static final int getMillisOfSecond(@NotNull JodaDateTime $this$millisOfSecond) {
        Intrinsics.checkNotNullParameter((Object)$this$millisOfSecond, (String)"<this>");
        return $this$millisOfSecond.getDateTime().getMillisOfSecond();
    }

    public static final int getSecond(@NotNull JodaDateTime $this$second) {
        Intrinsics.checkNotNullParameter((Object)$this$second, (String)"<this>");
        return $this$second.getDateTime().getSecondOfMinute();
    }

    public static final int getMinute(@NotNull JodaDateTime $this$minute) {
        Intrinsics.checkNotNullParameter((Object)$this$minute, (String)"<this>");
        return $this$minute.getDateTime().getMinuteOfHour();
    }

    public static final int getMinuteOfDay(@NotNull JodaDateTime $this$minuteOfDay) {
        Intrinsics.checkNotNullParameter((Object)$this$minuteOfDay, (String)"<this>");
        return $this$minuteOfDay.getDateTime().getMinuteOfDay();
    }

    public static final int getHour(@NotNull JodaDateTime $this$hour) {
        Intrinsics.checkNotNullParameter((Object)$this$hour, (String)"<this>");
        return $this$hour.getDateTime().getHourOfDay();
    }

    public static final int getDayOfMonth(@NotNull JodaDateTime $this$dayOfMonth) {
        Intrinsics.checkNotNullParameter((Object)$this$dayOfMonth, (String)"<this>");
        return $this$dayOfMonth.getDateTime().getDayOfMonth();
    }

    public static final int getMonth(@NotNull JodaDateTime $this$month) {
        Intrinsics.checkNotNullParameter((Object)$this$month, (String)"<this>");
        return $this$month.getDateTime().getMonthOfYear();
    }

    public static final int getYear(@NotNull JodaDateTime $this$year) {
        Intrinsics.checkNotNullParameter((Object)$this$year, (String)"<this>");
        return $this$year.getDateTime().getYear();
    }

    @NotNull
    public static final Weekday getWeekday(@NotNull JodaDateTime $this$weekday) {
        Intrinsics.checkNotNullParameter((Object)$this$weekday, (String)"<this>");
        return WorkingDaysKt.weekday($this$weekday.getDateTime().getDayOfWeek());
    }

    @NotNull
    public static final JodaDate withDay(@NotNull JodaDate $this$withDay, int day) {
        Intrinsics.checkNotNullParameter((Object)$this$withDay, (String)"<this>");
        LocalDate localDate = $this$withDay.getDate().withDayOfMonth(day);
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"this.date.withDayOfMonth(day)");
        return ADateJvmKt.getADate(localDate);
    }

    public static final int getLastMonthDay(@NotNull JodaDate $this$getLastMonthDay) {
        Intrinsics.checkNotNullParameter((Object)$this$getLastMonthDay, (String)"<this>");
        return $this$getLastMonthDay.getDate().dayOfMonth().getMaximumValue();
    }

    @NotNull
    public static final JodaDate withDayOrLastMonthDay(@NotNull JodaDate $this$withDayOrLastMonthDay, int day) {
        Intrinsics.checkNotNullParameter((Object)$this$withDayOrLastMonthDay, (String)"<this>");
        int max = $this$withDayOrLastMonthDay.getDate().dayOfMonth().getMaximumValue();
        LocalDate localDate = $this$withDayOrLastMonthDay.getDate().withDayOfMonth(RangesKt.coerceAtMost((int)day, (int)max));
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"this.date.withDayOfMonth(day.coerceAtMost(max))");
        return ADateJvmKt.getADate(localDate);
    }

    @NotNull
    public static final JodaDate minusDays(@NotNull JodaDate $this$minusDays, int days) {
        Intrinsics.checkNotNullParameter((Object)$this$minusDays, (String)"<this>");
        LocalDate localDate = $this$minusDays.getDate().minusDays(days);
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"date.minusDays(days)");
        return ADateJvmKt.getADate(localDate);
    }

    @NotNull
    public static final JodaDate minusMonths(@NotNull JodaDate $this$minusMonths, int months) {
        Intrinsics.checkNotNullParameter((Object)$this$minusMonths, (String)"<this>");
        LocalDate localDate = $this$minusMonths.getDate().minusMonths(months);
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"date.minusMonths(months)");
        return ADateJvmKt.getADate(localDate);
    }

    @NotNull
    public static final JodaDate plusDays(@NotNull JodaDate $this$plusDays, int days) {
        Intrinsics.checkNotNullParameter((Object)$this$plusDays, (String)"<this>");
        LocalDate localDate = $this$plusDays.getDate().plusDays(days);
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"date.plusDays(days)");
        return ADateJvmKt.getADate(localDate);
    }

    @NotNull
    public static final JodaDate plusMonths(@NotNull JodaDate $this$plusMonths, int months) {
        Intrinsics.checkNotNullParameter((Object)$this$plusMonths, (String)"<this>");
        LocalDate localDate = $this$plusMonths.getDate().plusMonths(months);
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"date.plusMonths(months)");
        return ADateJvmKt.getADate(localDate);
    }

    @NotNull
    public static final JodaDate plusYears(@NotNull JodaDate $this$plusYears, int years) {
        Intrinsics.checkNotNullParameter((Object)$this$plusYears, (String)"<this>");
        LocalDate localDate = $this$plusYears.getDate().plusYears(years);
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"date.plusYears(years)");
        return ADateJvmKt.getADate(localDate);
    }

    @NotNull
    public static final ATimeZone getClientTimeZone() {
        String string = TimeZone.getDefault().getID();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDefault().id");
        return ADateKt.getATimeZone(string);
    }

    @NotNull
    public static final String getInternal(@NotNull JodaDate $this$internal) {
        Intrinsics.checkNotNullParameter((Object)$this$internal, (String)"<this>");
        String string = PrimitivesExKt.getDEFAULT_DATE_FORMAT().print((ReadablePartial)$this$internal.getDate());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DEFAULT_DATE_FORMAT.print(date)");
        return string;
    }

    @NotNull
    public static final Object getInternalCompat(@NotNull JodaDate $this$internalCompat) {
        Intrinsics.checkNotNullParameter((Object)$this$internalCompat, (String)"<this>");
        return $this$internalCompat instanceof JodaDateCompat ? new ADateObsolete(ADateJvmKt.getInternal($this$internalCompat)) : ADateJvmKt.getInternal($this$internalCompat);
    }

    @NotNull
    public static final String formatDate(@NotNull JodaDate $this$formatDate, @NotNull JodaDate now) {
        Intrinsics.checkNotNullParameter((Object)$this$formatDate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)now, (String)"now");
        return DatesKt.formatDate($this$formatDate.getDate(), now.getDate());
    }

    public static /* synthetic */ String formatDate$default(JodaDate jodaDate, JodaDate jodaDate2, int n, Object object) {
        if ((n & 1) != 0) {
            jodaDate2 = ADateJvmKt.getToday();
        }
        return ADateJvmKt.formatDate(jodaDate, jodaDate2);
    }

    @NotNull
    public static final String formatDateTime(@NotNull JodaDateTime $this$formatDateTime, @NotNull DateTimeMode mode2, @NotNull JodaDateTime now) {
        Intrinsics.checkNotNullParameter((Object)$this$formatDateTime, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)mode2), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)now, (String)"now");
        return DatesKt.formatDateTime($this$formatDateTime.getDateTime(), mode2, now.getDateTime());
    }

    public static /* synthetic */ String formatDateTime$default(JodaDateTime jodaDateTime, DateTimeMode dateTimeMode, JodaDateTime jodaDateTime2, int n, Object object) {
        if ((n & 1) != 0) {
            dateTimeMode = DateTimeMode.DEFAULT;
        }
        if ((n & 2) != 0) {
            jodaDateTime2 = ADateJvmKt.getANow();
        }
        return ADateJvmKt.formatDateTime(jodaDateTime, dateTimeMode, jodaDateTime2);
    }

    @NotNull
    public static final String formatFullDateTime(@NotNull JodaDateTime $this$formatFullDateTime) {
        Intrinsics.checkNotNullParameter((Object)$this$formatFullDateTime, (String)"<this>");
        return DatesKt.formatFullDateTime(ADateJvmKt.getMillis($this$formatFullDateTime));
    }

    @NotNull
    public static final JodaDateTime aDateTime(int year, int month, int day, int hours, int minutes, @NotNull ATimeZone timezone) {
        Intrinsics.checkNotNullParameter((Object)timezone, (String)"timezone");
        return ADateJvmKt.getADateTime(new DateTime(year, month, day, hours, minutes, ADateJvmKt.getJoda(timezone)));
    }
}

