/*
 * Decompiled with CFR 0.152.
 */
package circlet.common.oauth;

import circlet.common.permissions.RightType;
import circlet.platform.api.oauth.OpenSet;
import circlet.platform.api.oauth.OpenSetKt;
import circlet.platform.api.oauth.ScopeTokenParseException;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\b\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\u0016\u0010\u0010\u001a\u00060\u0003j\u0002`\u00112\n\u0010\u0012\u001a\u00060\u0003j\u0002`\u0011J2\u0010\u0013\u001a\u00020\u0003\"\u0004\b\u0000\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u00162\u0016\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u0002H\u0014\u0012\b\u0012\u00060\u0003j\u0002`\u00110\u0018J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001J0\u0010\u001a\u001a\u00020\u0003\"\u0004\b\u0000\u0010\u001b*\b\u0012\u0004\u0012\u0002H\u001b0\u00162\u0016\b\u0002\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u0002H\u001b\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0018H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u001e"}, d2={"Lcirclet/common/oauth/CircletScopeTokenKind;", "", "code", "", "(Ljava/lang/String;)V", "getCode", "()Ljava/lang/String;", "rightTypeCode", "getRightTypeCode", "component1", "copy", "equals", "", "other", "hashCode", "", "printSingleRightToken", "Lcirclet/common/permissions/RightCode;", "rightCode", "printToken", "TRight", "rights", "Lcirclet/platform/api/oauth/OpenSet;", "rightToCode", "Lkotlin/Function1;", "toString", "print", "T", "printValue", "Companion", "common"})
public final class CircletScopeTokenKind {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String code;
    @NotNull
    private final String rightTypeCode;

    public CircletScopeTokenKind(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        this.code = code;
        this.rightTypeCode = Intrinsics.stringPlus((String)this.code, (Object)"RightType");
    }

    @NotNull
    public final String getCode() {
        return this.code;
    }

    @NotNull
    public final String getRightTypeCode() {
        return this.rightTypeCode;
    }

    @NotNull
    public final <TRight> String printToken(@NotNull OpenSet<? extends TRight> rights2, @NotNull Function1<? super TRight, String> rightToCode) {
        Intrinsics.checkNotNullParameter(rights2, (String)"rights");
        Intrinsics.checkNotNullParameter(rightToCode, (String)"rightToCode");
        return Intrinsics.areEqual((Object)this, (Object)Companion.getGLOBAL()) ? this.print(rights2, rightToCode) : this.code + ':' + this.print(rights2, rightToCode);
    }

    @NotNull
    public final String printSingleRightToken(@NotNull String rightCode) {
        Intrinsics.checkNotNullParameter((Object)rightCode, (String)"rightCode");
        return Intrinsics.areEqual((Object)this, (Object)Companion.getGLOBAL()) ? rightCode : this.code + ':' + rightCode;
    }

    private final <T> String print(OpenSet<? extends T> $this$print, Function1<? super T, String> printValue) {
        return OpenSetKt.print($this$print, ",", "*", printValue);
    }

    static /* synthetic */ String print$default(CircletScopeTokenKind circletScopeTokenKind, OpenSet openSet, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        return circletScopeTokenKind.print(openSet, function1);
    }

    @NotNull
    public final String component1() {
        return this.code;
    }

    @NotNull
    public final CircletScopeTokenKind copy(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        return new CircletScopeTokenKind(code);
    }

    public static /* synthetic */ CircletScopeTokenKind copy$default(CircletScopeTokenKind circletScopeTokenKind, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = circletScopeTokenKind.code;
        }
        return circletScopeTokenKind.copy(string);
    }

    @NotNull
    public String toString() {
        return "CircletScopeTokenKind(code=" + this.code + ')';
    }

    public int hashCode() {
        return this.code.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CircletScopeTokenKind)) {
            return false;
        }
        CircletScopeTokenKind circletScopeTokenKind = (CircletScopeTokenKind)other;
        return Intrinsics.areEqual((Object)this.code, (Object)circletScopeTokenKind.code);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ=\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\f\u001a\u00020\t2\"\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u000e\u0012\f\u0012\b\u0012\u00060\tj\u0002`\u00100\u000f\u0012\u0004\u0012\u0002H\u000b0\u000e\u00a2\u0006\u0002\u0010\u0011J\u0012\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u000f*\u00020\tH\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lcirclet/common/oauth/CircletScopeTokenKind$Companion;", "", "()V", "GLOBAL", "Lcirclet/common/oauth/CircletScopeTokenKind;", "getGLOBAL", "()Lcirclet/common/oauth/CircletScopeTokenKind;", "fromRightTypeCode", "rightTypeCode", "", "parseToken", "T", "token", "factory", "Lkotlin/Function2;", "Lcirclet/platform/api/oauth/OpenSet;", "Lcirclet/common/permissions/RightCode;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "parseOpenSet", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CircletScopeTokenKind getGLOBAL() {
            return RightType.Global.INSTANCE.getScopeTokenKind();
        }

        @NotNull
        public final CircletScopeTokenKind fromRightTypeCode(@NotNull String rightTypeCode) {
            Intrinsics.checkNotNullParameter((Object)rightTypeCode, (String)"rightTypeCode");
            return new CircletScopeTokenKind(StringsKt.removeSuffix((String)rightTypeCode, (CharSequence)"RightType"));
        }

        public final <T> T parseToken(@NotNull String token2, @NotNull Function2<? super CircletScopeTokenKind, ? super OpenSet<String>, ? extends T> factory) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)token2, (String)"token");
            Intrinsics.checkNotNullParameter(factory, (String)"factory");
            try {
                Object object2;
                char[] cArray = new char[]{':'};
                List parts = StringsKt.split$default((CharSequence)token2, (char[])cArray, (boolean)false, (int)0, (int)6, null);
                int n = parts.size();
                switch (n) {
                    case 1: {
                        object2 = factory.invoke((Object)this.getGLOBAL(), this.parseOpenSet((String)parts.get(0)));
                        break;
                    }
                    case 2: {
                        object2 = factory.invoke((Object)new CircletScopeTokenKind((String)parts.get(0)), this.parseOpenSet((String)parts.get(1)));
                        break;
                    }
                    default: {
                        object2 = null;
                    }
                }
                object = object2;
            }
            catch (Exception e) {
                throw new ScopeTokenParseException(token2, e);
            }
            Object object3 = object;
            if (object3 == null) {
                throw new ScopeTokenParseException(token2, null, 2, null);
            }
            return (T)object3;
        }

        private final OpenSet<String> parseOpenSet(String $this$parseOpenSet) {
            return OpenSetKt.parseOpenSet($this$parseOpenSet, ",", "*");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

