/*
 * Decompiled with CFR 0.152.
 */
package circlet.common.calendar;

import circlet.common.calendar.DatesInterval;
import circlet.platform.api.ADateJvmKt;
import circlet.platform.api.ATimeZone;
import circlet.platform.api.JodaDate;
import circlet.platform.api.JodaDateTime;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u000e\u0010\u0005\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0004\u00a2\u0006\u0002\u0010\u0006J\r\u0010\n\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\u0011\u0010\u000b\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0004H\u00c6\u0003J)\u0010\f\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\u0010\b\u0002\u0010\u0005\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0004H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0019\u0010\u0005\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0018"}, d2={"Lcirclet/common/calendar/TimeIntervalDTO;", "", "start", "Lcirclet/platform/api/JodaDateTime;", "Lcirclet/platform/api/ADateTime;", "end", "(Lcirclet/platform/api/JodaDateTime;Lcirclet/platform/api/JodaDateTime;)V", "getEnd", "()Lcirclet/platform/api/JodaDateTime;", "getStart", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toDates", "Lcirclet/common/calendar/DatesInterval;", "timezone", "Lcirclet/platform/api/ATimeZone;", "toString", "", "common"})
public final class TimeIntervalDTO {
    @NotNull
    private final JodaDateTime start;
    @Nullable
    private final JodaDateTime end;

    public TimeIntervalDTO(@NotNull JodaDateTime start2, @Nullable JodaDateTime end) {
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        this.start = start2;
        this.end = end;
        boolean bl = this.end == null || this.start.compareTo(this.end) <= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = this.getStart() + " > " + this.getEnd();
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final JodaDateTime getStart() {
        return this.start;
    }

    @Nullable
    public final JodaDateTime getEnd() {
        return this.end;
    }

    @NotNull
    public final DatesInterval toDates(@NotNull ATimeZone timezone) {
        JodaDateTime jodaDateTime;
        Intrinsics.checkNotNullParameter((Object)timezone, (String)"timezone");
        Comparable<JodaDateTime> comparable = this.end;
        JodaDateTime jodaDateTime2 = jodaDateTime = comparable == null ? null : ADateJvmKt.withZone(comparable, timezone);
        JodaDate endDate = jodaDateTime == null ? null : ((comparable = ADateJvmKt.toDate(jodaDateTime)) == null ? null : ADateJvmKt.plusDays((JodaDate)comparable, 1));
        return new DatesInterval(ADateJvmKt.toDate(ADateJvmKt.withZone(this.start, timezone)), endDate);
    }

    @NotNull
    public final JodaDateTime component1() {
        return this.start;
    }

    @Nullable
    public final JodaDateTime component2() {
        return this.end;
    }

    @NotNull
    public final TimeIntervalDTO copy(@NotNull JodaDateTime start2, @Nullable JodaDateTime end) {
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        return new TimeIntervalDTO(start2, end);
    }

    public static /* synthetic */ TimeIntervalDTO copy$default(TimeIntervalDTO timeIntervalDTO, JodaDateTime jodaDateTime, JodaDateTime jodaDateTime2, int n, Object object) {
        if ((n & 1) != 0) {
            jodaDateTime = timeIntervalDTO.start;
        }
        if ((n & 2) != 0) {
            jodaDateTime2 = timeIntervalDTO.end;
        }
        return timeIntervalDTO.copy(jodaDateTime, jodaDateTime2);
    }

    @NotNull
    public String toString() {
        return "TimeIntervalDTO(start=" + this.start + ", end=" + this.end + ')';
    }

    public int hashCode() {
        int result2 = this.start.hashCode();
        result2 = result2 * 31 + (this.end == null ? 0 : this.end.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TimeIntervalDTO)) {
            return false;
        }
        TimeIntervalDTO timeIntervalDTO = (TimeIntervalDTO)other;
        if (!Intrinsics.areEqual((Object)this.start, (Object)timeIntervalDTO.start)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.end, (Object)timeIntervalDTO.end);
    }
}

