/*
 * Decompiled with CFR 0.152.
 */
package circlet.common.calendar;

import circlet.common.calendar.CalendarEventSpec;
import circlet.common.calendar.ClosedTimeInterval;
import circlet.common.calendar.DatesInterval;
import circlet.common.calendar.EventCountersKt;
import circlet.common.calendar.RecurrenceRuleEnds;
import circlet.common.calendar.RecurrenceRuleFreq;
import circlet.common.calendar.SpecInstancesKt;
import circlet.common.calendar.TimeIntervalDTO;
import circlet.platform.api.ADateJvmKt;
import circlet.platform.api.ADateKt;
import circlet.platform.api.ATimeZone;
import circlet.platform.api.JodaDate;
import circlet.platform.api.JodaDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import libraries.basics.ControlFlowKt;
import libraries.klogging.KLogger;
import libraries.klogging.KLoggers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.Math;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000h\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\u001aH\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tj\u0002`\n2\n\u0010\u000b\u001a\u00060\tj\u0002`\n2\n\u0010\f\u001a\u00060\tj\u0002`\n2\n\u0010\r\u001a\u00060\tj\u0002`\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0016\u0010\u0010\u001a\n\u0018\u00010\tj\u0004\u0018\u0001`\n2\u0006\u0010\u0011\u001a\u00020\u0012\u001a*\u0010\u0013\u001a\n\u0018\u00010\u0014j\u0004\u0018\u0001`\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\n\u0010\f\u001a\u00060\tj\u0002`\n\u001a\"\u0010\u001a\u001a\u00060\u0014j\u0002`\u00152\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u001d\u001a\"\u0010\u001a\u001a\u00060\u0014j\u0002`\u00152\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u001e\u001a\u001a\u0010\u001f\u001a\u00020 *\u00020\u00122\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u000f\u001a\"\u0010$\u001a\u00020\u0005*\u00020\u00122\n\u0010%\u001a\u00060\tj\u0002`\n2\n\u0010&\u001a\u00060\tj\u0002`\n\u001a\u0012\u0010'\u001a\u00060\u0014j\u0002`\u0015*\u00060\u0014j\u0002`\u0015\u001a\u001a\u0010(\u001a\u00060\tj\u0002`\n*\u00020\u00122\n\u0010)\u001a\u00060\u0014j\u0002`\u0015\u001a\u0016\u0010*\u001a\u00020+*\u00020\u00122\n\u0010)\u001a\u00060\u0014j\u0002`\u0015\u001a*\u0010,\u001a\u00060\u0014j\u0002`\u0015*\u00060\u0014j\u0002`\u00152\u0006\u0010)\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\u0007\u001a\"\u0010/\u001a\u00060\u0014j\u0002`\u0015*\u00060\u0014j\u0002`\u00152\u0006\u0010)\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u0007\u001a*\u00100\u001a\u00060\u0014j\u0002`\u0015*\u00060\u0014j\u0002`\u00152\u0006\u00101\u001a\u00020\u00072\u0006\u00102\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u0007\u001a\u0012\u00103\u001a\u00060\u0014j\u0002`\u0015*\u00060\u0014j\u0002`\u0015\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u00064"}, d2={"log", "Llibraries/klogging/KLogger;", "getLog", "()Llibraries/klogging/KLogger;", "doesMonthlyOnDateIntersect", "", "freqInterval", "", "meetingStart", "Lcirclet/platform/api/JodaDateTime;", "Lcirclet/platform/api/ADateTime;", "meetingEnd", "start", "end", "zone", "Lcirclet/platform/api/ATimeZone;", "lastOccurrenceStart", "event", "Lcirclet/common/calendar/CalendarEventSpec;", "lastOccurrenceStartLocalDate", "Lcirclet/platform/api/JodaDate;", "Lcirclet/platform/api/ADate;", "ends", "Lcirclet/common/calendar/RecurrenceRuleEnds;", "freq", "Lcirclet/common/calendar/RecurrenceRuleFreq;", "startThisMonth", "year", "month", "Lcirclet/common/calendar/RecurrenceRuleFreq$MonthlyOnFirstWeekday;", "Lcirclet/common/calendar/RecurrenceRuleFreq$MonthlyOnLastWeekday;", "calcDatesInterval", "Lcirclet/common/calendar/DatesInterval;", "timeInterval", "Lcirclet/common/calendar/TimeIntervalDTO;", "targetTimezone", "intersects", "_start", "_end", "monthStart", "startTimeAtDay", "day", "timeIntervalAtDay", "Lcirclet/common/calendar/ClosedTimeInterval;", "toLastDateWithMonthDay", "interval", "repetitions", "toNextDateWithMonthDay", "toNextYearWithYearDay", "dayInMonth", "monthInYear", "yearStart", "common"})
public final class SpecIntersectsKt {
    @NotNull
    private static final KLogger log;

    public static final boolean intersects(@NotNull CalendarEventSpec $this$intersects, @NotNull JodaDateTime _start, @NotNull JodaDateTime _end) {
        JodaDateTime jodaDateTime;
        Comparable newEnd;
        RecurrenceRuleFreq freq;
        Intrinsics.checkNotNullParameter((Object)$this$intersects, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)_start, (String)"_start");
        Intrinsics.checkNotNullParameter((Object)_end, (String)"_end");
        ATimeZone zone = $this$intersects.getTimezone();
        JodaDateTime start2 = ADateJvmKt.withZone(_start, zone);
        Comparable<JodaDateTime> end = null;
        end = ADateJvmKt.withZone(_end, zone);
        JodaDateTime meetingStart = ADateJvmKt.withZone($this$intersects.getStart(), zone);
        JodaDateTime meetingEnd = ADateJvmKt.withZone($this$intersects.getEnd(), zone);
        if (meetingStart.compareTo(end) >= 0) {
            return false;
        }
        if ($this$intersects.getRecurrenceRule() == null) {
            return meetingEnd.compareTo(start2) > 0;
        }
        RecurrenceRuleEnds ends = $this$intersects.getRecurrenceRule().getEnds();
        Object object = SpecIntersectsKt.lastOccurrenceStartLocalDate(ends, freq = $this$intersects.getAllDay() ? $this$intersects.getRecurrenceRule().getFreq() : EventCountersKt.fix($this$intersects.getRecurrenceRule().getFreq(), $this$intersects.getStart(), $this$intersects.getTimezone()), meetingStart);
        Comparable comparable = object == null ? null : (newEnd = (jodaDateTime = ADateJvmKt.toDateTimeAtStartOfDay((JodaDate)object, zone)) == null ? null : ADateJvmKt.withTime(jodaDateTime, 23, 59, 59, 0));
        if (newEnd != null) {
            if (newEnd.compareTo(end) < 0) {
                end = newEnd;
            }
            if (end.compareTo(start2) < 0) {
                return false;
            }
        }
        if ((object = freq) instanceof RecurrenceRuleFreq.Daily) {
            if (meetingEnd.compareTo(start2) > 0) {
                return true;
            }
            int n = 0;
            int n2 = ADateJvmKt.daysBetween(meetingEnd, start2) - 1;
            boolean bl = false;
            int intervals = java.lang.Math.max(n, n2) / ((RecurrenceRuleFreq.Daily)freq).getInterval() + 1;
            JodaDateTime nextMeetingStat = ADateJvmKt.plusDays(meetingStart, intervals * ((RecurrenceRuleFreq.Daily)freq).getInterval());
            JodaDateTime nextMeetingEnd = ADateJvmKt.plusDays(meetingEnd, intervals * ((RecurrenceRuleFreq.Daily)freq).getInterval());
            if (nextMeetingStat.compareTo(end) >= 0) {
                return false;
            }
            if (nextMeetingEnd.compareTo(start2) > 0) {
                return true;
            }
            JodaDateTime nextMeetingStat32 = ADateJvmKt.plusDays(meetingStart, (intervals + 1) * ((RecurrenceRuleFreq.Daily)freq).getInterval());
            JodaDateTime nextMeetingEnd2 = ADateJvmKt.plusDays(meetingEnd, (intervals + 1) * ((RecurrenceRuleFreq.Daily)freq).getInterval());
            if (nextMeetingStat32.compareTo(end) >= 0) {
                return false;
            }
            return nextMeetingEnd2.compareTo(start2) > 0;
        }
        if (object instanceof RecurrenceRuleFreq.Weekly) {
            int nextMeetingStat = 0;
            int nextMeetingEnd = ADateJvmKt.daysBetween(meetingEnd, start2) - 1;
            boolean nextMeetingStat32 = false;
            int intervals = java.lang.Math.max(nextMeetingStat, nextMeetingEnd) / (7 * ((RecurrenceRuleFreq.Weekly)freq).getInterval());
            Iterable $this$forEach$iv = (Iterable)new IntRange(0, 2);
            boolean $i$f$forEach = false;
            Iterator nextMeetingStat32 = $this$forEach$iv.iterator();
            while (nextMeetingStat32.hasNext()) {
                int element$iv;
                int shift = element$iv = ((IntIterator)nextMeetingStat32).nextInt();
                boolean bl = false;
                Iterable $this$forEach$iv2 = (Iterable)new IntRange(0, 6);
                boolean $i$f$forEach2 = false;
                Iterator iterator2 = $this$forEach$iv2.iterator();
                while (iterator2.hasNext()) {
                    int element$iv2;
                    int dow = element$iv2 = ((IntIterator)iterator2).nextInt();
                    boolean bl2 = false;
                    JodaDateTime nextMeetingStart = ADateJvmKt.plusDays(meetingStart, (intervals + shift) * ((RecurrenceRuleFreq.Weekly)freq).getInterval() * 7 + dow);
                    JodaDateTime nextMeetingEnd2 = ADateJvmKt.plusDays(meetingEnd, (intervals + shift) * ((RecurrenceRuleFreq.Weekly)freq).getInterval() * 7 + dow);
                    if (!((RecurrenceRuleFreq.Weekly)freq).getWeekdays().contains(ADateJvmKt.getWeekday(nextMeetingStart))) continue;
                    if (nextMeetingStart.compareTo(end) >= 0) {
                        return false;
                    }
                    if (nextMeetingEnd2.compareTo(start2) <= 0) continue;
                    return true;
                }
            }
            return false;
        }
        if (object instanceof RecurrenceRuleFreq.Yearly) {
            if (meetingEnd.compareTo(start2) > 0) {
                return true;
            }
            int $this$forEach$iv = 0;
            int $i$f$forEach = ADateJvmKt.yearsBetween(meetingEnd, start2) - 1;
            boolean nextMeetingStat32 = false;
            int intervals = java.lang.Math.max($this$forEach$iv, $i$f$forEach) / ((RecurrenceRuleFreq.Yearly)freq).getInterval() + 1;
            JodaDateTime nextMeetingStat = ADateJvmKt.plusYears(meetingStart, intervals * ((RecurrenceRuleFreq.Yearly)freq).getInterval());
            JodaDateTime nextMeetingEnd = ADateJvmKt.plusYears(meetingEnd, intervals * ((RecurrenceRuleFreq.Yearly)freq).getInterval());
            if (nextMeetingStat.compareTo(end) >= 0) {
                return false;
            }
            if (nextMeetingEnd.compareTo(start2) > 0) {
                return true;
            }
            JodaDateTime nextMeetingStat2 = ADateJvmKt.plusYears(meetingStart, (intervals + 1) * ((RecurrenceRuleFreq.Yearly)freq).getInterval());
            JodaDateTime nextMeetingEnd2 = ADateJvmKt.plusYears(meetingEnd, (intervals + 1) * ((RecurrenceRuleFreq.Yearly)freq).getInterval());
            if (nextMeetingStat2.compareTo(end) >= 0) {
                return false;
            }
            return nextMeetingEnd2.compareTo(start2) > 0;
        }
        if (object instanceof RecurrenceRuleFreq.MonthlyOnDate) {
            return SpecIntersectsKt.doesMonthlyOnDateIntersect(((RecurrenceRuleFreq.MonthlyOnDate)freq).getInterval(), meetingStart, meetingEnd, start2, end, zone);
        }
        if (object instanceof RecurrenceRuleFreq.MonthlyOnStartDate) {
            return SpecIntersectsKt.doesMonthlyOnDateIntersect(((RecurrenceRuleFreq.MonthlyOnStartDate)freq).getInterval(), meetingStart, meetingEnd, start2, end, zone);
        }
        if (object instanceof RecurrenceRuleFreq.MonthlyOnFirstWeekday) {
            int nextMeetingStat = 0;
            int nextMeetingEnd = ADateJvmKt.monthsBetween(meetingEnd, start2) - 1;
            boolean bl = false;
            int intervals = java.lang.Math.max(nextMeetingStat, nextMeetingEnd) / ((RecurrenceRuleFreq.MonthlyOnFirstWeekday)freq).getInterval();
            Iterable $this$forEach$iv = (Iterable)new IntRange(0, 2);
            boolean $i$f$forEach = false;
            Iterator iterator3 = $this$forEach$iv.iterator();
            while (iterator3.hasNext()) {
                int element$iv;
                int shift = element$iv = ((IntIterator)iterator3).nextInt();
                boolean bl3 = false;
                JodaDate startDate = ADateJvmKt.toDate(meetingStart);
                JodaDate nextMeetingStatMonth = ADateJvmKt.plusMonths(ADateJvmKt.withDay(startDate, 1), (intervals + shift) * ((RecurrenceRuleFreq.MonthlyOnFirstWeekday)freq).getInterval());
                JodaDate nextMeetingStatDate = SpecIntersectsKt.startThisMonth(ADateJvmKt.getYear(nextMeetingStatMonth), ADateJvmKt.getMonth(nextMeetingStatMonth), (RecurrenceRuleFreq.MonthlyOnFirstWeekday)freq);
                int days = ADateJvmKt.daysBetween(startDate, nextMeetingStatDate);
                JodaDateTime nextMeetingStat2 = ADateJvmKt.plusDays(meetingStart, days);
                JodaDateTime nextMeetingEnd3 = ADateJvmKt.plusDays(meetingEnd, days);
                if (nextMeetingStat2.compareTo(end) >= 0) {
                    return false;
                }
                if (nextMeetingEnd3.compareTo(start2) <= 0) continue;
                return true;
            }
            return false;
        }
        if (object instanceof RecurrenceRuleFreq.MonthlyOnLastWeekday) {
            int $this$forEach$iv = 0;
            int $i$f$forEach = ADateJvmKt.monthsBetween(meetingEnd, start2) - 1;
            boolean bl = false;
            int intervals = java.lang.Math.max($this$forEach$iv, $i$f$forEach) / ((RecurrenceRuleFreq.MonthlyOnLastWeekday)freq).getInterval();
            Iterable $this$forEach$iv2 = (Iterable)new IntRange(0, 2);
            $i$f$forEach = 0;
            Iterator iterator4 = $this$forEach$iv2.iterator();
            while (iterator4.hasNext()) {
                int element$iv;
                int shift = element$iv = ((IntIterator)iterator4).nextInt();
                boolean bl4 = false;
                JodaDate startDate = ADateJvmKt.toDate(meetingStart);
                JodaDate nextMeetingStatMonth = ADateJvmKt.plusMonths(ADateJvmKt.withDay(startDate, 1), (intervals + shift) * ((RecurrenceRuleFreq.MonthlyOnLastWeekday)freq).getInterval());
                JodaDate nextMeetingStatDate = SpecIntersectsKt.startThisMonth(ADateJvmKt.getYear(nextMeetingStatMonth), ADateJvmKt.getMonth(nextMeetingStatMonth), (RecurrenceRuleFreq.MonthlyOnLastWeekday)freq);
                int days = ADateJvmKt.daysBetween(startDate, nextMeetingStatDate);
                JodaDateTime nextMeetingStat = ADateJvmKt.plusDays(meetingStart, days);
                JodaDateTime nextMeetingEnd = ADateJvmKt.plusDays(meetingEnd, days);
                if (nextMeetingStat.compareTo(end) >= 0) {
                    return false;
                }
                if (nextMeetingEnd.compareTo(start2) <= 0) continue;
                return true;
            }
            return false;
        }
        throw new NoWhenBranchMatchedException();
    }

    private static final boolean doesMonthlyOnDateIntersect(int freqInterval, JodaDateTime meetingStart, JodaDateTime meetingEnd, JodaDateTime start2, JodaDateTime end, ATimeZone zone) {
        boolean possibleEveryMonth;
        boolean bl = possibleEveryMonth = ADateJvmKt.getDayOfMonth(meetingStart) < 29;
        if (possibleEveryMonth) {
            int n = 0;
            int n2 = ADateJvmKt.monthsBetween(meetingEnd, start2) - 1;
            boolean bl2 = false;
            int intervals = java.lang.Math.max(n, n2) / freqInterval;
            Iterable $this$forEach$iv = (Iterable)new IntRange(0, 2);
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                int element$iv;
                int shift = element$iv = ((IntIterator)iterator2).nextInt();
                boolean bl3 = false;
                JodaDateTime nextMeetingStat = ADateJvmKt.plusMonths(meetingStart, (intervals + shift) * freqInterval);
                JodaDateTime nextMeetingEnd = ADateJvmKt.plusMonths(meetingEnd, (intervals + shift) * freqInterval);
                if (nextMeetingStat.compareTo(end) >= 0) {
                    return false;
                }
                if (nextMeetingEnd.compareTo(start2) <= 0) continue;
                return true;
            }
            return false;
        }
        JodaDateTime nextStart = meetingStart;
        int duration = ADateKt.minutesDifference(meetingStart, meetingEnd);
        while (nextStart.compareTo(end) < 0) {
            JodaDateTime nextEnd = ADateJvmKt.plusMinutes(nextStart, duration);
            if (nextEnd.compareTo(start2) > 0) {
                return true;
            }
            nextStart = ADateJvmKt.plusMinutes(ADateJvmKt.toDateTimeAtStartOfDay(SpecIntersectsKt.toNextDateWithMonthDay(ADateJvmKt.toDate(ADateJvmKt.withZone(nextStart, zone)), ADateJvmKt.getDayOfMonth(meetingStart), freqInterval), zone), ADateJvmKt.getMinuteOfDay(meetingStart));
        }
        return false;
    }

    @NotNull
    public static final JodaDateTime startTimeAtDay(@NotNull CalendarEventSpec $this$startTimeAtDay, @NotNull JodaDate day) {
        Intrinsics.checkNotNullParameter((Object)$this$startTimeAtDay, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)day, (String)"day");
        return SpecInstancesKt.shiftedSpec($this$startTimeAtDay, day, $this$startTimeAtDay.getTimezone()).getStart();
    }

    @NotNull
    public static final KLogger getLog() {
        return log;
    }

    @NotNull
    public static final DatesInterval calcDatesInterval(@NotNull CalendarEventSpec $this$calcDatesInterval, @NotNull TimeIntervalDTO timeInterval, @NotNull ATimeZone targetTimezone) {
        JodaDate jodaDate;
        JodaDateTime jodaDateTime;
        JodaDate endDate;
        JodaDateTime jodaDateTime2;
        JodaDateTime jodaDateTime3;
        JodaDateTime jodaDateTime4;
        JodaDateTime intervalEnd;
        Intrinsics.checkNotNullParameter((Object)$this$calcDatesInterval, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)timeInterval, (String)"timeInterval");
        Intrinsics.checkNotNullParameter((Object)targetTimezone, (String)"targetTimezone");
        JodaDateTime intervalStart = timeInterval.getStart();
        JodaDate startDateInEventZone = ADateJvmKt.toDate(ADateJvmKt.withZone(intervalStart, $this$calcDatesInterval.getTimezone()));
        JodaDateTime jodaDateTime5 = intervalEnd = timeInterval.getEnd();
        JodaDate endDateInEventZone = jodaDateTime5 == null ? null : ((jodaDateTime4 = ADateJvmKt.withZone(jodaDateTime5, $this$calcDatesInterval.getTimezone())) == null ? null : ADateJvmKt.toDate(jodaDateTime4));
        Comparable<JodaDateTime> comparable = SpecIntersectsKt.startTimeAtDay($this$calcDatesInterval, startDateInEventZone);
        boolean bl = false;
        boolean bl2 = false;
        JodaDateTime it = comparable;
        boolean bl3 = false;
        JodaDateTime jodaDateTime6 = jodaDateTime4 = it.compareTo(intervalStart) >= 0 ? comparable : null;
        if (jodaDateTime4 == null) {
            JodaDateTime jodaDateTime7 = SpecIntersectsKt.startTimeAtDay($this$calcDatesInterval, ADateJvmKt.plusDays(startDateInEventZone, 1));
            bl2 = false;
            boolean bl4 = false;
            JodaDateTime it2 = jodaDateTime7;
            boolean bl5 = false;
            JodaDateTime jodaDateTime8 = comparable = intervalEnd == null || it2.compareTo(intervalEnd) < 0 ? jodaDateTime7 : null;
            jodaDateTime3 = comparable == null ? intervalStart : comparable;
        } else {
            jodaDateTime3 = jodaDateTime4;
        }
        JodaDateTime firstOccurrenceOnInterval = jodaDateTime3;
        comparable = endDateInEventZone;
        if (comparable == null) {
            jodaDateTime2 = null;
        } else {
            JodaDateTime jodaDateTime9;
            Comparable<JodaDateTime> comparable2 = comparable;
            bl2 = false;
            boolean bl6 = false;
            Comparable<JodaDateTime> date2 = comparable2;
            boolean bl7 = false;
            JodaDateTime jodaDateTime10 = SpecIntersectsKt.startTimeAtDay($this$calcDatesInterval, (JodaDate)date2);
            boolean bl8 = false;
            boolean bl9 = false;
            JodaDateTime startTime = jodaDateTime10;
            boolean bl10 = false;
            JodaDateTime jodaDateTime11 = jodaDateTime9 = startTime.compareTo(intervalEnd) < 0 ? jodaDateTime10 : null;
            if (jodaDateTime9 == null) {
                JodaDateTime jodaDateTime12 = SpecIntersectsKt.startTimeAtDay($this$calcDatesInterval, ADateJvmKt.plusDays((JodaDate)date2, -1));
                bl9 = false;
                boolean bl11 = false;
                JodaDateTime it3 = jodaDateTime12;
                boolean bl12 = false;
                JodaDateTime jodaDateTime13 = jodaDateTime10 = it3.compareTo(intervalStart) >= 0 ? jodaDateTime12 : null;
                jodaDateTime2 = jodaDateTime10 == null ? intervalEnd : jodaDateTime10;
            } else {
                jodaDateTime2 = jodaDateTime9;
            }
        }
        JodaDateTime lastOccurrenceOnInterval = jodaDateTime2;
        JodaDate inclusiveStartDate = ADateJvmKt.toDate(ADateJvmKt.withZone(firstOccurrenceOnInterval, targetTimezone));
        JodaDateTime jodaDateTime14 = lastOccurrenceOnInterval;
        JodaDate jodaDate2 = endDate = jodaDateTime14 == null ? null : ((jodaDateTime = ADateJvmKt.withZone(jodaDateTime14, targetTimezone)) == null ? null : ADateJvmKt.toDate(jodaDateTime));
        if (jodaDate2 == null) {
            jodaDate = null;
        } else {
            JodaDate jodaDate3 = ControlFlowKt.chainIf(jodaDate2, endDate.compareTo(inclusiveStartDate) < 0, (Function1)new Function1<JodaDate, JodaDate>(inclusiveStartDate){
                final /* synthetic */ JodaDate $inclusiveStartDate;
                {
                    this.$inclusiveStartDate = $inclusiveStartDate;
                    super(1);
                }

                @NotNull
                public final JodaDate invoke(@NotNull JodaDate $this$chainIf) {
                    Intrinsics.checkNotNullParameter((Object)$this$chainIf, (String)"$this$chainIf");
                    return this.$inclusiveStartDate;
                }
            });
            jodaDate = jodaDate3 == null ? null : ADateJvmKt.plusDays(jodaDate3, 1);
        }
        JodaDate exclusiveEndDate2 = jodaDate;
        return new DatesInterval(inclusiveStartDate, exclusiveEndDate2);
    }

    @NotNull
    public static final ClosedTimeInterval timeIntervalAtDay(@NotNull CalendarEventSpec $this$timeIntervalAtDay, @NotNull JodaDate day) {
        Intrinsics.checkNotNullParameter((Object)$this$timeIntervalAtDay, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)day, (String)"day");
        JodaDateTime start2 = SpecIntersectsKt.startTimeAtDay($this$timeIntervalAtDay, day);
        JodaDateTime end = ADateJvmKt.plusMinutes(start2, EventCountersKt.durationInMinutes($this$timeIntervalAtDay));
        return new ClosedTimeInterval(start2, end);
    }

    @Nullable
    public static final JodaDateTime lastOccurrenceStart(@NotNull CalendarEventSpec event2) {
        JodaDateTime jodaDateTime;
        int n;
        RecurrenceRuleFreq freq;
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        JodaDateTime startInZone = ADateJvmKt.withZone(event2.getStart(), event2.getTimezone());
        if (event2.getRecurrenceRule() == null) {
            return startInZone;
        }
        RecurrenceRuleEnds ends = event2.getRecurrenceRule().getEnds();
        JodaDate jodaDate = SpecIntersectsKt.lastOccurrenceStartLocalDate(ends, freq = event2.getRecurrenceRule().getFreq(), startInZone);
        if (jodaDate == null) {
            return null;
        }
        JodaDate lastDateInZone = jodaDate;
        JodaDateTime startTimeAtDay = SpecIntersectsKt.startTimeAtDay(event2, lastDateInZone);
        JodaDate nextOccurrence = EventCountersKt.nextOccurrence(event2, startTimeAtDay, true);
        if (nextOccurrence != null) {
            return startTimeAtDay;
        }
        Object object = freq;
        if (object instanceof RecurrenceRuleFreq.Daily) {
            n = 1 * ((RecurrenceRuleFreq.Daily)freq).getInterval();
        } else if (object instanceof RecurrenceRuleFreq.Weekly) {
            n = 7 * ((RecurrenceRuleFreq.Weekly)freq).getInterval();
        } else if (object instanceof RecurrenceRuleFreq.MonthlyOnFirstWeekday) {
            n = 31 * ((RecurrenceRuleFreq.MonthlyOnFirstWeekday)freq).getInterval();
        } else if (object instanceof RecurrenceRuleFreq.MonthlyOnLastWeekday) {
            n = 31 * ((RecurrenceRuleFreq.MonthlyOnLastWeekday)freq).getInterval();
        } else if (object instanceof RecurrenceRuleFreq.MonthlyOnDate) {
            n = 31 * ((RecurrenceRuleFreq.MonthlyOnDate)freq).getInterval();
        } else if (object instanceof RecurrenceRuleFreq.MonthlyOnStartDate) {
            n = 31 * ((RecurrenceRuleFreq.MonthlyOnStartDate)freq).getInterval();
        } else if (object instanceof RecurrenceRuleFreq.Yearly) {
            n = 365 * ((RecurrenceRuleFreq.Yearly)freq).getInterval();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        int periodInDays = n;
        object = EventCountersKt.nextOccurrence(event2, ADateJvmKt.plusDays(startTimeAtDay, -periodInDays), true);
        if (object == null) {
            jodaDateTime = null;
        } else {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            jodaDateTime = SpecIntersectsKt.startTimeAtDay(event2, (JodaDate)it);
        }
        return jodaDateTime;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final JodaDate lastOccurrenceStartLocalDate(@NotNull RecurrenceRuleEnds ends, @NotNull RecurrenceRuleFreq freq, @NotNull JodaDateTime start2) {
        Intrinsics.checkNotNullParameter((Object)ends, (String)"ends");
        Intrinsics.checkNotNullParameter((Object)freq, (String)"freq");
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        RecurrenceRuleEnds recurrenceRuleEnds = ends;
        if (recurrenceRuleEnds instanceof RecurrenceRuleEnds.OnDate) {
            return ((RecurrenceRuleEnds.OnDate)ends).getDate();
        }
        if (recurrenceRuleEnds instanceof RecurrenceRuleEnds.TotalCount) {
            int reps = ((RecurrenceRuleEnds.TotalCount)ends).getCount();
            RecurrenceRuleFreq recurrenceRuleFreq = freq;
            if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.Daily) {
                return ADateJvmKt.toDate(ADateJvmKt.plusDays(start2, (reps - 1) * ((RecurrenceRuleFreq.Daily)freq).getInterval()));
            }
            if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.Weekly) {
                void $this$filterTo$iv$iv;
                Collection collection = ((RecurrenceRuleFreq.Weekly)freq).getWeekdays();
                boolean bl = false;
                int perWeek = collection.size();
                if (perWeek == 0) {
                    return null;
                }
                int intervals = (reps - 1) / perWeek;
                int wkDayCnt = (reps - 1) % perWeek;
                Iterable $this$filter$iv = (Iterable)new IntRange(0, 6);
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    int shift = ((Number)element$iv$iv).intValue();
                    boolean bl2 = false;
                    if (!((RecurrenceRuleFreq.Weekly)freq).getWeekdays().contains(ADateJvmKt.getWeekday(ADateJvmKt.plusDays(start2, intervals * ((RecurrenceRuleFreq.Weekly)freq).getInterval() * 7 + shift)))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                int shift = ((Number)((List)destination$iv$iv).get(wkDayCnt)).intValue();
                return ADateJvmKt.toDate(ADateJvmKt.plusDays(start2, intervals * ((RecurrenceRuleFreq.Weekly)freq).getInterval() * 7 + shift));
            }
            if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.Yearly) {
                boolean leapYearEvent = ADateJvmKt.getMonth(start2) == 2 && ADateJvmKt.getDayOfMonth(start2) == 29;
                int yearsBetweenEvents = leapYearEvent ? Math.INSTANCE.lcd(((RecurrenceRuleFreq.Yearly)freq).getInterval(), 4) : ((RecurrenceRuleFreq.Yearly)freq).getInterval();
                return ADateJvmKt.toDate(ADateJvmKt.plusYears(start2, (reps - 1) * yearsBetweenEvents));
            }
            if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnDate) {
                int yearsBetweenEvents = ADateJvmKt.getDayOfMonth(start2);
                JodaDate firstStartDate = yearsBetweenEvents == ((RecurrenceRuleFreq.MonthlyOnDate)freq).getDay() ? ADateJvmKt.toDate(start2) : SpecIntersectsKt.toNextDateWithMonthDay(ADateJvmKt.toDate(start2), ((RecurrenceRuleFreq.MonthlyOnDate)freq).getDay(), 1);
                return ADateJvmKt.getDayOfMonth(firstStartDate) < 29 ? ADateJvmKt.plusMonths(firstStartDate, (reps - 1) * ((RecurrenceRuleFreq.MonthlyOnDate)freq).getInterval()) : SpecIntersectsKt.toLastDateWithMonthDay(firstStartDate, ADateJvmKt.getDayOfMonth(firstStartDate), ((RecurrenceRuleFreq.MonthlyOnDate)freq).getInterval(), reps);
            }
            if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnStartDate) {
                JodaDate firstStartDate = ADateJvmKt.toDate(start2);
                return ADateJvmKt.getDayOfMonth(firstStartDate) < 29 ? ADateJvmKt.plusMonths(firstStartDate, (reps - 1) * ((RecurrenceRuleFreq.MonthlyOnStartDate)freq).getInterval()) : SpecIntersectsKt.toLastDateWithMonthDay(firstStartDate, ADateJvmKt.getDayOfMonth(firstStartDate), ((RecurrenceRuleFreq.MonthlyOnStartDate)freq).getInterval(), reps);
            }
            if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnFirstWeekday) {
                JodaDate jodaDate;
                JodaDate startThisMonth = SpecIntersectsKt.startThisMonth(ADateJvmKt.getYear(start2), ADateJvmKt.getMonth(start2), (RecurrenceRuleFreq.MonthlyOnFirstWeekday)freq);
                if (startThisMonth.compareTo(ADateJvmKt.toDate(start2)) >= 0) {
                    jodaDate = startThisMonth;
                } else {
                    JodaDate nextMonth = ADateJvmKt.plusMonths(ADateJvmKt.withDay(ADateJvmKt.toDate(start2), 1), 1);
                    jodaDate = SpecIntersectsKt.startThisMonth(ADateJvmKt.getYear(nextMonth), ADateJvmKt.getMonth(nextMonth), (RecurrenceRuleFreq.MonthlyOnFirstWeekday)freq);
                }
                JodaDate firstStartDate = jodaDate;
                JodaDate lastMonth = ADateJvmKt.plusMonths(firstStartDate, (reps - 1) * ((RecurrenceRuleFreq.MonthlyOnFirstWeekday)freq).getInterval());
                return SpecIntersectsKt.startThisMonth(ADateJvmKt.getYear(lastMonth), ADateJvmKt.getMonth(lastMonth), (RecurrenceRuleFreq.MonthlyOnFirstWeekday)freq);
            }
            if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnLastWeekday) {
                JodaDate jodaDate;
                JodaDate startThisMonth = SpecIntersectsKt.startThisMonth(ADateJvmKt.getYear(start2), ADateJvmKt.getMonth(start2), (RecurrenceRuleFreq.MonthlyOnLastWeekday)freq);
                if (startThisMonth.compareTo(ADateJvmKt.toDate(start2)) >= 0) {
                    jodaDate = startThisMonth;
                } else {
                    JodaDate nextMonth = ADateJvmKt.plusMonths(ADateJvmKt.withDay(ADateJvmKt.toDate(start2), 1), 1);
                    jodaDate = SpecIntersectsKt.startThisMonth(ADateJvmKt.getYear(nextMonth), ADateJvmKt.getMonth(nextMonth), (RecurrenceRuleFreq.MonthlyOnLastWeekday)freq);
                }
                JodaDate firstStartDate = jodaDate;
                JodaDate lastMonth = ADateJvmKt.plusMonths(firstStartDate, (reps - 1) * ((RecurrenceRuleFreq.MonthlyOnLastWeekday)freq).getInterval());
                return SpecIntersectsKt.startThisMonth(ADateJvmKt.getYear(lastMonth), ADateJvmKt.getMonth(lastMonth), (RecurrenceRuleFreq.MonthlyOnLastWeekday)freq);
            }
            throw new NoWhenBranchMatchedException();
        }
        return null;
    }

    @NotNull
    public static final JodaDate toLastDateWithMonthDay(@NotNull JodaDate $this$toLastDateWithMonthDay, int day, int interval2, int repetitions) {
        Intrinsics.checkNotNullParameter((Object)$this$toLastDateWithMonthDay, (String)"<this>");
        JodaDate nextDay = null;
        nextDay = $this$toLastDateWithMonthDay;
        int n = repetitions - 1;
        boolean bl = false;
        int n2 = 0;
        n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            int it = n2++;
            boolean bl2 = false;
            nextDay = SpecIntersectsKt.toNextDateWithMonthDay(nextDay, day, interval2);
        }
        return nextDay;
    }

    @NotNull
    public static final JodaDate toNextDateWithMonthDay(@NotNull JodaDate $this$toNextDateWithMonthDay, int day, int interval2) {
        Intrinsics.checkNotNullParameter((Object)$this$toNextDateWithMonthDay, (String)"<this>");
        JodaDate nextDate = null;
        JodaDate nextMonth = SpecIntersectsKt.monthStart($this$toNextDateWithMonthDay);
        do {
            nextDate = ADateKt.withDayIfExist(nextMonth, day);
            nextMonth = ADateJvmKt.plusMonths(nextMonth, interval2);
        } while (nextDate == null || nextDate.compareTo($this$toNextDateWithMonthDay) <= 0);
        return nextDate;
    }

    @NotNull
    public static final JodaDate toNextYearWithYearDay(@NotNull JodaDate $this$toNextYearWithYearDay, int dayInMonth, int monthInYear, int interval2) {
        Intrinsics.checkNotNullParameter((Object)$this$toNextYearWithYearDay, (String)"<this>");
        JodaDate nextDate = null;
        JodaDate nextYear = SpecIntersectsKt.yearStart($this$toNextYearWithYearDay);
        do {
            nextDate = ADateKt.withDayIfExist(ADateJvmKt.plusMonths(nextYear, monthInYear - 1), dayInMonth);
            nextYear = ADateJvmKt.plusYears(nextYear, interval2);
        } while (nextDate == null || nextDate.compareTo($this$toNextYearWithYearDay) <= 0);
        return nextDate;
    }

    @NotNull
    public static final JodaDate monthStart(@NotNull JodaDate $this$monthStart) {
        Intrinsics.checkNotNullParameter((Object)$this$monthStart, (String)"<this>");
        return ADateJvmKt.withDay($this$monthStart, 1);
    }

    @NotNull
    public static final JodaDate yearStart(@NotNull JodaDate $this$yearStart) {
        Intrinsics.checkNotNullParameter((Object)$this$yearStart, (String)"<this>");
        return ADateJvmKt.aDate(ADateJvmKt.getYear($this$yearStart), 1, 1);
    }

    @NotNull
    public static final JodaDate startThisMonth(int year, int month, @NotNull RecurrenceRuleFreq.MonthlyOnFirstWeekday freq) {
        Intrinsics.checkNotNullParameter((Object)freq, (String)"freq");
        JodaDate start2 = ADateJvmKt.plusDays(ADateJvmKt.aDate(year, month, 1), freq.getShift() * 7);
        int n = 0;
        do {
            int i;
            JodaDate ret;
            if (ADateJvmKt.getWeekday(ret = ADateJvmKt.plusDays(start2, i = n++)) != freq.getWeekday()) continue;
            return ret;
        } while (n <= 6);
        return start2;
    }

    @NotNull
    public static final JodaDate startThisMonth(int year, int month, @NotNull RecurrenceRuleFreq.MonthlyOnLastWeekday freq) {
        Intrinsics.checkNotNullParameter((Object)freq, (String)"freq");
        JodaDate lastDay = ADateJvmKt.plusDays(ADateJvmKt.plusMonths(ADateJvmKt.aDate(year, month, 1), 1), -1);
        int n = 0;
        do {
            int i;
            JodaDate ret;
            if (ADateJvmKt.getWeekday(ret = ADateJvmKt.plusDays(lastDay, -(i = n++))) != freq.getWeekday()) continue;
            return ret;
        } while (n <= 6);
        return lastDay;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$logger$iv;
        KLoggers kLoggers = KLoggers.INSTANCE;
        String fallbackName$iv = "Spec";
        boolean $i$f$logger = false;
        log = $this$logger$iv.logger((Function0<String>)((Function0)new Function0<String>(fallbackName$iv){
            final /* synthetic */ String $fallbackName;
            {
                this.$fallbackName = $fallbackName;
                super(0);
            }

            @Nullable
            public final String invoke() {
                return this.$fallbackName;
            }
        }));
    }
}

