/*
 * Decompiled with CFR 0.152.
 */
package circlet.common.calendar;

import circlet.common.calendar.RecurrenceRuleFreq;
import circlet.common.calendar.RelativeDate;
import circlet.platform.api.JodaDate;
import circlet.platform.api.Weekday;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\f\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004H&J\b\u0010\u0005\u001a\u00020\u0006H&J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH&J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH&J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0000H\u0016J\b\u0010\u0011\u001a\u00020\u0012H&J\u0014\u0010\u0013\u001a\u00020\u00122\n\u0010\u0014\u001a\u00060\u0003j\u0002`\u0004H&\u00a8\u0006\u0015"}, d2={"Lcirclet/common/calendar/EventCounter;", "", "getCurrentDate", "Lcirclet/platform/api/JodaDate;", "Lcirclet/platform/api/ADate;", "getFrequency", "Lcirclet/common/calendar/RecurrenceRuleFreq;", "getFrequencyOrder", "", "getRelativity", "Lcirclet/common/calendar/RelativeDate;", "getWeekdays", "", "Lcirclet/platform/api/Weekday;", "haveCommonWeekdays", "", "event", "toNextEvent", "", "toNextEventAfterDate", "targetDate", "common"})
public interface EventCounter {
    public void toNextEvent();

    public void toNextEventAfterDate(@NotNull JodaDate var1);

    @NotNull
    public JodaDate getCurrentDate();

    @NotNull
    public List<Weekday> getWeekdays();

    @NotNull
    public RecurrenceRuleFreq getFrequency();

    @NotNull
    public RelativeDate getRelativity();

    public boolean haveCommonWeekdays(@NotNull EventCounter var1);

    public int getFrequencyOrder();

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        public static boolean haveCommonWeekdays(@NotNull EventCounter this_, @NotNull EventCounter event2) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
            return CollectionsKt.any((Iterable)CollectionsKt.intersect((Iterable)this_.getWeekdays(), (Iterable)event2.getWeekdays()));
        }

        public static int getFrequencyOrder(@NotNull EventCounter this_) {
            int n;
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            RecurrenceRuleFreq recurrenceRuleFreq = this_.getFrequency();
            if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.Daily) {
                n = 0;
            } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.Weekly) {
                n = 1;
            } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnFirstWeekday) {
                n = 2;
            } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnLastWeekday) {
                n = 3;
            } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnDate) {
                n = 4;
            } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnStartDate) {
                n = 5;
            } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.Yearly) {
                n = 6;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return n;
        }
    }
}

