/*
 * Decompiled with CFR 0.152.
 */
package circlet.common.calendar;

import circlet.common.calendar.EventCountersKt;
import circlet.common.calendar.SpecIntersectsKt;
import circlet.common.calendar.TimeInterval;
import circlet.platform.api.ADateJvmKt;
import circlet.platform.api.ADateKt;
import circlet.platform.api.ATimeZone;
import circlet.platform.api.JodaDate;
import circlet.platform.api.JodaDateTime;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import libraries.klogging.KLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0005\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0000J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00002\u0006\u0010\r\u001a\u00020\u0000J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00000\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0011\u001a\u00020\u0012R\u0015\u0010\u0007\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0015\u0010\n\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0016"}, d2={"Lcirclet/common/calendar/ClosedTimeInterval;", "Lcirclet/common/calendar/TimeInterval;", "start", "Lcirclet/platform/api/JodaDateTime;", "Lcirclet/platform/api/ADateTime;", "endInclusive", "(Lcirclet/platform/api/JodaDateTime;Lcirclet/platform/api/JodaDateTime;)V", "closedEndExclusive", "getClosedEndExclusive", "()Lcirclet/platform/api/JodaDateTime;", "closedEndInclusive", "getClosedEndInclusive", "add", "interval", "intersection", "splitByDates", "", "timezone", "Lcirclet/platform/api/ATimeZone;", "toMinutesRangeInZone", "Lkotlin/ranges/ClosedRange;", "", "common"})
public final class ClosedTimeInterval
extends TimeInterval {
    @NotNull
    private final JodaDateTime closedEndInclusive;
    @NotNull
    private final JodaDateTime closedEndExclusive;

    public ClosedTimeInterval(@NotNull JodaDateTime start2, @NotNull JodaDateTime endInclusive) {
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        Intrinsics.checkNotNullParameter((Object)endInclusive, (String)"endInclusive");
        super(start2, endInclusive);
        JodaDateTime jodaDateTime = this.getEndInclusive();
        Intrinsics.checkNotNull((Object)jodaDateTime);
        this.closedEndInclusive = jodaDateTime;
        jodaDateTime = this.getEndExclusive();
        Intrinsics.checkNotNull((Object)jodaDateTime);
        this.closedEndExclusive = jodaDateTime;
    }

    @NotNull
    public final JodaDateTime getClosedEndInclusive() {
        return this.closedEndInclusive;
    }

    @NotNull
    public final JodaDateTime getClosedEndExclusive() {
        return this.closedEndExclusive;
    }

    @Nullable
    public final ClosedTimeInterval intersection(@NotNull ClosedTimeInterval interval2) {
        Intrinsics.checkNotNullParameter((Object)interval2, (String)"interval");
        JodaDateTime[] jodaDateTimeArray = new JodaDateTime[]{this.getStart(), interval2.getStart()};
        JodaDateTime intersectionStart = EventCountersKt.access$maxTime(jodaDateTimeArray);
        JodaDateTime[] jodaDateTimeArray2 = new JodaDateTime[]{this.closedEndInclusive, interval2.closedEndInclusive};
        JodaDateTime intersectionEnd = EventCountersKt.access$minTime(jodaDateTimeArray2);
        return intersectionStart.compareTo(intersectionEnd) < 0 ? new ClosedTimeInterval(intersectionStart, intersectionEnd) : null;
    }

    @NotNull
    public final ClosedTimeInterval add(@NotNull ClosedTimeInterval interval2) {
        Intrinsics.checkNotNullParameter((Object)interval2, (String)"interval");
        JodaDateTime[] jodaDateTimeArray = new JodaDateTime[]{this.getStart(), interval2.getStart()};
        JodaDateTime start2 = EventCountersKt.access$minTime(jodaDateTimeArray);
        JodaDateTime[] jodaDateTimeArray2 = new JodaDateTime[]{this.closedEndInclusive, interval2.closedEndInclusive};
        JodaDateTime end = EventCountersKt.access$maxTime(jodaDateTimeArray2);
        return new ClosedTimeInterval(start2, end);
    }

    @NotNull
    public final ClosedRange<Integer> toMinutesRangeInZone(@NotNull ATimeZone timezone) {
        Intrinsics.checkNotNullParameter((Object)timezone, (String)"timezone");
        int duration = ADateKt.minutesDifference(this.getStart(), this.closedEndInclusive);
        boolean bl = duration > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "incorrect time range: " + this + ", duration is " + duration;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int startMinute = ADateJvmKt.getMinuteOfDay(ADateJvmKt.withZone(this.getStart(), timezone));
        int endInclusive = startMinute + duration;
        return (ClosedRange)new IntRange(startMinute, endInclusive);
    }

    @NotNull
    public final List<ClosedTimeInterval> splitByDates(@NotNull ATimeZone timezone) {
        Intrinsics.checkNotNullParameter((Object)timezone, (String)"timezone");
        JodaDateTime startTime = ADateJvmKt.withZone(this.getStart(), timezone);
        JodaDateTime endTime = ADateJvmKt.withZone(this.closedEndInclusive, timezone);
        JodaDate endDate = ADateJvmKt.toDate(endTime);
        JodaDateTime currentTime = null;
        currentTime = startTime;
        boolean bl = false;
        List datesIntervals = new ArrayList();
        while (ADateJvmKt.toDate(currentTime).compareTo(endDate) < 0) {
            JodaDateTime splitTime = ADateJvmKt.withZone(ADateJvmKt.toDateTimeAtStartOfDay(ADateJvmKt.plusDays(ADateJvmKt.toDate(currentTime), 1), timezone), timezone);
            JodaDateTime lastMinuteOfDay = ADateJvmKt.plusMinutes(splitTime, -1);
            if (ADateJvmKt.getMillis(currentTime) <= ADateJvmKt.getMillis(lastMinuteOfDay)) {
                datesIntervals.add(new ClosedTimeInterval(currentTime, lastMinuteOfDay));
            } else {
                KLogger this_$iv = SpecIntersectsKt.getLog();
                boolean $i$f$warn = false;
                if (this_$iv.isWarnEnabled()) {
                    KLogger kLogger = this_$iv;
                    boolean bl2 = false;
                    String string = "Time interval duration is less than a minute, interval is skipped: " + ADateJvmKt.formatFullDateTime(currentTime) + " - " + ADateJvmKt.formatFullDateTime(lastMinuteOfDay) + ".Event start time = " + ADateJvmKt.formatFullDateTime(startTime) + ", event end inclusive time = " + ADateJvmKt.formatFullDateTime(endTime) + ", splitting by dates in timezone " + timezone.getId();
                    kLogger.warn(string);
                }
            }
            currentTime = splitTime;
        }
        if (!Intrinsics.areEqual((Object)currentTime, (Object)endTime)) {
            datesIntervals.add(new ClosedTimeInterval(currentTime, endTime));
        }
        return datesIntervals;
    }
}

