/*
 * Decompiled with CFR 0.152.
 */
package circlet.client.api.fields.type;

import circlet.client.api.fields.CFConstraint;
import circlet.client.api.fields.CFInputValue;
import circlet.client.api.fields.type.StringCFTypeKt;
import circlet.client.api.fields.type.StringCFValue;
import circlet.client.api.fields.type.StringListCFValue;
import circlet.platform.api.serialization.ApiSerializable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiSerializable
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B-\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0010\u001a\u00020\u0006H\u0016J\b\u0010\u0011\u001a\u00020\u0006H\u0016J,\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00130\u0019H\u0016J.\u0010\u001a\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00130\u0019H\u0002R\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\u000e\u0010\nR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u001b"}, d2={"Lcirclet/client/api/fields/type/StringCFConstraint;", "Lcirclet/client/api/fields/CFConstraint;", "min", "", "max", "pattern", "", "message", "(Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;)V", "getMax", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getMessage", "()Ljava/lang/String;", "getMin", "getPattern", "actualMessage", "defaultMessage", "validate", "", "value", "Lcirclet/client/api/fields/CFInputValue;", "validateNullValue", "", "error", "Lkotlin/Function1;", "validateString", "client-api"})
public final class StringCFConstraint
extends CFConstraint {
    @Nullable
    private final Integer min;
    @Nullable
    private final Integer max;
    @Nullable
    private final String pattern;
    @Nullable
    private final String message;

    public StringCFConstraint(@Nullable Integer min, @Nullable Integer max, @Nullable String pattern, @Nullable String message2) {
        super(StringCFTypeKt.getStringCFTag());
        this.min = min;
        this.max = max;
        this.pattern = pattern;
        this.message = message2;
    }

    @Nullable
    public final Integer getMin() {
        return this.min;
    }

    @Nullable
    public final Integer getMax() {
        return this.max;
    }

    @Nullable
    public final String getPattern() {
        return this.pattern;
    }

    @Nullable
    public final String getMessage() {
        return this.message;
    }

    @Override
    public void validate(@NotNull CFInputValue value2, boolean validateNullValue, @NotNull Function1<? super String, Unit> error2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter(error2, (String)"error");
        CFInputValue cFInputValue = value2;
        if (cFInputValue instanceof StringCFValue) {
            this.validateString(((StringCFValue)value2).getValue(), validateNullValue, error2);
        } else if (cFInputValue instanceof StringListCFValue) {
            Iterable $this$forEach$iv = ((StringListCFValue)value2).getValues();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                this.validateString(it, validateNullValue, error2);
            }
        }
    }

    private final void validateString(String value2, boolean validateNullValue, Function1<? super String, Unit> error2) {
        if (value2 == null) {
            if (validateNullValue) {
                error2.invoke((Object)this.actualMessage());
            }
            return;
        }
        String string = this.pattern;
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            if (!new Regex(it).matches((CharSequence)value2)) {
                error2.invoke((Object)this.actualMessage());
                return;
            }
        }
        if (this.min != null && value2.length() < this.min || this.max != null && value2.length() > this.max) {
            error2.invoke((Object)this.actualMessage());
        }
    }

    @Override
    @NotNull
    public String actualMessage() {
        String string = this.message;
        return string == null ? this.defaultMessage() : string;
    }

    @Override
    @NotNull
    public String defaultMessage() {
        String andMatchesWithPattern;
        String string = andMatchesWithPattern = this.pattern != null ? Intrinsics.stringPlus((String)" and matches the pattern ", (Object)this.pattern) : "";
        return this.min == null && this.max != null ? "Enter a value that contains fewer than " + this.max + " characters" + andMatchesWithPattern : (this.min != null && this.max == null ? "Enter a value that contains more than " + this.min + " characters" + andMatchesWithPattern : (this.min != null && this.max != null ? (Intrinsics.areEqual((Object)this.min, (Object)this.max) ? "Enter a value that contains exactly " + this.min + " characters" + andMatchesWithPattern : "Enter a value that contains between " + this.min + " and " + this.max + " characters" + andMatchesWithPattern) : (this.pattern != null ? Intrinsics.stringPlus((String)"Enter a value that matches the following pattern: ", (Object)this.pattern) : "")));
    }
}

