/*
 * Decompiled with CFR 0.152.
 */
package circlet.client.api.fields.type;

import circlet.client.api.fields.CFConstraint;
import circlet.client.api.fields.CFInputValue;
import circlet.client.api.fields.type.DateCFTypeKt;
import circlet.client.api.fields.type.DateCFValue;
import circlet.platform.api.JodaDate;
import circlet.platform.api.PrimitivesExKt;
import circlet.platform.api.serialization.ApiSerializable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.date.DateFormat;

@ApiSerializable
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B/\u0012\u000e\u0010\u0002\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0004\u0012\u000e\u0010\u0005\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000e\u001a\u00020\u0007H\u0016J\b\u0010\u000f\u001a\u00020\u0007H\u0016J,\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00110\u0017H\u0016R\u0019\u0010\u0005\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0019\u0010\u0002\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0018"}, d2={"Lcirclet/client/api/fields/type/DateCFConstraint;", "Lcirclet/client/api/fields/CFConstraint;", "min", "Lcirclet/platform/api/JodaDate;", "Lcirclet/platform/api/ADate;", "max", "message", "", "(Lcirclet/platform/api/JodaDate;Lcirclet/platform/api/JodaDate;Ljava/lang/String;)V", "getMax", "()Lcirclet/platform/api/JodaDate;", "getMessage", "()Ljava/lang/String;", "getMin", "actualMessage", "defaultMessage", "validate", "", "value", "Lcirclet/client/api/fields/CFInputValue;", "validateNullValue", "", "error", "Lkotlin/Function1;", "client-api"})
public final class DateCFConstraint
extends CFConstraint {
    @Nullable
    private final JodaDate min;
    @Nullable
    private final JodaDate max;
    @Nullable
    private final String message;

    public DateCFConstraint(@Nullable JodaDate min, @Nullable JodaDate max, @Nullable String message2) {
        super(DateCFTypeKt.getDateCFTag());
        this.min = min;
        this.max = max;
        this.message = message2;
    }

    @Nullable
    public final JodaDate getMin() {
        return this.min;
    }

    @Nullable
    public final JodaDate getMax() {
        return this.max;
    }

    @Nullable
    public final String getMessage() {
        return this.message;
    }

    @Override
    public void validate(@NotNull CFInputValue value2, boolean validateNullValue, @NotNull Function1<? super String, Unit> error2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter(error2, (String)"error");
        if (value2 instanceof DateCFValue) {
            if (((DateCFValue)value2).getValue() == null) {
                if (validateNullValue) {
                    error2.invoke((Object)this.actualMessage());
                }
                return;
            }
            if (this.min != null && PrimitivesExKt.isBefore(((DateCFValue)value2).getValue(), this.min) || this.max != null && PrimitivesExKt.isAfter(((DateCFValue)value2).getValue(), this.max)) {
                error2.invoke((Object)this.actualMessage());
            }
        }
    }

    @Override
    @NotNull
    public String actualMessage() {
        String string = this.message;
        return string == null ? this.defaultMessage() : string;
    }

    @Override
    @NotNull
    public String defaultMessage() {
        return this.min == null && this.max != null ? Intrinsics.stringPlus((String)"Select a date on or before ", (Object)PrimitivesExKt.format(this.max, DateFormat.DAY_MONTH_AND_YEAR)) : (this.min != null && this.max == null ? Intrinsics.stringPlus((String)"Select a date on or after ", (Object)PrimitivesExKt.format(this.min, DateFormat.DAY_MONTH_AND_YEAR)) : (this.min != null && this.max != null ? "Select a date between " + PrimitivesExKt.format(this.min, DateFormat.DAY_MONTH_AND_YEAR) + " and " + PrimitivesExKt.format(this.max, DateFormat.DAY_MONTH_AND_YEAR) : ""));
    }
}

