/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.java.steps;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.CreateClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import cucumber.runtime.snippets.CamelCaseConcatenator;
import cucumber.runtime.snippets.Concatenator;
import cucumber.runtime.snippets.FunctionNameGenerator;
import cucumber.runtime.snippets.Snippet;
import cucumber.runtime.snippets.SnippetGenerator;
import gherkin.formatter.model.Step;
import io.cucumber.cucumberexpressions.CucumberExpressionGenerator;
import io.cucumber.cucumberexpressions.GeneratedExpression;
import io.cucumber.cucumberexpressions.ParameterTypeRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.AbstractStepDefinitionCreator;
import org.jetbrains.plugins.cucumber.java.CucumberJavaUtil;
import org.jetbrains.plugins.cucumber.java.steps.AnnotationPackageProvider;
import org.jetbrains.plugins.cucumber.java.steps.JavaSnippet;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;

public class JavaStepDefinitionCreator
extends AbstractStepDefinitionCreator {
    private static final String STEP_DEFINITION_SUFFIX = "MyStepdefs";
    private static final String FILE_TEMPLATE_CUCUMBER_JAVA_STEP_DEFINITION_JAVA = "Cucumber Java Step Definition.java";
    private static final String DEFAULT_STEP_KEYWORD = "Given";
    private static final Logger LOG = Logger.getInstance(JavaStepDefinitionCreator.class);

    @NotNull
    public PsiFile createStepDefinitionContainer(@NotNull PsiDirectory dir, @NotNull String name) {
        if (dir == null) {
            JavaStepDefinitionCreator.$$$reportNull$$$0(0);
        }
        if (name == null) {
            JavaStepDefinitionCreator.$$$reportNull$$$0(1);
        }
        PsiClass newClass = CreateClassUtil.createClassNamed((String)name, (String)"#DEFAULT_CLASS_TEMPLATE", (PsiDirectory)dir);
        assert (newClass != null);
        PsiFile psiFile = newClass.getContainingFile();
        if (psiFile == null) {
            JavaStepDefinitionCreator.$$$reportNull$$$0(2);
        }
        return psiFile;
    }

    public boolean createStepDefinition(@NotNull GherkinStep step, @NotNull PsiFile file, boolean withTemplate) {
        if (step == null) {
            JavaStepDefinitionCreator.$$$reportNull$$$0(3);
        }
        if (file == null) {
            JavaStepDefinitionCreator.$$$reportNull$$$0(4);
        }
        if (!(file instanceof PsiClassOwner)) {
            return false;
        }
        Project project = file.getProject();
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        assert (editor != null);
        this.closeActiveTemplateBuilders(file);
        PsiClass clazz = (PsiClass)PsiTreeUtil.getChildOfType((PsiElement)file, PsiClass.class);
        if (clazz != null) {
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            PsiMethod element = JavaStepDefinitionCreator.buildStepDefinitionByStep(step, file.getLanguage());
            PsiMethod addedElement = (PsiMethod)clazz.add((PsiElement)element);
            addedElement = (PsiMethod)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)addedElement);
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)addedElement);
            editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
            assert (editor != null);
            PsiParameterList blockVars = addedElement.getParameterList();
            PsiCodeBlock body = addedElement.getBody();
            PsiAnnotation annotation = addedElement.getModifierList().getAnnotations()[0];
            PsiNameValuePair regexpElement = annotation.getParameterList().getAttributes()[0];
            if (withTemplate) {
                this.runTemplateBuilderOnAddedStep(editor, (PsiElement)addedElement, (PsiElement)regexpElement, blockVars, body);
            }
        }
        return true;
    }

    void runTemplateBuilderOnAddedStep(final @NotNull Editor editor, @NotNull PsiElement addedElement, PsiElement regexpElement, PsiParameterList blockVars, PsiCodeBlock body) {
        if (editor == null) {
            JavaStepDefinitionCreator.$$$reportNull$$$0(5);
        }
        if (addedElement == null) {
            JavaStepDefinitionCreator.$$$reportNull$$$0(6);
        }
        final Project project = regexpElement.getProject();
        TemplateBuilderImpl builder = (TemplateBuilderImpl)TemplateBuilderFactory.getInstance().createTemplateBuilder(addedElement);
        TextRange range = new TextRange(1, regexpElement.getTextLength() - 1);
        builder.replaceElement(regexpElement, range, range.substring(regexpElement.getText()));
        for (PsiParameter var : blockVars.getParameters()) {
            PsiIdentifier nameIdentifier = var.getNameIdentifier();
            if (nameIdentifier == null) continue;
            builder.replaceElement((PsiElement)nameIdentifier, nameIdentifier.getText());
        }
        if (body.getStatements().length > 0) {
            PsiStatement firstStatement = body.getStatements()[0];
            TextRange pendingRange = new TextRange(0, firstStatement.getTextLength() - 1);
            builder.replaceElement((PsiElement)firstStatement, pendingRange, pendingRange.substring(firstStatement.getText()));
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        documentManager.doPostponedOperationsAndUnblockDocument(editor.getDocument());
        Template template = builder.buildInlineTemplate();
        editor.getCaretModel().moveToOffset(addedElement.getTextRange().getStartOffset());
        TemplateEditingAdapter adapter = new TemplateEditingAdapter(){

            public void templateFinished(@NotNull Template template, boolean brokenOff) {
                if (template == null) {
                    1.$$$reportNull$$$0(0);
                }
                ApplicationManager.getApplication().runWriteAction(() -> {
                    PsiMethod method;
                    PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                    PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
                    if (psiFile == null) {
                        return;
                    }
                    int offset = editor.getCaretModel().getOffset() - 1;
                    PsiCodeBlock codeBlock = null;
                    PsiLambdaExpression lambda = (PsiLambdaExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)psiFile, (int)offset, PsiLambdaExpression.class, (boolean)false);
                    if (lambda != null) {
                        PsiElement body = lambda.getBody();
                        PsiCodeBlock psiCodeBlock = codeBlock = body instanceof PsiCodeBlock ? (PsiCodeBlock)body : null;
                    }
                    if (codeBlock == null && (method = (PsiMethod)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)psiFile, (int)offset, PsiMethod.class, (boolean)false)) != null) {
                        codeBlock = method.getBody();
                    }
                    if (codeBlock != null) {
                        CreateFromUsageUtils.setupEditor(codeBlock, (Editor)editor);
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "org/jetbrains/plugins/cucumber/java/steps/JavaStepDefinitionCreator$1", "templateFinished"));
            }
        };
        TemplateManager.getInstance((Project)project).startTemplate(editor, template, (TemplateEditingListener)adapter);
    }

    public boolean validateNewStepDefinitionFileName(@NotNull Project project, @NotNull String name) {
        if (project == null) {
            JavaStepDefinitionCreator.$$$reportNull$$$0(7);
        }
        if (name == null) {
            JavaStepDefinitionCreator.$$$reportNull$$$0(8);
        }
        if (name.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public String getDefaultStepDefinitionFolderPath(@NotNull GherkinStep step) {
        PsiFile featureFile;
        if (step == null) {
            JavaStepDefinitionCreator.$$$reportNull$$$0(9);
        }
        if ((featureFile = step.getContainingFile()) != null) {
            VirtualFile directory;
            ProjectFileIndex projectFileIndex;
            PsiDirectory psiDirectory = featureFile.getContainingDirectory();
            Project project = step.getProject();
            if (psiDirectory != null && (projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex()).isInContent(directory = psiDirectory.getVirtualFile())) {
                VirtualFile sourceRoot = projectFileIndex.getSourceRootForFile(directory);
                Module module = projectFileIndex.getModuleForFile(featureFile.getVirtualFile());
                if (module != null) {
                    VirtualFile[] sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots();
                    if (sourceRoot != null && sourceRoot.getName().equals("resources")) {
                        VirtualFile resourceParent = sourceRoot.getParent();
                        for (VirtualFile vFile : sourceRoots) {
                            if (!vFile.getPath().startsWith(resourceParent.getPath()) || !vFile.getName().equals("java")) continue;
                            sourceRoot = vFile;
                            break;
                        }
                    } else if (sourceRoots.length > 0) {
                        sourceRoot = sourceRoots[sourceRoots.length - 1];
                    }
                }
                String packageName = "";
                if (sourceRoot != null) {
                    packageName = CucumberJavaUtil.getPackageOfStepDef((PsiElement)step);
                }
                String packagePath = packageName.replace('.', '/');
                String path = sourceRoot != null ? sourceRoot.getPath() : directory.getPath();
                String string = FileUtil.join((String[])new String[]{path, packagePath});
                if (string == null) {
                    JavaStepDefinitionCreator.$$$reportNull$$$0(10);
                }
                return string;
            }
        }
        assert (featureFile != null);
        String string = Objects.requireNonNull(featureFile.getContainingDirectory()).getVirtualFile().getPath();
        if (string == null) {
            JavaStepDefinitionCreator.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public String getStepDefinitionFilePath(@NotNull PsiFile file) {
        if (file == null) {
            JavaStepDefinitionCreator.$$$reportNull$$$0(12);
        }
        VirtualFile vFile = file.getVirtualFile();
        if (file instanceof PsiClassOwner && vFile != null) {
            String packageName = ((PsiClassOwner)file).getPackageName();
            if (StringUtil.isEmptyOrSpaces((String)packageName)) {
                String string = vFile.getNameWithoutExtension();
                if (string == null) {
                    JavaStepDefinitionCreator.$$$reportNull$$$0(13);
                }
                return string;
            }
            String string = vFile.getNameWithoutExtension() + " (" + packageName + ")";
            if (string == null) {
                JavaStepDefinitionCreator.$$$reportNull$$$0(14);
            }
            return string;
        }
        String string = file.getName();
        if (string == null) {
            JavaStepDefinitionCreator.$$$reportNull$$$0(15);
        }
        return string;
    }

    public static String processGeneratedStepDefinition(@NotNull String stepDefinition, @NotNull PsiElement context) {
        if (stepDefinition == null) {
            JavaStepDefinitionCreator.$$$reportNull$$$0(16);
        }
        if (context == null) {
            JavaStepDefinitionCreator.$$$reportNull$$$0(17);
        }
        return stepDefinition.replace("PendingException", CucumberJavaUtil.getCucumberPendingExceptionFqn(context));
    }

    @NotNull
    public String getDefaultStepFileName(@NotNull GherkinStep step) {
        if (step == null) {
            JavaStepDefinitionCreator.$$$reportNull$$$0(18);
        }
        return STEP_DEFINITION_SUFFIX;
    }

    private static PsiMethod buildStepDefinitionByStep(@NotNull GherkinStep step, Language language) {
        if (step == null) {
            JavaStepDefinitionCreator.$$$reportNull$$$0(19);
        }
        String annotationPackage = new AnnotationPackageProvider().getAnnotationPackageFor(step);
        String methodAnnotation = String.format("@%s.", annotationPackage);
        Step cucumberStep = new Step(new ArrayList(), step.getKeyword().getText(), step.getName(), Integer.valueOf(0), null, null);
        SnippetGenerator generator = new SnippetGenerator((Snippet)new JavaSnippet());
        String snippet = generator.getSnippet(cucumberStep, new FunctionNameGenerator((Concatenator)new CamelCaseConcatenator()));
        if (CucumberJavaUtil.isCucumberExpressionsAvailable((PsiElement)step)) {
            snippet = JavaStepDefinitionCreator.replaceRegexpWithCucumberExpression(snippet, step.getName());
        }
        snippet = snippet.replaceFirst("@", methodAnnotation);
        snippet = JavaStepDefinitionCreator.processGeneratedStepDefinition(snippet, (PsiElement)step);
        JVMElementFactory factory = JVMElementFactories.requireFactory((Language)language, (Project)step.getProject());
        PsiMethod methodFromCucumberLibraryTemplate = factory.createMethodFromText(snippet, (PsiElement)step);
        try {
            return JavaStepDefinitionCreator.createStepDefinitionFromSnippet(methodFromCucumberLibraryTemplate, step, factory);
        }
        catch (Exception e) {
            return methodFromCucumberLibraryTemplate;
        }
    }

    private static String replaceRegexpWithCucumberExpression(@NotNull String snippet, @NotNull String step) {
        if (snippet == null) {
            JavaStepDefinitionCreator.$$$reportNull$$$0(20);
        }
        if (step == null) {
            JavaStepDefinitionCreator.$$$reportNull$$$0(21);
        }
        try {
            ParameterTypeRegistry registry = new ParameterTypeRegistry(Locale.getDefault());
            CucumberExpressionGenerator generator = new CucumberExpressionGenerator(registry);
            GeneratedExpression result = (GeneratedExpression)generator.generateExpressions(step).get(0);
            if (result != null) {
                String cucumberExpression = new JavaSnippet().escapePattern(result.getSource());
                String[] lines = snippet.split("\n");
                int start = lines[0].indexOf(40) + 1;
                lines[0] = lines[0].substring(0, start + 1) + cucumberExpression + "\")";
                return StringUtil.join((String[])lines, (String)"");
            }
        }
        catch (Exception ignored) {
            LOG.warn("Failed to replace regex with Cucumber Expression for step: " + step);
        }
        return snippet;
    }

    private static PsiMethod createStepDefinitionFromSnippet(@NotNull PsiMethod methodFromSnippet, @NotNull GherkinStep step, @NotNull JVMElementFactory factory) {
        if (methodFromSnippet == null) {
            JavaStepDefinitionCreator.$$$reportNull$$$0(22);
        }
        if (step == null) {
            JavaStepDefinitionCreator.$$$reportNull$$$0(23);
        }
        if (factory == null) {
            JavaStepDefinitionCreator.$$$reportNull$$$0(24);
        }
        List<PsiAnnotation> annotationsFromSnippetMethod = CucumberJavaUtil.getCucumberStepAnnotations(methodFromSnippet);
        PsiAnnotation cucumberStepAnnotation = annotationsFromSnippetMethod.get(0);
        String regexp = CucumberJavaUtil.getPatternFromStepDefinition(cucumberStepAnnotation);
        String stepAnnotationName = cucumberStepAnnotation.getQualifiedName();
        if (stepAnnotationName == null) {
            stepAnnotationName = DEFAULT_STEP_KEYWORD;
        }
        FileTemplateDescriptor fileTemplateDescriptor = new FileTemplateDescriptor(FILE_TEMPLATE_CUCUMBER_JAVA_STEP_DEFINITION_JAVA);
        FileTemplate fileTemplate = FileTemplateManager.getInstance((Project)step.getProject()).getCodeTemplate(fileTemplateDescriptor.getFileName());
        String text = fileTemplate.getText();
        text = text.replace("${STEP_KEYWORD}", stepAnnotationName).replace("${STEP_REGEXP}", "\"" + regexp + "\"").replace("${METHOD_NAME}", methodFromSnippet.getName()).replace("${PARAMETERS}", methodFromSnippet.getParameterList().getText()).replace("${BODY}\n", "");
        text = JavaStepDefinitionCreator.processGeneratedStepDefinition(text, (PsiElement)methodFromSnippet);
        return factory.createMethodFromText(text, (PsiElement)step);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/java/steps/JavaStepDefinitionCreator";
                break;
            }
            case 3: 
            case 9: 
            case 18: 
            case 19: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addedElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stepDefinition";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snippet";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodFromSnippet";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/java/steps/JavaStepDefinitionCreator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createStepDefinitionContainer";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultStepDefinitionFolderPath";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getStepDefinitionFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createStepDefinitionContainer";
                break;
            }
            case 2: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createStepDefinition";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "runTemplateBuilderOnAddedStep";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "validateNewStepDefinitionFileName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultStepDefinitionFolderPath";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getStepDefinitionFilePath";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processGeneratedStepDefinition";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultStepFileName";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "buildStepDefinitionByStep";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "replaceRegexpWithCucumberExpression";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createStepDefinitionFromSnippet";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

