/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.java.run;

import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.junit.JavaRunConfigurationProducerBase;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.java.CucumberJavaUtil;
import org.jetbrains.plugins.cucumber.java.CucumberJavaVersionUtil;
import org.jetbrains.plugins.cucumber.java.run.CucumberGlueProvider;
import org.jetbrains.plugins.cucumber.java.run.CucumberJavaRunConfiguration;
import org.jetbrains.plugins.cucumber.java.run.CucumberJavaRunConfigurationType;
import org.jetbrains.plugins.cucumber.psi.GherkinFileType;

public abstract class CucumberJavaRunConfigurationProducer
extends JavaRunConfigurationProducerBase<CucumberJavaRunConfiguration>
implements Cloneable {
    public static final String FORMATTER_OPTIONS_1_0 = " --format org.jetbrains.plugins.cucumber.java.run.CucumberJvmSMFormatter --monochrome";
    public static final String FORMATTER_OPTIONS_1_2 = " --plugin org.jetbrains.plugins.cucumber.java.run.CucumberJvmSMFormatter --monochrome";
    public static final String FORMATTER_OPTIONS_2 = " --plugin org.jetbrains.plugins.cucumber.java.run.CucumberJvm2SMFormatter --monochrome";
    public static final String FORMATTER_OPTIONS_3 = " --plugin org.jetbrains.plugins.cucumber.java.run.CucumberJvm3SMFormatter";
    public static final String FORMATTER_OPTIONS_4 = " --plugin org.jetbrains.plugins.cucumber.java.run.CucumberJvm4SMFormatter";
    public static final String FORMATTER_OPTIONS_5 = " --plugin org.jetbrains.plugins.cucumber.java.run.CucumberJvm5SMFormatter";
    public static final Set<String> HOOK_AND_TYPE_ANNOTATION_NAMES = ContainerUtil.newHashSet((Object[])new String[]{"cucumber.annotation.Before", "cucumber.annotation.After", "cucumber.api.java.Before", "cucumber.api.java.After", "io.cucumber.java.Before", "io.cucumber.java.After", "io.cucumber.java.BeforeStep", "io.cucumber.java.AfterStep", "io.cucumber.java.ParameterType", "io.cucumber.java.DataTableType", "io.cucumber.java.DocStringType", "io.cucumber.java.DefaultParameterTransformer", "io.cucumber.java.DefaultDataTableEntryTransformer", "io.cucumber.java.DefaultDataTableCellTransformer"});
    public static final Set<String> CONFIGURATION_ANNOTATION_NAMES = ContainerUtil.newHashSet((Object[])new String[]{"io.cucumber.spring.CucumberContextConfiguration", "io.cucumber.spring.ScenarioScope"});

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ConfigurationFactory configurationFactory = CucumberJavaRunConfigurationType.getInstance().getConfigurationFactories()[0];
        if (configurationFactory == null) {
            CucumberJavaRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        return configurationFactory;
    }

    @Nullable
    protected abstract CucumberGlueProvider getGlueProvider(@NotNull PsiElement var1);

    protected abstract String getConfigurationName(@NotNull ConfigurationContext var1);

    protected String getNameFilter(@NotNull ConfigurationContext context) {
        if (context == null) {
            CucumberJavaRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        return "";
    }

    @Nullable
    protected abstract VirtualFile getFileToRun(ConfigurationContext var1);

    protected boolean setupConfigurationFromContext(@NotNull CucumberJavaRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        VirtualFile virtualFile;
        if (configuration == null) {
            CucumberJavaRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (context == null) {
            CucumberJavaRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        if (sourceElement == null) {
            CucumberJavaRunConfigurationProducer.$$$reportNull$$$0(4);
        }
        if ((virtualFile = this.getFileToRun(context)) == null) {
            return false;
        }
        Project project = configuration.getProject();
        PsiElement element = context.getPsiLocation();
        if (element == null) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project);
        if (module == null) {
            return false;
        }
        if (virtualFile.isDirectory() && !FileTypeIndex.containsFileOfType((FileType)GherkinFileType.INSTANCE, (GlobalSearchScope)GlobalSearchScopesCore.directoryScope((Project)project, (VirtualFile)virtualFile, (boolean)true))) {
            return false;
        }
        String mainClassName = null;
        String formatterOptions = null;
        Location location = context.getLocation();
        if (location != null) {
            String cucumberCoreVersion = CucumberJavaVersionUtil.getCucumberCoreVersion(module, module.getProject());
            mainClassName = CucumberJavaUtil.getCucumberMainClass(cucumberCoreVersion);
            configuration.setCucumberCoreVersion(cucumberCoreVersion);
            formatterOptions = CucumberJavaRunConfigurationProducer.getSMFormatterOptions(cucumberCoreVersion);
        }
        if (mainClassName == null) {
            return false;
        }
        VirtualFile file = this.getFileToRun(context);
        if (file == null) {
            return false;
        }
        if (StringUtil.isEmpty((String)configuration.getGlue())) {
            configuration.setGlueProvider(this.getGlueProvider(element));
        }
        configuration.setNameFilter(this.getNameFilter(context));
        configuration.setFilePath(file.getPath());
        String programParametersFromDefaultConfiguration = StringUtil.defaultIfEmpty((String)configuration.getProgramParameters(), (String)"");
        if (StringUtil.isEmpty((String)programParametersFromDefaultConfiguration)) {
            configuration.setProgramParameters(formatterOptions);
        }
        if (configuration.getMainClassName() == null) {
            configuration.setMainClassName(mainClassName);
        }
        if (configuration.getNameFilter() != null && configuration.getNameFilter().length() > 0) {
            String newProgramParameters = configuration.getProgramParameters() + " --name \"" + configuration.getNameFilter() + "\"";
            configuration.setProgramParameters(newProgramParameters);
        }
        configuration.setSuggestedName(this.getConfigurationName(context));
        configuration.setGeneratedName();
        this.setupConfigurationModule(context, (ModuleBasedConfiguration)configuration);
        JavaRunConfigurationExtensionManager.getInstance().extendCreatedConfiguration((RunConfigurationBase)configuration, location);
        return true;
    }

    public boolean isConfigurationFromContext(@NotNull CucumberJavaRunConfiguration runConfiguration, @NotNull ConfigurationContext context) {
        Location location;
        if (runConfiguration == null) {
            CucumberJavaRunConfigurationProducer.$$$reportNull$$$0(5);
        }
        if (context == null) {
            CucumberJavaRunConfigurationProducer.$$$reportNull$$$0(6);
        }
        if ((location = context.getLocation()) == null) {
            return false;
        }
        Location classLocation = JavaExecutionUtil.stepIntoSingleClass((Location)location);
        if (classLocation == null) {
            return false;
        }
        VirtualFile fileToRun = this.getFileToRun(context);
        if (fileToRun == null) {
            return false;
        }
        if (!fileToRun.getPath().equals(runConfiguration.getFilePath())) {
            return false;
        }
        if (!Comparing.strEqual((String)this.getNameFilter(context), (String)runConfiguration.getNameFilter())) {
            return false;
        }
        Module configurationModule = ((JavaRunConfigurationModule)runConfiguration.getConfigurationModule()).getModule();
        return Comparing.equal((Object)classLocation.getModule(), (Object)configurationModule);
    }

    @NotNull
    private static String getSMFormatterOptions(@NotNull String cucumberCoreVersion) {
        if (cucumberCoreVersion == null) {
            CucumberJavaRunConfigurationProducer.$$$reportNull$$$0(7);
        }
        if (VersionComparatorUtil.compare((String)cucumberCoreVersion, (String)"5") >= 0) {
            return FORMATTER_OPTIONS_5;
        }
        if (VersionComparatorUtil.compare((String)cucumberCoreVersion, (String)"4") >= 0) {
            return FORMATTER_OPTIONS_4;
        }
        if (VersionComparatorUtil.compare((String)cucumberCoreVersion, (String)"3") >= 0) {
            return FORMATTER_OPTIONS_3;
        }
        if (VersionComparatorUtil.compare((String)cucumberCoreVersion, (String)"2") >= 0) {
            return FORMATTER_OPTIONS_2;
        }
        if (VersionComparatorUtil.compare((String)cucumberCoreVersion, (String)"1.2") >= 0) {
            return FORMATTER_OPTIONS_1_2;
        }
        return FORMATTER_OPTIONS_1_0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/java/run/CucumberJavaRunConfigurationProducer";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cucumberCoreVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/java/run/CucumberJavaRunConfigurationProducer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getNameFilter";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromContext";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromContext";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSMFormatterOptions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

