/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.java.run;

import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.testframework.JavaTestLocator;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.junit4.ExpectedPatterns;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PathUtil;
import com.intellij.util.text.VersionComparatorUtil;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Consumer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.CucumberBundle;
import org.jetbrains.plugins.cucumber.java.CucumberJavaBundle;
import org.jetbrains.plugins.cucumber.java.CucumberJavaUtil;
import org.jetbrains.plugins.cucumber.java.run.CucumberGlueProvider;
import org.jetbrains.plugins.cucumber.java.run.CucumberJavaApplicationConfigurable;
import org.jetbrains.plugins.cucumber.java.run.CucumberJavaConfigurationOptions;
import org.jetbrains.plugins.cucumber.java.run.CucumberJvmSMFormatter;

public class CucumberJavaRunConfiguration
extends ApplicationConfiguration {
    private volatile CucumberGlueProvider myCucumberGlueProvider = null;
    private static final Logger LOG = Logger.getInstance(CucumberJavaRunConfiguration.class);

    protected CucumberJavaRunConfiguration(String name, Project project, ConfigurationFactory factory) {
        super(name, project, factory);
        this.setWorkingDirectory("$MODULE_WORKING_DIR$");
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        group.addEditor(ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]), (SettingsEditor)new CucumberJavaApplicationConfigurable(this.getProject()));
        JavaRunConfigurationExtensionManager.getInstance().appendEditors((RunConfigurationBase)this, group);
        group.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), (SettingsEditor)new LogConfigurationPanel());
        SettingsEditorGroup settingsEditorGroup = group;
        if (settingsEditorGroup == null) {
            CucumberJavaRunConfiguration.$$$reportNull$$$0(0);
        }
        return settingsEditorGroup;
    }

    public RunProfileState getState(final @NotNull Executor executor, @NotNull ExecutionEnvironment env) {
        if (executor == null) {
            CucumberJavaRunConfiguration.$$$reportNull$$$0(1);
        }
        if (env == null) {
            CucumberJavaRunConfiguration.$$$reportNull$$$0(2);
        }
        return new ApplicationConfiguration.JavaApplicationCommandLineState<CucumberJavaRunConfiguration>(this, env){
            private final Collection<Filter> myConsoleFilters;
            {
                super((ApplicationConfiguration)arg0, arg1);
                this.myConsoleFilters = new ArrayList<Filter>();
            }

            protected JavaParameters createJavaParameters() throws ExecutionException {
                String filePath;
                File f;
                String[] paths;
                JavaParameters params = new JavaParameters();
                JavaRunConfigurationModule module = (JavaRunConfigurationModule)CucumberJavaRunConfiguration.this.getConfigurationModule();
                int classPathType = 7;
                String jreHome = this.getTargetEnvironmentRequest() == null && CucumberJavaRunConfiguration.this.isAlternativeJrePathEnabled() ? CucumberJavaRunConfiguration.this.getAlternativeJrePath() : null;
                ReadAction.run(() -> {
                    JavaParametersUtil.configureModule((RunConfigurationModule)module, (JavaParameters)params, (int)7, (String)jreHome);
                    JavaParametersUtil.configureConfiguration((SimpleJavaParameters)params, (CommonJavaRunConfigurationParameters)CucumberJavaRunConfiguration.this);
                });
                for (String path : paths = CucumberJavaRunConfiguration.this.getSMRunnerPaths()) {
                    params.getClassPath().add(path);
                }
                params.setMainClass(CucumberJavaRunConfiguration.this.getMainClassName());
                ReadAction.run(() -> JavaRunConfigurationExtensionManager.getInstance().updateJavaParameters((RunConfigurationBase)CucumberJavaRunConfiguration.this, params, this.getRunnerSettings(), executor));
                String glueValue = CucumberJavaRunConfiguration.this.getGlue();
                if (glueValue != null && !StringUtil.isEmpty((String)glueValue)) {
                    String[] glues;
                    for (String glue : glues = glueValue.split(" ")) {
                        if (StringUtil.isEmpty((String)glue)) continue;
                        params.getProgramParametersList().addParametersString(" --glue " + glue);
                    }
                }
                if ((f = new File(filePath = CucumberJavaRunConfiguration.this.getFilePath())).exists()) {
                    if (!f.isDirectory()) {
                        f = f.getParentFile();
                    }
                    params.getVMParametersList().addParametersString("-Dorg.jetbrains.run.directory=\"" + f.getAbsolutePath() + "\"");
                }
                params.getProgramParametersList().addParametersString("\"" + filePath + "\"");
                params.setShortenCommandLine(CucumberJavaRunConfiguration.this.getShortenCommandLine(), CucumberJavaRunConfiguration.this.getProject());
                return params;
            }

            @NotNull
            private ConsoleView createConsole(@NotNull Executor executor2, ProcessHandler processHandler) {
                if (executor2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                @NonNls String testFrameworkName = "cucumber";
                CucumberJavaRunConfiguration runConfiguration = CucumberJavaRunConfiguration.this;
                SMTRunnerConsoleProperties consoleProperties = new SMTRunnerConsoleProperties((RunConfiguration)runConfiguration, testFrameworkName, executor2){

                    @NotNull
                    public SMTestLocator getTestLocator() {
                        JavaTestLocator javaTestLocator = JavaTestLocator.INSTANCE;
                        if (javaTestLocator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return javaTestLocator;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/java/run/CucumberJavaRunConfiguration$1$1", "getTestLocator"));
                    }
                };
                BaseTestsOutputConsoleView console = (BaseTestsOutputConsoleView)UIUtil.invokeAndWaitIfNeeded(() -> SMTestRunnerConnectionUtil.createConsole((String)testFrameworkName, (TestConsoleProperties)consoleProperties));
                console.attachToProcess(processHandler);
                BaseTestsOutputConsoleView baseTestsOutputConsoleView = console;
                if (baseTestsOutputConsoleView == null) {
                    1.$$$reportNull$$$0(1);
                }
                return baseTestsOutputConsoleView;
            }

            @NotNull
            public ExecutionResult execute(@NotNull Executor executor2, @NotNull ProgramRunner<?> runner) throws ExecutionException {
                if (executor2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (runner == null) {
                    1.$$$reportNull$$$0(3);
                }
                OSProcessHandler processHandler = this.startProcess();
                ConsoleView console = this.createConsole(executor2, (ProcessHandler)processHandler);
                this.myConsoleFilters.forEach(filter -> console.addMessageFilter(filter));
                return new DefaultExecutionResult((ExecutionConsole)console, (ProcessHandler)processHandler, this.createActions(console, (ProcessHandler)processHandler, executor2));
            }

            public void addConsoleFilters(Filter ... filters) {
                this.myConsoleFilters.addAll(Arrays.asList(filters));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "executor";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/cucumber/java/run/CucumberJavaRunConfiguration$1";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "runner";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/cucumber/java/run/CucumberJavaRunConfiguration$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createConsole";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createConsole";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "execute";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private String[] getSMRunnerPaths() {
        ArrayList<Object> result = new ArrayList<Object>();
        String rtClassPath = PathUtil.getJarPathForClass(ExpectedPatterns.class);
        result.add(rtClassPath);
        @NonNls String cucumberJvmFormatterClassPath = PathUtil.getJarPathForClass(CucumberJvmSMFormatter.class);
        result.add(cucumberJvmFormatterClassPath);
        String cucumberCoreVersion = this.getCucumberCoreVersion();
        LOG.info("detected cucumber-java version: " + cucumberCoreVersion);
        for (int i = 5; i >= 3; --i) {
            if (VersionComparatorUtil.compare((String)cucumberCoreVersion, (String)String.valueOf(i)) < 0) continue;
            if (cucumberJvmFormatterClassPath.endsWith(".jar")) {
                result.add(cucumberJvmFormatterClassPath.replace(".jar", i + ".jar"));
                continue;
            }
            result.add(cucumberJvmFormatterClassPath + i);
        }
        return ArrayUtilRt.toStringArray(result);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        String filePath = this.getFilePath();
        if (filePath == null) {
            throw new RuntimeConfigurationException(CucumberBundle.message((String)"cucumber.run.error.specify.file", (Object[])new Object[0]));
        }
        @NonNls String programParameters = this.getProgramParameters();
        if (programParameters != null && programParameters.contains("--glue")) {
            throw new RuntimeConfigurationException(CucumberJavaBundle.message("cucumber.java.run.configuration.glue.in.program.parameters", new Object[0]));
        }
        super.checkConfiguration();
    }

    @NotNull
    protected CucumberJavaConfigurationOptions getOptions() {
        CucumberJavaConfigurationOptions cucumberJavaConfigurationOptions = (CucumberJavaConfigurationOptions)super.getOptions();
        if (cucumberJavaConfigurationOptions == null) {
            CucumberJavaRunConfiguration.$$$reportNull$$$0(3);
        }
        return cucumberJavaConfigurationOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getGlue() {
        if (this.myCucumberGlueProvider != null) {
            CucumberJavaRunConfiguration cucumberJavaRunConfiguration = this;
            synchronized (cucumberJavaRunConfiguration) {
                if (this.myCucumberGlueProvider != null) {
                    final HashSet glues = new HashSet();
                    if (ApplicationManager.getApplication().isDispatchThread()) {
                        Task.Modal task = new Task.Modal(this.getProject(), CucumberJavaBundle.message("cucumber.java.glue.calculation.title", new Object[0]), true){

                            public void run(@NotNull ProgressIndicator indicator) {
                                if (indicator == null) {
                                    2.$$$reportNull$$$0(0);
                                }
                                indicator.setText(CucumberJavaBundle.message("cucumber.java.glue.calculation.glues.message", "-"));
                                indicator.setText2(CucumberJavaBundle.message("cucumber.java.glue.calculation.glues.template.message", new Object[0]));
                                Consumer<String> consumer = glue -> {
                                    if (CucumberJavaUtil.addGlue(glue, glues)) {
                                        String gluePresentation = null;
                                        if (glues.size() < 15 && (gluePresentation = StringUtil.join((Collection)glues, (String)" ")).length() > 30) {
                                            gluePresentation = null;
                                        }
                                        if (gluePresentation == null) {
                                            gluePresentation = String.valueOf(glues.size());
                                        }
                                        String message = CucumberJavaBundle.message("cucumber.java.glue.calculation.glues.message", gluePresentation);
                                        indicator.setText(message);
                                    }
                                };
                                ApplicationManager.getApplication().runReadAction(() -> CucumberJavaRunConfiguration.this.myCucumberGlueProvider.calculateGlue(consumer));
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/cucumber/java/run/CucumberJavaRunConfiguration$2", "run"));
                            }
                        };
                        task.setCancelText(CucumberJavaBundle.message("cucumber.java.glue.calculation.stop.title", new Object[0]));
                        ProgressManager.getInstance().run((Task)task);
                    } else {
                        ApplicationManager.getApplication().runReadAction(() -> this.myCucumberGlueProvider.calculateGlue(glue -> CucumberJavaUtil.addGlue(glue, glues)));
                    }
                    this.getOptions().setGlue(StringUtil.join(glues, (String)" "));
                    this.myCucumberGlueProvider = null;
                }
            }
        }
        return this.getOptions().getGlue();
    }

    @Nullable
    public String getPrecalculatedGlue() {
        return this.getOptions().getGlue();
    }

    public synchronized void setGlue(String value) {
        this.getOptions().setGlue(value);
        this.myCucumberGlueProvider = null;
    }

    public synchronized void setGlueProvider(@Nullable CucumberGlueProvider cucumberGlueProvider) {
        this.myCucumberGlueProvider = cucumberGlueProvider;
    }

    @NlsSafe
    public String getFilePath() {
        return this.getOptions().getFilePath();
    }

    public void setFilePath(String filePath) {
        this.getOptions().setFilePath(filePath);
    }

    public String getNameFilter() {
        return this.getOptions().getNameFilter();
    }

    public void setNameFilter(String nameFilter) {
        this.getOptions().setNameFilter(nameFilter);
    }

    public String getCucumberCoreVersion() {
        return this.getOptions().getCucumberCoreVersion();
    }

    public void setCucumberCoreVersion(String cucumberCoreVersion) {
        this.getOptions().setCucumberCoreVersion(cucumberCoreVersion);
    }

    @Nullable
    public String suggestedName() {
        return this.getOptions().getSuggestedName();
    }

    public void setSuggestedName(String suggestedName) {
        this.getOptions().setSuggestedName(suggestedName);
    }

    public String getActionName() {
        return this.getName();
    }

    @Nullable
    public LanguageRuntimeType<?> getDefaultLanguageRuntimeType() {
        return null;
    }

    @Nullable
    public String getDefaultTargetName() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/java/run/CucumberJavaRunConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/java/run/CucumberJavaRunConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

