/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.java.run;

import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PathUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.java.run.CucumberTestTreeNodeManager;

final class CucumberJUnitRunConfigurationExtension
extends RunConfigurationExtension {
    private static final String CUCUMBER_JUNIT_RUNNER_CLASS_MARKER = "Cucumber.class";
    private static final String JUNIT_RUN_WITH_ANNOTATION_CLASS = "org.junit.runner.RunWith";

    CucumberJUnitRunConfigurationExtension() {
    }

    public <T extends RunConfigurationBase<?>> void updateJavaParameters(@NotNull T configuration, @NotNull JavaParameters params, RunnerSettings runnerSettings) {
        if (configuration == null) {
            CucumberJUnitRunConfigurationExtension.$$$reportNull$$$0(0);
        }
        if (params == null) {
            CucumberJUnitRunConfigurationExtension.$$$reportNull$$$0(1);
        }
        if (!(configuration instanceof JUnitConfiguration)) {
            return;
        }
        Module module = ((JavaRunConfigurationModule)((JUnitConfiguration)configuration).getConfigurationModule()).getModule();
        if (module == null) {
            return;
        }
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        String mainClassName = ((JUnitConfiguration)configuration).getPersistentData().MAIN_CLASS_NAME;
        DumbService.getInstance((Project)module.getProject()).runWithAlternativeResolveEnabled(() -> {
            PsiNameValuePair[] annotationParameters;
            PsiClass mainClass;
            PsiClass psiClass = mainClass = mainClassName != null ? JavaPsiFacade.getInstance((Project)configuration.getProject()).findClass(mainClassName, scope) : null;
            if (mainClass == null) {
                return;
            }
            PsiAnnotation runWithAnnotation = mainClass.getAnnotation(JUNIT_RUN_WITH_ANNOTATION_CLASS);
            if (runWithAnnotation == null) {
                return;
            }
            for (PsiNameValuePair parameter : annotationParameters = runWithAnnotation.getParameterList().getAttributes()) {
                PsiAnnotationMemberValue value = parameter.getValue();
                if (value == null || !value.getText().equalsIgnoreCase(CUCUMBER_JUNIT_RUNNER_CLASS_MARKER)) continue;
                params.getClassPath().add(PathUtil.getJarPathForClass(CucumberTestTreeNodeManager.class));
                params.getVMParametersList().add("-DnodeNamesHandler=" + CucumberTestTreeNodeManager.class.getName());
                return;
            }
        });
    }

    public boolean isApplicableFor(@NotNull RunConfigurationBase<?> configuration) {
        if (configuration == null) {
            CucumberJUnitRunConfigurationExtension.$$$reportNull$$$0(2);
        }
        return configuration instanceof JUnitConfiguration;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/cucumber/java/run/CucumberJUnitRunConfigurationExtension";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "updateJavaParameters";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicableFor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

