/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.java.inspections;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.java.CucumberJavaBundle;
import org.jetbrains.plugins.cucumber.java.CucumberJavaUtil;

public class CucumberJavaStepDefClassIsPublicInspections
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public String getShortName() {
        return "CucumberJavaStepDefClassIsPublic";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CucumberJavaStepDefClassIsPublicInspections.$$$reportNull$$$0(0);
        }
        return new CucumberJavaStepDefClassIsPublicVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/cucumber/java/inspections/CucumberJavaStepDefClassIsPublicInspections", "buildVisitor"));
    }

    static class CucumberJavaStepDefClassIsPublicVisitor
    extends JavaElementVisitor {
        final ProblemsHolder holder;

        CucumberJavaStepDefClassIsPublicVisitor(ProblemsHolder holder) {
            this.holder = holder;
        }

        public void visitClass(PsiClass aClass) {
            if (!CucumberJavaUtil.isStepDefinitionClass(aClass)) {
                return;
            }
            if (!aClass.hasModifierProperty("public")) {
                PsiIdentifier elementToHighlight = aClass.getNameIdentifier();
                if (elementToHighlight == null) {
                    elementToHighlight = aClass;
                }
                this.holder.registerProblem((PsiElement)elementToHighlight, CucumberJavaBundle.message("cucumber.java.inspection.step.def.class.is.public.message", new Object[0]), new LocalQuickFix[0]);
            }
        }
    }
}

