/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.java;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.BDDFrameworkType;
import org.jetbrains.plugins.cucumber.StepDefinitionCreator;
import org.jetbrains.plugins.cucumber.java.AbstractCucumberJavaExtension;
import org.jetbrains.plugins.cucumber.java.CucumberJavaUtil;
import org.jetbrains.plugins.cucumber.java.steps.JavaStepDefinitionCreator;
import org.jetbrains.plugins.cucumber.java.steps.factory.JavaStepDefinitionFactory;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;

public class CucumberJavaExtension
extends AbstractCucumberJavaExtension {
    private static final String CUCUMBER_JAVA_5_STEP_DEFINITION_ANNOTATION_CLASS_NAME = "io.cucumber.java.StepDefinitionAnnotation";
    @NonNls
    public static final String CUCUMBER_RUNTIME_JAVA_STEP_DEF_ANNOTATION = "cucumber.runtime.java.StepDefAnnotation";
    @NonNls
    public static final String ZUCHINI_RUNTIME_JAVA_STEP_DEF_ANNOTATION = "org.zuchini.annotations.StepAnnotation";
    private static final String[] CUCUMBER_JAVA_STEP_DEFINITION_ANNOTATION_CLASSES = new String[]{"io.cucumber.java.StepDefinitionAnnotation", "cucumber.runtime.java.StepDefAnnotation", "org.zuchini.annotations.StepAnnotation"};

    @NotNull
    public BDDFrameworkType getStepFileType() {
        return new BDDFrameworkType((FileType)JavaFileType.INSTANCE);
    }

    @NotNull
    public StepDefinitionCreator getStepDefinitionCreator() {
        return new JavaStepDefinitionCreator();
    }

    public List<AbstractStepDefinition> loadStepsFor(@Nullable PsiFile featureFile, @NotNull Module module) {
        if (module == null) {
            CucumberJavaExtension.$$$reportNull$$$0(0);
        }
        GlobalSearchScope dependenciesScope = module.getModuleWithDependenciesAndLibrariesScope(true);
        PsiClass stepDefAnnotationClass = null;
        for (String className : CUCUMBER_JAVA_STEP_DEFINITION_ANNOTATION_CLASSES) {
            stepDefAnnotationClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(className, dependenciesScope);
            if (stepDefAnnotationClass != null) break;
        }
        if (stepDefAnnotationClass == null) {
            return Collections.emptyList();
        }
        JavaStepDefinitionFactory stepDefinitionFactory = JavaStepDefinitionFactory.getInstance(module);
        ArrayList<AbstractStepDefinition> result = new ArrayList<AbstractStepDefinition>();
        Query stepDefAnnotations = AnnotatedElementsSearch.searchPsiClasses((PsiClass)stepDefAnnotationClass, (SearchScope)dependenciesScope);
        for (PsiClass annotationClass : stepDefAnnotations) {
            String annotationClassName = annotationClass.getQualifiedName();
            if (!annotationClass.isAnnotationType() || annotationClassName == null) continue;
            Query javaStepDefinitions = AnnotatedElementsSearch.searchPsiMethods((PsiClass)annotationClass, (SearchScope)dependenciesScope);
            for (PsiMethod stepDefMethod : javaStepDefinitions) {
                List<String> annotationValues = CucumberJavaUtil.getStepAnnotationValues(stepDefMethod, annotationClassName);
                for (String annotationValue : annotationValues) {
                    result.add(stepDefinitionFactory.buildStepDefinition((PsiElement)stepDefMethod, module, annotationValue));
                }
            }
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/cucumber/java/CucumberJavaExtension", "loadStepsFor"));
    }
}

