/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.jdi.MethodBytecodeUtil;
import com.sun.jdi.Method;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0005J\f\u0010\u0006\u001a\u00020\u0004*\u00020\u0005H\u0002J\f\u0010\u0007\u001a\u00020\u0004*\u00020\u0005H\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/KotlinSimpleGetterDetector;", "", "()V", "isSimpleGetter", "", "Lcom/sun/jdi/Method;", "isSimpleMemberVariableGetter", "isSimpleStaticVariableGetter", "MethodBytecodeVerifier", "kotlin.jvm-debugger.util"})
public final class KotlinSimpleGetterDetector {
    @NotNull
    public static final KotlinSimpleGetterDetector INSTANCE;

    public final boolean isSimpleGetter(@NotNull Method $this$isSimpleGetter) {
        Intrinsics.checkNotNullParameter((Object)$this$isSimpleGetter, (String)"$this$isSimpleGetter");
        return this.isSimpleMemberVariableGetter($this$isSimpleGetter) || this.isSimpleStaticVariableGetter($this$isSimpleGetter);
    }

    private final boolean isSimpleStaticVariableGetter(Method $this$isSimpleStaticVariableGetter) {
        if ($this$isSimpleStaticVariableGetter.bytecodes().length != 4) {
            return false;
        }
        MethodBytecodeVerifier methodBytecodeVerifier2 = new MethodBytecodeVerifier(){

            protected boolean verify(int opcode, int position) {
                boolean bl;
                switch (position) {
                    case 0: {
                        if (opcode == 178) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case 1: {
                        int n = opcode;
                        if (172 <= n && 176 >= n) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    default: {
                        bl = false;
                    }
                }
                return bl;
            }
        };
        MethodBytecodeUtil.visit((Method)$this$isSimpleStaticVariableGetter, (MethodVisitor)methodBytecodeVerifier2, (boolean)false);
        return methodBytecodeVerifier2.getResult() && methodBytecodeVerifier2.getProcessedOpcodes() == 2;
    }

    private final boolean isSimpleMemberVariableGetter(Method $this$isSimpleMemberVariableGetter) {
        if ($this$isSimpleMemberVariableGetter.bytecodes().length != 5) {
            return false;
        }
        MethodBytecodeVerifier methodBytecodeVerifier2 = new MethodBytecodeVerifier(){

            protected boolean verify(int opcode, int position) {
                boolean bl;
                switch (position) {
                    case 0: {
                        if (opcode == 25) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case 1: {
                        if (opcode == 180) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case 2: {
                        int n = opcode;
                        if (172 <= n && 176 >= n) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    default: {
                        bl = false;
                    }
                }
                return bl;
            }
        };
        MethodBytecodeUtil.visit((Method)$this$isSimpleMemberVariableGetter, (MethodVisitor)methodBytecodeVerifier2, (boolean)false);
        return methodBytecodeVerifier2.getResult() && methodBytecodeVerifier2.getProcessedOpcodes() == 3;
    }

    private KotlinSimpleGetterDetector() {
    }

    static {
        KotlinSimpleGetterDetector kotlinSimpleGetterDetector;
        INSTANCE = kotlinSimpleGetterDetector = new KotlinSimpleGetterDetector();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\"\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H$J.\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u0015H\u0016J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0004H\u0016J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J\u0018\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0004H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/KotlinSimpleGetterDetector$MethodBytecodeVerifier;", "Lorg/jetbrains/org/objectweb/asm/MethodVisitor;", "()V", "processedOpcodes", "", "getProcessedOpcodes", "()I", "setProcessedOpcodes", "(I)V", "result", "", "getResult", "()Z", "setResult", "(Z)V", "verify", "opcode", "position", "visitFieldInsn", "", "owner", "", "name", "descriptor", "visitInsn", "visitOpcode", "visitVarInsn", "variable", "kotlin.jvm-debugger.util"})
    private static abstract class MethodBytecodeVerifier
    extends MethodVisitor {
        private int processedOpcodes;
        private boolean result = true;

        public final int getProcessedOpcodes() {
            return this.processedOpcodes;
        }

        public final void setProcessedOpcodes(int n) {
            this.processedOpcodes = n;
        }

        public final boolean getResult() {
            return this.result;
        }

        public final void setResult(boolean bl) {
            this.result = bl;
        }

        protected abstract boolean verify(int var1, int var2);

        private final void visitOpcode(int opcode) {
            if (!this.verify(opcode, this.processedOpcodes)) {
                this.result = false;
            }
            ++this.processedOpcodes;
        }

        public void visitVarInsn(int opcode, int variable) {
            this.visitOpcode(opcode);
        }

        public void visitFieldInsn(int opcode, @Nullable String owner, @Nullable String name, @Nullable String descriptor) {
            this.visitOpcode(opcode);
        }

        public void visitInsn(int opcode) {
            this.visitOpcode(opcode);
        }

        public MethodBytecodeVerifier() {
            super(589824);
        }
    }
}

