/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.VMDisconnectedException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u001a-\u0010\b\u001a\u0004\u0018\u0001H\t\"\b\b\u0000\u0010\t*\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\t0\fH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\r\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u000e"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "handleHopelessException", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "hopelessAware", "T", "", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "kotlin.jvm-debugger.util"})
public final class HopelessExceptionUtilKt {
    private static final Logger LOG;

    @Nullable
    public static final <T> T hopelessAware(@NotNull Function0<? extends T> block) {
        Object object;
        int $i$f$hopelessAware = 0;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        try {
            object = block.invoke();
        }
        catch (Exception e) {
            HopelessExceptionUtilKt.handleHopelessException(e);
            object = null;
        }
        return (T)object;
    }

    public static final void handleHopelessException(@NotNull Exception e) {
        Throwable throwable;
        Throwable throwable2;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e instanceof EvaluateException) {
            throwable2 = e.getCause();
            if (throwable2 == null) {
                throwable2 = e;
            }
        } else {
            throwable2 = throwable = (Throwable)e;
        }
        if (!(throwable instanceof IncompatibleThreadStateException) && !(throwable instanceof VMDisconnectedException)) {
            if (e instanceof EvaluateException) {
                LOG.debug("Cannot evaluate async stack trace", (Throwable)e);
            } else {
                throw (Throwable)e;
            }
        }
    }

    static {
        Logger logger = Logger.getInstance((String)"HopelessExceptionUtils");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(\"HopelessExceptionUtils\")");
        LOG = logger;
    }
}

