/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.idea.debugger.KotlinEditorTextProvider;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u001a\u0010\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u00a8\u0006\u0007"}, d2={"getAccurateContextElement", "Lcom/intellij/psi/PsiElement;", "elementAt", "containingFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "getContextElement", "getElementSkippingWhitespaces", "kotlin.jvm-debugger.util"})
public final class CodeFragmentContextUtilsKt {
    @Nullable
    public static final PsiElement getContextElement(@Nullable PsiElement elementAt) {
        if (elementAt == null) {
            return null;
        }
        if (elementAt instanceof PsiCodeBlock) {
            PsiElement psiElement = ((PsiCodeBlock)elementAt).getContext();
            return CodeFragmentContextUtilsKt.getContextElement((PsiElement)(psiElement != null ? psiElement.getContext() : null));
        }
        if (elementAt instanceof KtLightClass) {
            return CodeFragmentContextUtilsKt.getContextElement((PsiElement)((KtLightClass)elementAt).getKotlinOrigin());
        }
        PsiFile containingFile = elementAt.getContainingFile();
        if (containingFile instanceof PsiJavaFile) {
            return elementAt;
        }
        if (!(containingFile instanceof KtFile)) {
            return null;
        }
        PsiElement accurateElement = CodeFragmentContextUtilsKt.getAccurateContextElement(elementAt, (KtFile)containingFile);
        if (accurateElement != null) {
            return accurateElement;
        }
        return (PsiElement)containingFile;
    }

    /*
     * WARNING - void declaration
     */
    private static final PsiElement getAccurateContextElement(PsiElement elementAt, KtFile containingFile) {
        int lineStartOffset;
        KtExpression targetExpression;
        KtExpression declarationParent;
        PsiElement elementAtSkippingWhitespaces = CodeFragmentContextUtilsKt.getElementSkippingWhitespaces(elementAt);
        if (elementAtSkippingWhitespaces instanceof LeafPsiElement && Intrinsics.areEqual((Object)((LeafPsiElement)elementAtSkippingWhitespaces).getElementType(), (Object)KtTokens.RBRACE)) {
            KtClassOrObject classOrObject;
            KtClassBody classBody;
            PsiElement psiElement = ((LeafPsiElement)elementAtSkippingWhitespaces).getParent();
            if (!(psiElement instanceof KtClassBody)) {
                psiElement = null;
            }
            KtClassBody ktClassBody = classBody = (KtClassBody)psiElement;
            Object object = ktClassBody != null ? ktClassBody.getParent() : null;
            if (!(object instanceof KtClassOrObject)) {
                object = null;
            }
            KtClassOrObject ktClassOrObject = classOrObject = (KtClassOrObject)object;
            Object object2 = declarationParent = ktClassOrObject != null ? ktClassOrObject.getParent() : null;
            if (declarationParent instanceof KtObjectLiteralExpression) {
                declarationParent = ((KtObjectLiteralExpression)declarationParent).getParent();
            }
            if (declarationParent != null) {
                return CodeFragmentContextUtilsKt.getAccurateContextElement((PsiElement)declarationParent, containingFile);
            }
        }
        if ((targetExpression = (KtExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)((PsiFile)containingFile), (int)(lineStartOffset = elementAtSkippingWhitespaces.getTextOffset()), KtExpression.class, (boolean)false)) != null) {
            Object v6;
            KtExpression it;
            boolean bl;
            block11: {
                void $this$firstOrNull$iv;
                if (KotlinEditorTextProvider.Companion.isAcceptedAsCodeFragmentContext((PsiElement)targetExpression)) {
                    return (PsiElement)targetExpression;
                }
                Object object = KotlinEditorTextProvider.Companion.findExpressionInner(elementAt, true);
                if (object != null) {
                    declarationParent = object;
                    bl = false;
                    boolean bl2 = false;
                    it = declarationParent;
                    boolean bl3 = false;
                    object = KotlinEditorTextProvider.Companion.isAcceptedAsCodeFragmentContext((PsiElement)it) ? declarationParent : null;
                    if (object != null) {
                        declarationParent = object;
                        bl = false;
                        bl2 = false;
                        it = declarationParent;
                        boolean bl4 = false;
                        return (PsiElement)it;
                    }
                }
                declarationParent = PsiUtilsKt.getParents((PsiElement)((PsiElement)targetExpression));
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PsiElement it2 = (PsiElement)element$iv;
                    boolean bl5 = false;
                    if (!KotlinEditorTextProvider.Companion.isAcceptedAsCodeFragmentContext(it2)) continue;
                    v6 = element$iv;
                    break block11;
                }
                v6 = null;
            }
            PsiElement psiElement = v6;
            if (psiElement != null) {
                PsiElement psiElement2 = psiElement;
                bl = false;
                boolean bl6 = false;
                it = psiElement2;
                boolean bl7 = false;
                return it;
            }
        }
        return null;
    }

    private static final PsiElement getElementSkippingWhitespaces(PsiElement elementAt) {
        PsiElement newElement;
        if ((elementAt instanceof PsiWhiteSpace || elementAt instanceof PsiComment) && (newElement = PsiTreeUtil.skipSiblingsForward((PsiElement)elementAt, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class})) != null) {
            return newElement;
        }
        return elementAt;
    }
}

