/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry.metrics;

import com.newrelic.telemetry.BaseConfig;
import com.newrelic.telemetry.MetricBatchSenderFactory;
import com.newrelic.telemetry.Response;
import com.newrelic.telemetry.SenderConfiguration;
import com.newrelic.telemetry.exceptions.ResponseException;
import com.newrelic.telemetry.http.HttpPoster;
import com.newrelic.telemetry.json.AttributesJson;
import com.newrelic.telemetry.metrics.MetricBatch;
import com.newrelic.telemetry.metrics.MetricBatchSenderBuilder;
import com.newrelic.telemetry.metrics.json.MetricBatchJsonCommonBlockWriter;
import com.newrelic.telemetry.metrics.json.MetricBatchJsonTelemetryBlockWriter;
import com.newrelic.telemetry.metrics.json.MetricBatchMarshaller;
import com.newrelic.telemetry.metrics.json.MetricToJson;
import com.newrelic.telemetry.transport.BatchDataSender;
import com.newrelic.telemetry.util.Utils;
import java.net.URL;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricBatchSender {
    private static final String METRICS_PATH = "/metric/v1";
    private static final String DEFAULT_URL = "https://metric-api.newrelic.com/";
    private static final Logger logger = LoggerFactory.getLogger(MetricBatchSender.class);
    private final MetricBatchMarshaller marshaller;
    private final BatchDataSender sender;

    MetricBatchSender(MetricBatchMarshaller marshaller, BatchDataSender sender) {
        this.marshaller = marshaller;
        this.sender = sender;
    }

    @Deprecated
    public static MetricBatchSenderBuilder builder() {
        return new MetricBatchSenderBuilder(MetricBatchSender.configurationBuilder());
    }

    public Response sendBatch(MetricBatch batch) throws ResponseException {
        if (batch == null || batch.size() == 0) {
            logger.debug("Skipped sending of an empty metric batch.");
            return new Response(202, "Ignored", "Empty batch");
        }
        logger.debug("Sending a metric batch (number of metrics: {}) to the New Relic metric ingest endpoint)", (Object)batch.size());
        String json = this.marshaller.toJson(batch);
        return this.sender.send(json, batch.getUuid());
    }

    public static MetricBatchSender create(Supplier<HttpPoster> httpPosterCreator, BaseConfig baseConfig) {
        return MetricBatchSender.create(MetricBatchSenderFactory.fromHttpImplementation(httpPosterCreator).configureWith(baseConfig).build());
    }

    public static MetricBatchSender create(SenderConfiguration configuration) {
        Utils.verifyNonNull(configuration.getApiKey(), "API key cannot be null");
        Utils.verifyNonNull(configuration.getHttpPoster(), "an HttpPoster implementation is required.");
        URL url = configuration.getEndpointUrl();
        MetricBatchMarshaller marshaller = new MetricBatchMarshaller(new MetricBatchJsonCommonBlockWriter(new AttributesJson()), new MetricBatchJsonTelemetryBlockWriter(new MetricToJson()));
        BatchDataSender sender = new BatchDataSender(configuration.getHttpPoster(), configuration.getApiKey(), url, configuration.isAuditLoggingEnabled(), configuration.getSecondaryUserAgent());
        return new MetricBatchSender(marshaller, sender);
    }

    public static SenderConfiguration.SenderConfigurationBuilder configurationBuilder() {
        return SenderConfiguration.builder(DEFAULT_URL, METRICS_PATH);
    }
}

