/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry.logs;

import com.newrelic.telemetry.BaseConfig;
import com.newrelic.telemetry.LogBatchSenderFactory;
import com.newrelic.telemetry.Response;
import com.newrelic.telemetry.SenderConfiguration;
import com.newrelic.telemetry.exceptions.ResponseException;
import com.newrelic.telemetry.http.HttpPoster;
import com.newrelic.telemetry.json.AttributesJson;
import com.newrelic.telemetry.logs.LogBatch;
import com.newrelic.telemetry.logs.json.LogBatchMarshaller;
import com.newrelic.telemetry.logs.json.LogJsonCommonBlockWriter;
import com.newrelic.telemetry.logs.json.LogJsonTelemetryBlockWriter;
import com.newrelic.telemetry.transport.BatchDataSender;
import com.newrelic.telemetry.util.Utils;
import java.net.URL;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogBatchSender {
    private static final String LOGS_PATH = "/log/v1";
    private static final String DEFAULT_URL = "https://log-api.newrelic.com/";
    private static final Logger logger = LoggerFactory.getLogger(LogBatchSender.class);
    private final LogBatchMarshaller marshaller;
    private final BatchDataSender sender;

    LogBatchSender(LogBatchMarshaller marshaller, BatchDataSender sender) {
        this.marshaller = marshaller;
        this.sender = sender;
    }

    public Response sendBatch(LogBatch batch) throws ResponseException {
        if (batch == null || batch.size() == 0) {
            logger.debug("Skipped sending a null or empty log batch");
            return new Response(202, "Ignored", "Empty batch");
        }
        logger.debug("Sending a log batch (number of logs: {}) to the New Relic log ingest endpoint)", (Object)batch.size());
        String json = this.marshaller.toJson(batch);
        return this.sender.send(json, batch.getUuid());
    }

    public static LogBatchSender create(Supplier<HttpPoster> httpPosterCreator, BaseConfig baseConfig) {
        return LogBatchSender.create(LogBatchSenderFactory.fromHttpImplementation(httpPosterCreator).configureWith(baseConfig).build());
    }

    public static LogBatchSender create(SenderConfiguration configuration) {
        Utils.verifyNonNull(configuration.getApiKey(), "API key cannot be null");
        Utils.verifyNonNull(configuration.getHttpPoster(), "an HttpPoster implementation is required.");
        URL url = configuration.getEndpointUrl();
        LogBatchMarshaller marshaller = new LogBatchMarshaller(new LogJsonCommonBlockWriter(new AttributesJson()), new LogJsonTelemetryBlockWriter(new AttributesJson()));
        BatchDataSender sender = new BatchDataSender(configuration.getHttpPoster(), configuration.getApiKey(), url, configuration.isAuditLoggingEnabled(), configuration.getSecondaryUserAgent());
        return new LogBatchSender(marshaller, sender);
    }

    public static SenderConfiguration.SenderConfigurationBuilder configurationBuilder() {
        return SenderConfiguration.builder(DEFAULT_URL, LOGS_PATH);
    }
}

