/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry;

import com.newrelic.telemetry.BaseConfig;
import com.newrelic.telemetry.http.HttpPoster;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;

public class SenderConfiguration {
    private final BaseConfig baseConfig;
    private final HttpPoster httpPoster;
    private final URL endpointUrl;

    public SenderConfiguration(String apiKey, HttpPoster httpPoster, URL endpointUrl, boolean auditLoggingEnabled, String secondaryUserAgent) {
        this.httpPoster = httpPoster;
        this.endpointUrl = endpointUrl;
        this.baseConfig = new BaseConfig(apiKey, auditLoggingEnabled, secondaryUserAgent);
    }

    public String getApiKey() {
        return this.baseConfig.getApiKey();
    }

    public HttpPoster getHttpPoster() {
        return this.httpPoster;
    }

    public URL getEndpointUrl() {
        return this.endpointUrl;
    }

    public boolean isAuditLoggingEnabled() {
        return this.baseConfig.isAuditLoggingEnabled();
    }

    public String getSecondaryUserAgent() {
        return this.baseConfig.getSecondaryUserAgent();
    }

    public static SenderConfigurationBuilder builder(String defaultUrl, String basePath) {
        return new SenderConfigurationBuilder(defaultUrl, basePath);
    }

    public static class SenderConfigurationBuilder {
        private final String defaultUrl;
        private final String basePath;
        private String apiKey;
        private HttpPoster httpPoster;
        private URL endpointUrl;
        private boolean auditLoggingEnabled = false;
        private String secondaryUserAgent;

        public SenderConfigurationBuilder(String defaultUrl, String basePath) {
            this.defaultUrl = defaultUrl;
            this.basePath = basePath;
        }

        public SenderConfigurationBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public SenderConfigurationBuilder httpPoster(HttpPoster httpPoster) {
            this.httpPoster = httpPoster;
            return this;
        }

        @Deprecated
        public SenderConfigurationBuilder endpoint(String scheme, String host, int port) throws MalformedURLException {
            return this.endpointWithPath(new URL(scheme, host, port, this.basePath));
        }

        @Deprecated
        public SenderConfigurationBuilder endpointWithPath(URL endpointUrl) {
            return this.endpoint(endpointUrl);
        }

        public SenderConfigurationBuilder endpoint(URL endpoint) {
            this.endpointUrl = endpoint;
            return this;
        }

        public SenderConfigurationBuilder auditLoggingEnabled(boolean auditLoggingEnabled) {
            this.auditLoggingEnabled = auditLoggingEnabled;
            return this;
        }

        public SenderConfigurationBuilder secondaryUserAgent(String secondaryUserAgent) {
            this.secondaryUserAgent = secondaryUserAgent;
            return this;
        }

        public SenderConfiguration build() {
            return new SenderConfiguration(this.apiKey, this.httpPoster, this.getOrDefaultSendUrl(), this.auditLoggingEnabled, this.secondaryUserAgent);
        }

        private URL getOrDefaultSendUrl() {
            try {
                if (this.endpointUrl != null) {
                    return this.endpointUrl;
                }
                return this.constructUrlWithHost(URI.create(this.defaultUrl));
            }
            catch (MalformedURLException e) {
                throw new UncheckedIOException("Bad Hardcoded URL " + this.defaultUrl, e);
            }
        }

        public URL constructUrlWithHost(URI hostUri) throws MalformedURLException {
            return hostUri.resolve(this.basePath).toURL();
        }
    }
}

