/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.compilerPlugin.kotlinxSerialization.quickfixes;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.util.ImportInsertHelperImpl;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlinx.serialization.compiler.diagnostic.SerializationErrors;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerializationAnnotations;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J#\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0094\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/compilerPlugin/kotlinxSerialization/quickfixes/AddKotlinxSerializationTransientImportQuickFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lcom/intellij/psi/PsiElement;", "expression", "(Lcom/intellij/psi/PsiElement;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Factory", "kotlin.compiler-plugins.kotlinx-serialization.common"})
public final class AddKotlinxSerializationTransientImportQuickFix
extends KotlinQuickFixAction<PsiElement> {
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ImportInsertHelperImpl.Companion.addImport$default((ImportInsertHelperImpl.Companion)ImportInsertHelperImpl.Companion, (Project)project, (KtFile)file, (FqName)SerializationAnnotations.INSTANCE.getSerialTransientFqName(), (boolean)false, null, (int)16, null);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    public String getText() {
        return "Import " + SerializationAnnotations.INSTANCE.getSerialTransientFqName();
    }

    public AddKotlinxSerializationTransientImportQuickFix(@NotNull PsiElement expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super(expression);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/compilerPlugin/kotlinxSerialization/quickfixes/AddKotlinxSerializationTransientImportQuickFix$Factory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.compiler-plugins.kotlinx-serialization.common"})
    public static final class Factory
    extends KotlinSingleIntentionActionFactory {
        @NotNull
        public static final Factory INSTANCE;

        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            if (Intrinsics.areEqual((Object)diagnostic.getFactory(), (Object)SerializationErrors.INCORRECT_TRANSIENT) ^ true) {
                return null;
            }
            SimpleDiagnostic castedDiagnostic = (SimpleDiagnostic)SerializationErrors.INCORRECT_TRANSIENT.cast((UnboundDiagnostic)diagnostic);
            PsiElement psiElement = castedDiagnostic.getPsiElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"castedDiagnostic.psiElement");
            PsiElement element = psiElement;
            return (IntentionAction)new AddKotlinxSerializationTransientImportQuickFix(element);
        }

        private Factory() {
        }

        static {
            Factory factory;
            INSTANCE = factory = new Factory();
        }
    }
}

