/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.compilerPlugin.kotlinxSerialization;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.config.KotlinFacetSettings;
import org.jetbrains.kotlin.idea.facet.KotlinFacet;
import org.jetbrains.kotlin.idea.facet.KotlinFacetConfiguration;
import org.jetbrains.kotlin.utils.PathUtil;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/compilerPlugin/kotlinxSerialization/KotlinSerializationImportHandler;", "", "()V", "PLUGIN_JPS_JAR", "", "getPLUGIN_JPS_JAR", "()Ljava/lang/String;", "pluginJpsJarName", "isPluginJarPath", "", "path", "modifyCompilerArguments", "", "facet", "Lorg/jetbrains/kotlin/idea/facet/KotlinFacet;", "buildSystemPluginJar", "kotlin.compiler-plugins.kotlinx-serialization.common"})
public final class KotlinSerializationImportHandler {
    private static final String pluginJpsJarName = "kotlinx-serialization-compiler-plugin.jar";
    @NotNull
    public static final KotlinSerializationImportHandler INSTANCE;

    @NotNull
    public final String getPLUGIN_JPS_JAR() {
        String string = new File(PathUtil.getKotlinPathsForIdeaPlugin().getLibPath(), pluginJpsJarName).getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"File(PathUtil.kotlinPath\u2026nJpsJarName).absolutePath");
        return string;
    }

    public final boolean isPluginJarPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return StringsKt.endsWith$default((String)path, (String)pluginJpsJarName, (boolean)false, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void modifyCompilerArguments(@NotNull KotlinFacet facet, @NotNull String buildSystemPluginJar) {
        void destination$iv;
        void $this$filterTo$iv;
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        Intrinsics.checkNotNullParameter((Object)buildSystemPluginJar, (String)"buildSystemPluginJar");
        KotlinFacetSettings facetSettings = ((KotlinFacetConfiguration)facet.getConfiguration()).getSettings();
        CommonCompilerArguments commonCompilerArguments = facetSettings.getCompilerArguments();
        if (commonCompilerArguments == null) {
            commonCompilerArguments = (CommonCompilerArguments)new CommonCompilerArguments.DummyImpl();
        }
        CommonCompilerArguments commonArguments = commonCompilerArguments;
        boolean pluginWasEnabled = false;
        String[] stringArray = commonArguments.getPluginClasspaths();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        String[] stringArray2 = stringArray;
        boolean bl = false;
        Collection collection = new ArrayList();
        boolean $i$f$filterTo = false;
        void var10_10 = $this$filterTo$iv;
        int n = ((void)var10_10).length;
        for (int i = 0; i < n; ++i) {
            boolean bl2;
            void element$iv;
            void it = element$iv = var10_10[i];
            boolean bl3 = false;
            int lastIndexOfFile = StringsKt.lastIndexOfAny$default((CharSequence)((CharSequence)it), (char[])new char[]{'/', File.separatorChar}, (int)0, (boolean)false, (int)6, null);
            if (lastIndexOfFile < 0) {
                bl2 = true;
            } else {
                CharSequence charSequence = StringsKt.drop((String)it, (int)(lastIndexOfFile + 1));
                String string = buildSystemPluginJar + "-.*\\.jar";
                boolean bl4 = false;
                string = new Regex(string);
                bl4 = false;
                boolean match = string.matches(charSequence);
                if (match) {
                    pluginWasEnabled = true;
                }
                bl2 = !match;
            }
            if (!bl2) continue;
            destination$iv.add(element$iv);
        }
        List oldPluginClasspaths = (List)destination$iv;
        List newPluginClasspaths = pluginWasEnabled ? CollectionsKt.plus((Collection)oldPluginClasspaths, (Object)this.getPLUGIN_JPS_JAR()) : oldPluginClasspaths;
        Collection $this$toTypedArray$iv = newPluginClasspaths;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray3 = thisCollection$iv.toArray(new String[0]);
        if (stringArray3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        commonArguments.setPluginClasspaths(stringArray3);
        facetSettings.setCompilerArguments(commonArguments);
    }

    private KotlinSerializationImportHandler() {
    }

    static {
        KotlinSerializationImportHandler kotlinSerializationImportHandler;
        INSTANCE = kotlinSerializationImportHandler = new KotlinSerializationImportHandler();
    }
}

