/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.htmltools.html;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.lang.html.HtmlCompatibleFile;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementWalkingVisitor;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.xml.index.XmlIndex;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class HtmlTagIdIndex
extends XmlIndex<Integer> {
    public static final ID<String, Integer> INDEX = ID.create((String)"HtmlTagIdIndex");

    @NotNull
    public ID<String, Integer> getName() {
        ID<String, Integer> iD = INDEX;
        if (iD == null) {
            HtmlTagIdIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = file -> {
            if (!file.isInLocalFileSystem()) {
                return false;
            }
            FileType fileType = file.getFileType();
            if (fileType == HtmlFileType.INSTANCE) {
                return true;
            }
            return fileType instanceof LanguageFileType && ((LanguageFileType)fileType).getLanguage() instanceof TemplateLanguage;
        };
        if (inputFilter == null) {
            HtmlTagIdIndex.$$$reportNull$$$0(1);
        }
        return inputFilter;
    }

    @NotNull
    public DataIndexer<String, Integer, FileContent> getIndexer() {
        return new DataIndexer<String, Integer, FileContent>(){

            @NotNull
            public Map<String, Integer> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    1.$$$reportNull$$$0(0);
                }
                HashMap<String, Integer> result = new HashMap<String, Integer>();
                inputData.getPsiFile().getViewProvider().getAllFiles().forEach(root -> this.processPsiFile((Map<String, Integer>)result, (PsiFile)root));
                HashMap<String, Integer> hashMap = result;
                if (hashMap == null) {
                    1.$$$reportNull$$$0(1);
                }
                return hashMap;
            }

            private void processPsiFile(final Map<String, Integer> result, PsiFile file) {
                if (file instanceof HtmlCompatibleFile) {
                    new XmlRecursiveElementWalkingVisitor(){

                        public void visitXmlAttribute(XmlAttribute attribute) {
                            super.visitXmlAttribute(attribute);
                            if ("id".equals(attribute.getName())) {
                                String value = attribute.getValue();
                                XmlAttributeValue valueElement = attribute.getValueElement();
                                if (valueElement != null && StringUtil.isNotEmpty((String)value)) {
                                    result.put(value, valueElement.getTextRange().getStartOffset() + attribute.getValueTextRange().getStartOffset());
                                }
                            }
                        }
                    }.visitFile(file);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/htmltools/html/HtmlTagIdIndex$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/htmltools/html/HtmlTagIdIndex$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    public int getVersion() {
        return 3;
    }

    @NotNull
    public DataExternalizer<Integer> getValueExternalizer() {
        return new DataExternalizer<Integer>(){

            public void save(@NotNull DataOutput out, Integer value) throws IOException {
                if (out == null) {
                    2.$$$reportNull$$$0(0);
                }
                DataInputOutputUtil.writeINT((DataOutput)out, (int)value);
            }

            public Integer read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    2.$$$reportNull$$$0(1);
                }
                return DataInputOutputUtil.readINT((DataInput)in);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/htmltools/html/HtmlTagIdIndex$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/htmltools/html/HtmlTagIdIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

