/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.supportProvider;

import com.intellij.javaee.application.facet.JavaeeApplicationFacet;
import com.intellij.javaee.application.model.xml.application.JavaeeApplication;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.ejb.model.xml.EjbJar;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.supportProvider.JavaeeFrameworkSupportContributionModel;
import com.intellij.javaee.supportProvider.JavaeeFrameworkSupportContributor;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.model.xml.WebApp;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import org.jetbrains.annotations.NotNull;

public abstract class JavaeeFrameworkSupportContributorBase
extends JavaeeFrameworkSupportContributor {
    protected boolean isApplicable(JavaeeFrameworkSupportContributionModel model) {
        return true;
    }

    protected void setupWebXml(WebApp webApp, JavaeeFrameworkSupportContributionModel model) {
    }

    protected void setupEjbJarXml(EjbJar ejbJar, JavaeeFrameworkSupportContributionModel model) {
    }

    protected void setupApplicationXml(JavaeeApplication application, JavaeeFrameworkSupportContributionModel model) {
    }

    protected void setupExplodedWarArtifact(@NotNull ModifiableArtifact artifact, JavaeeFrameworkSupportContributionModel model) {
        if (artifact == null) {
            JavaeeFrameworkSupportContributorBase.$$$reportNull$$$0(0);
        }
    }

    protected void setupExplodedEarArtifact(@NotNull ModifiableArtifact artifact, JavaeeFrameworkSupportContributionModel model) {
        if (artifact == null) {
            JavaeeFrameworkSupportContributorBase.$$$reportNull$$$0(1);
        }
    }

    protected void setupExplodedEjbArtifact(@NotNull ModifiableArtifact artifact, JavaeeFrameworkSupportContributionModel model) {
        if (artifact == null) {
            JavaeeFrameworkSupportContributorBase.$$$reportNull$$$0(2);
        }
    }

    protected void setupServerRunConfiguration(@NotNull CommonModel commonModel, JavaeeFrameworkSupportContributionModel model) {
        if (commonModel == null) {
            JavaeeFrameworkSupportContributorBase.$$$reportNull$$$0(3);
        }
    }

    protected void setupAppFacet(JavaeeApplicationFacet appFacet, JavaeeFrameworkSupportContributionModel model) {
    }

    protected void setupEjbFacet(EjbFacet ejbFacet, JavaeeFrameworkSupportContributionModel model) {
    }

    protected void setupWebFacet(WebFacet webFacet, JavaeeFrameworkSupportContributionModel model) {
    }

    public void setupFrameworkSupport(JavaeeFrameworkSupportContributionModel model) {
        if (!this.isApplicable(model)) {
            return;
        }
        this.setupArtifacts(model);
        this.setupFacets(model);
        CommonModel runConfiguration = model.getRunConfiguration();
        if (runConfiguration != null) {
            this.setupServerRunConfiguration(runConfiguration, model);
        }
    }

    private void setupFacets(JavaeeFrameworkSupportContributionModel model) {
        JavaeeApplicationFacet appFacet;
        EjbFacet ejbFacet;
        WebFacet webFacet = (WebFacet)model.getFacet(WebFacet.ID);
        if (webFacet != null) {
            this.setupWebFacet(webFacet, model);
        }
        if ((ejbFacet = (EjbFacet)model.getFacet(EjbFacet.ID)) != null) {
            this.setupEjbFacet(ejbFacet, model);
        }
        if ((appFacet = (JavaeeApplicationFacet)model.getFacet(JavaeeApplicationFacet.ID)) != null) {
            this.setupAppFacet(appFacet, model);
        }
        if (webFacet == null && ejbFacet == null && appFacet != null) {
            return;
        }
        StartupManager.getInstance((Project)model.getProject()).runWhenProjectIsInitialized(() -> {
            JavaeeApplication root;
            EjbJar ejbJar;
            WebApp webApp;
            if (webFacet != null && (webApp = webFacet.getRoot()) != null) {
                this.setupWebXml(webApp, model);
            }
            if (ejbFacet != null && (ejbJar = ejbFacet.getXmlRoot()) != null) {
                this.setupEjbJarXml(ejbJar, model);
            }
            if (appFacet != null && (root = appFacet.getRoot()) != null) {
                this.setupApplicationXml(root, model);
            }
        });
    }

    private void setupArtifacts(JavaeeFrameworkSupportContributionModel model) {
        ModifiableArtifact earArtifact;
        ModifiableArtifact ejbArtifact;
        ModifiableArtifact warArtifact = model.getModifiableExplodedWarArtifact();
        if (warArtifact != null) {
            this.setupExplodedWarArtifact(warArtifact, model);
        }
        if ((ejbArtifact = model.getModifiableExplodedEjbArtifact()) != null) {
            this.setupExplodedEjbArtifact(ejbArtifact, model);
        }
        if ((earArtifact = model.getModifiableExplodedEarArtifact()) != null) {
            this.setupExplodedEarArtifact(earArtifact, model);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonModel";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javaee/supportProvider/JavaeeFrameworkSupportContributorBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setupExplodedWarArtifact";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setupExplodedEarArtifact";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setupExplodedEjbArtifact";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setupServerRunConfiguration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

