/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.supportProvider;

import com.intellij.facet.impl.ui.libraries.FrameworkLibraryProvider;
import com.intellij.framework.FrameworkType;
import com.intellij.framework.library.LibraryBasedFrameworkType;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.appServers.integration.impl.ApplicationServerImpl;
import com.intellij.javaee.serverInstances.ApplicationServersManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class AppServerFrameworkLibraryProvider
extends FrameworkLibraryProvider {
    private static final Logger LOG = Logger.getInstance(AppServerFrameworkLibraryProvider.class);
    @NotNull
    private final ApplicationServer myServer;
    private final Map<FrameworkType, List<File>> myFrameworkLibraries;

    AppServerFrameworkLibraryProvider(@NotNull ApplicationServer server, Map<FrameworkType, List<File>> frameworkLibraries) {
        if (server == null) {
            AppServerFrameworkLibraryProvider.$$$reportNull$$$0(0);
        }
        this.myServer = server;
        this.myFrameworkLibraries = frameworkLibraries;
    }

    @NotNull
    public String getPresentableName() {
        String string = "'" + this.myServer.getName() + "' installation";
        if (string == null) {
            AppServerFrameworkLibraryProvider.$$$reportNull$$$0(1);
        }
        return string;
    }

    public Set<LibraryKind> getAvailableLibraryKinds() {
        HashSet<LibraryKind> libraryKinds = new HashSet<LibraryKind>();
        for (FrameworkType type : this.myFrameworkLibraries.keySet()) {
            if (!(type instanceof LibraryBasedFrameworkType)) continue;
            libraryKinds.add((LibraryKind)((LibraryBasedFrameworkType)type).getLibraryType().getKind());
        }
        return libraryKinds;
    }

    @NotNull
    public Library createLibrary(@NotNull Set<? extends LibraryKind> suitableLibraryKinds) {
        if (suitableLibraryKinds == null) {
            AppServerFrameworkLibraryProvider.$$$reportNull$$$0(2);
        }
        Map<FrameworkType, List<File>> libraries = this.myFrameworkLibraries;
        for (Map.Entry<FrameworkType, List<File>> entry : libraries.entrySet()) {
            FrameworkType frameworkType = entry.getKey();
            if (!(frameworkType instanceof LibraryBasedFrameworkType) || !suitableLibraryKinds.contains(((LibraryBasedFrameworkType)frameworkType).getLibraryType().getKind())) continue;
            Library library = ((ApplicationServerImpl)this.myServer).getFrameworkLibrary(frameworkType);
            if (library != null) {
                Library library2 = library;
                if (library2 == null) {
                    AppServerFrameworkLibraryProvider.$$$reportNull$$$0(3);
                }
                return library2;
            }
            ApplicationServersManager.ApplicationServersManagerModifiableModel model = ApplicationServersManager.getInstance().createModifiableModel();
            library = model.addFrameworkLibrary(this.myServer, frameworkType, entry.getValue());
            model.commit();
            Library library3 = library;
            if (library3 == null) {
                AppServerFrameworkLibraryProvider.$$$reportNull$$$0(4);
            }
            return library3;
        }
        LOG.error("Cannot find library app server library: one of " + suitableLibraryKinds + " required, " + libraries.keySet() + " found");
        if (null == null) {
            AppServerFrameworkLibraryProvider.$$$reportNull$$$0(5);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/supportProvider/AppServerFrameworkLibraryProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suitableLibraryKinds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/supportProvider/AppServerFrameworkLibraryProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createLibrary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createLibrary";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

