/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.transport;

import com.intellij.DynamicBundle;
import com.intellij.javaee.oss.transport.MultiTargetRemoteServerModel;
import com.intellij.javaee.oss.transport.RemoteStagingTarget;
import com.intellij.javaee.oss.transport.RemoteStagingTargetDefinition;
import com.intellij.javaee.oss.transport.RemoteStagingTargetEditor;
import com.intellij.javaee.oss.transport.TransportTargetKind;
import com.intellij.javaee.transport.TransportManagerConfigurable;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class MultiTargetRemoteStagingEditor {
    private TransportManagerConfigurable myTransportManagerConfigurable;
    private JPanel myMainPanel;
    private JPanel myTargetsPanel;
    private final List<TargetEditor> myTargetEditors;

    public MultiTargetRemoteStagingEditor(List<RemoteStagingTargetDefinition> targetDefs) {
        this.$$$setupUI$$$();
        this.myTargetEditors = new ArrayList<TargetEditor>();
        for (final RemoteStagingTargetDefinition targetDef : targetDefs) {
            TargetEditor targetEditor = new TargetEditor(targetDef){

                @Override
                protected TransportTargetKind getKind() {
                    return targetDef.getKind();
                }
            };
            this.myTargetEditors.add(targetEditor);
            this.myTargetsPanel.add((Component)targetEditor.getMainPanel(), MultiTargetRemoteStagingEditor.createTargetPanelConstraints());
        }
    }

    private static GridBagConstraints createTargetPanelConstraints() {
        GridBagConstraints result = new GridBagConstraints();
        result.gridx = 0;
        result.gridy = -1;
        result.weightx = 1.0;
        result.fill = 2;
        return result;
    }

    public void resetEditorFrom(MultiTargetRemoteServerModel model) {
        this.myTransportManagerConfigurable.setHostId(model.getTransportHostId(), model.getCommonModel().getProject());
        for (TargetEditor targetEditor : this.myTargetEditors) {
            targetEditor.resetEditorFrom(model);
        }
    }

    public void applyEditorTo(MultiTargetRemoteServerModel model) {
        model.setTransportHostId(this.myTransportManagerConfigurable.getHostId());
        for (TargetEditor targetEditor : this.myTargetEditors) {
            targetEditor.applyEditorTo(model);
        }
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    protected void setTargetVisible(@NotNull String targetName, boolean visible) {
        if (targetName == null) {
            MultiTargetRemoteStagingEditor.$$$reportNull$$$0(0);
        }
        for (TargetEditor targetEditor : this.myTargetEditors) {
            if (!targetEditor.getTargetName().equals(targetName)) continue;
            targetEditor.getMainPanel().setVisible(visible);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetName", "com/intellij/javaee/oss/transport/MultiTargetRemoteStagingEditor", "setTargetVisible"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        TransportManagerConfigurable transportManagerConfigurable;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/AppServersCommonBundle", MultiTargetRemoteStagingEditor.class).getString("Form.SimpleRemoteStagingEditor.title"), (int)0, (int)0, null, null));
        this.myTransportManagerConfigurable = transportManagerConfigurable = new TransportManagerConfigurable();
        JComponent jComponent = transportManagerConfigurable.$$$getRootComponent$$$();
        jPanel3.add((Component)jComponent, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myTargetsPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private abstract class TargetEditor
    extends RemoteStagingTargetEditor<MultiTargetRemoteServerModel> {
        private final String myTargetName;

        TargetEditor(RemoteStagingTargetDefinition targetDef) {
            super(MultiTargetRemoteStagingEditor.this.myTransportManagerConfigurable, targetDef.getCaption());
            this.myTargetName = targetDef.getName();
        }

        @Override
        protected RemoteStagingTarget getTargetModelEditor(MultiTargetRemoteServerModel model) {
            return model.getTarget(this.myTargetName);
        }

        public String getTargetName() {
            return this.myTargetName;
        }
    }
}

