/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.server;

import com.intellij.execution.configurations.DebuggingRunnerData;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.util.EnvironmentVariable;
import com.intellij.javaee.appServers.run.localRun.ColoredCommandLineExecutableObject;
import com.intellij.javaee.appServers.run.localRun.EnvironmentHelper;
import com.intellij.javaee.appServers.run.localRun.ExecutableObject;
import com.intellij.javaee.appServers.run.localRun.ExecutableObjectStartupPolicy;
import com.intellij.javaee.appServers.run.localRun.ScriptHelper;
import com.intellij.javaee.appServers.run.localRun.ScriptsHelper;
import com.intellij.javaee.oss.server.JavaeeParameters;
import com.intellij.javaee.oss.server.JavaeeServerModel;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public abstract class JavaeeStartupPolicy<T extends JavaeeServerModel>
implements ExecutableObjectStartupPolicy {
    public static final String JAVA_OPTS = "JAVA_OPTS";

    @Deprecated
    @Nullable
    public ScriptsHelper getStartupHelper() {
        return null;
    }

    @Deprecated
    @Nullable
    public ScriptsHelper getShutdownHelper() {
        return null;
    }

    public ScriptHelper createStartupScriptHelper(final ProgramRunner runner) {
        return new ScriptHelper(){

            public ExecutableObject getDefaultScript(CommonModel config) {
                return JavaeeStartupPolicy.this.getDefaultStartupScript(JavaeeStartupPolicy.this.getServerModel(config), JavaeeStartupPolicy.this.isDebug(runner));
            }

            public void initRunnerSettings(RunConfigurationBase runConfiguration, RunnerSettings settings) {
                if (runConfiguration instanceof CommonModel && settings instanceof DebuggingRunnerData) {
                    JavaeeStartupPolicy.this.initSettings(JavaeeStartupPolicy.this.getServerModel((CommonModel)runConfiguration), (DebuggingRunnerData)settings);
                }
            }

            public void checkRunnerSettings(RunConfigurationBase runConfiguration, RunnerSettings settings) throws RuntimeConfigurationException {
                if (runConfiguration instanceof CommonModel && settings instanceof DebuggingRunnerData) {
                    JavaeeStartupPolicy.this.checkSettings(JavaeeStartupPolicy.this.getServerModel((CommonModel)runConfiguration), (DebuggingRunnerData)settings);
                }
            }
        };
    }

    public ScriptHelper createShutdownScriptHelper(final ProgramRunner runner) {
        return new ScriptHelper(){

            public ExecutableObject getDefaultScript(CommonModel config) {
                return JavaeeStartupPolicy.this.getDefaultShutdownScript(JavaeeStartupPolicy.this.getServerModel(config), JavaeeStartupPolicy.this.isDebug(runner));
            }
        };
    }

    public EnvironmentHelper getEnvironmentHelper() {
        return new EnvironmentHelper(){

            public String getDefaultJavaVmEnvVariableName(CommonModel config) {
                return JavaeeStartupPolicy.this.getJavaVmEnvVariableName(JavaeeStartupPolicy.this.getServerModel(config));
            }

            public List<EnvironmentVariable> getAdditionalEnvironmentVariables(CommonModel config) {
                return JavaeeStartupPolicy.this.getEnvironmentVariables(JavaeeStartupPolicy.this.getServerModel(config));
            }
        };
    }

    @Nullable
    protected ExecutableObject getDefaultStartupScript(T serverModel, boolean debug) {
        JavaeeParameters params = new JavaeeParameters();
        this.getStartupParameters(params, serverModel, debug);
        return new ColoredCommandLineExecutableObject(params.get(), null);
    }

    @Nullable
    protected ExecutableObject getDefaultShutdownScript(T serverModel, boolean debug) {
        JavaeeParameters params = new JavaeeParameters();
        this.getShutdownParameters(params, serverModel, debug);
        return new ColoredCommandLineExecutableObject(params.get(), null);
    }

    @NonNls
    protected abstract void getStartupParameters(JavaeeParameters var1, T var2, boolean var3);

    @NonNls
    protected abstract void getShutdownParameters(JavaeeParameters var1, T var2, boolean var3);

    @NonNls
    protected String getJavaVmEnvVariableName(T model) {
        return JAVA_OPTS;
    }

    @Nullable
    @NonNls
    protected List<EnvironmentVariable> getEnvironmentVariables(T model) {
        return null;
    }

    protected void initSettings(T model, DebuggingRunnerData data) {
    }

    protected void checkSettings(T model, DebuggingRunnerData data) throws RuntimeConfigurationException {
    }

    protected void add(List<String> list, String ... parameters) {
        for (String parameter : parameters) {
            if (!StringUtil.isEmpty((String)parameter)) continue;
            return;
        }
        ContainerUtil.addAll(list, (Object[])parameters);
    }

    private boolean isDebug(ProgramRunner runner) {
        return "Debug".equals(runner.getRunnerId());
    }

    private T getServerModel(CommonModel config) {
        return (T)((JavaeeServerModel)config.getServerModel());
    }
}

