/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.server;

import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.LogFileOptions;
import com.intellij.execution.configurations.PredefinedLogFile;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.javaee.appServerIntegrations.ApplicationServerPersistentData;
import com.intellij.javaee.appServers.run.configuration.CommonStrategy;
import com.intellij.javaee.appServers.run.configuration.PredefinedLogFilesProvider;
import com.intellij.javaee.appServers.run.configuration.ServerModelBase;
import com.intellij.javaee.appServers.run.execution.DefaultOutputProcessor;
import com.intellij.javaee.appServers.run.execution.OutputProcessor;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.deployment.DeploymentProvider;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.oss.AppServersCommonBundle;
import com.intellij.javaee.oss.admin.JavaeeAdmin;
import com.intellij.javaee.oss.server.DeploymentStatusManager;
import com.intellij.javaee.oss.server.DisposablePositionManager;
import com.intellij.javaee.oss.server.JavaeeIntegration;
import com.intellij.javaee.oss.server.JavaeePersistentData;
import com.intellij.javaee.oss.server.JavaeeServerHomeProvider;
import com.intellij.javaee.oss.server.JavaeeServerInstance;
import com.intellij.javaee.oss.server.JavaeeServerInstanceImpl;
import com.intellij.javaee.oss.server.JavaeeServerVersionProvider;
import com.intellij.javaee.oss.server.async.JavaeeAsyncLocalInstance;
import com.intellij.javaee.oss.server.async.JavaeeAsyncRemoteInstance;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.serverInstances.DefaultServerInstance;
import com.intellij.javaee.serverInstances.J2EEServerInstance;
import com.intellij.javaee.web.debugger.engine.DefaultJSPPositionManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaSdkVersionUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaeeServerModel
extends ServerModelBase
implements PredefinedLogFilesProvider {
    private static final Logger LOG = Logger.getInstance(JavaeeServerModel.class);
    @NlsSafe
    public String USERNAME = this.getDefaultUsername();
    @NlsSafe
    public String PASSWORD = this.getDefaultPassword();
    @NlsSafe
    public String CREDENTIAL_ALIAS;
    @NlsSafe
    public boolean TEMPLATE;
    private CommonModel config;

    public void setCommonModel(CommonModel config) {
        this.config = config;
    }

    public JavaeeIntegration getIntegration() {
        return (JavaeeIntegration)this.config.getIntegration();
    }

    public J2EEServerInstance createServerInstance() throws ExecutionException {
        try {
            JavaeeIntegration integration = this.getIntegration();
            String home = this.getHome();
            LOG.debug("createServerInstance::home = " + home);
            ApplicationServerPersistentData persistentData = this.getCommonModel().getApplicationServer().getPersistentData();
            if (persistentData instanceof JavaeePersistentData) {
                integration.detectVersion((JavaeePersistentData)persistentData);
            }
            DeploymentStatusManager deploymentStatusManager = new DeploymentStatusManager();
            JavaeeServerInstanceImpl pureInstance = new JavaeeServerInstanceImpl(this.config, deploymentStatusManager);
            DefaultServerInstance result = integration.isAsyncWrapped() ? (this.isLocal() ? new JavaeeAsyncLocalInstance(pureInstance, deploymentStatusManager) : new JavaeeAsyncRemoteInstance(pureInstance, deploymentStatusManager)) : pureInstance;
            deploymentStatusManager.setServerInstance((J2EEServerInstance)result);
            return result;
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    protected final boolean isLocal() {
        return this.config.isLocal();
    }

    public DeploymentProvider getDeploymentProvider() {
        return null;
    }

    public int getDefaultPort() {
        return 8080;
    }

    public int getLocalPort() {
        return this.getDefaultPort();
    }

    public int getPingPort() {
        return this.getServerPort();
    }

    @NotNull
    public String getDefaultUrlForBrowser() {
        String string = this.getIntegration().getDeployedFileUrlProvider().getDefaultUrlForServerConfig(this.config);
        if (string == null) {
            JavaeeServerModel.$$$reportNull$$$0(0);
        }
        return string;
    }

    public OutputProcessor createOutputProcessor(ProcessHandler handler, J2EEServerInstance instance) {
        return new DefaultOutputProcessor(handler);
    }

    public List<Pair<String, Integer>> getAddressesToCheck() {
        ArrayList<Pair<String, Integer>> addressesToCheck = new ArrayList<Pair<String, Integer>>();
        if (this.isLocal()) {
            String serverHost = this.getServerHost();
            addressesToCheck.add((Pair<String, Integer>)new Pair((Object)serverHost, (Object)this.getServerPort()));
            addressesToCheck.add((Pair<String, Integer>)new Pair((Object)serverHost, (Object)this.getLocalPort()));
        }
        return addressesToCheck;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        if (!this.isEmptyPasswordAllowed() && StringUtil.isNotEmpty((String)this.USERNAME) && StringUtil.isEmpty((String)this.PASSWORD)) {
            throw new RuntimeConfigurationError(AppServersCommonBundle.getText("ServerModel.password", new Object[0]));
        }
    }

    @Override
    protected void read(@NotNull Element element, boolean isPersistent) throws InvalidDataException {
        if (element == null) {
            JavaeeServerModel.$$$reportNull$$$0(1);
        }
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
    }

    @Override
    protected void write(@NotNull Element element, boolean isPersistent) throws WriteExternalException {
        if (element == null) {
            JavaeeServerModel.$$$reportNull$$$0(2);
        }
        DefaultJDOMExternalizer.write((Object)this, (Element)element, field -> this.isAccept((Field)field, isPersistent));
    }

    private boolean isAccept(@NotNull Field field, boolean isPersistent) {
        String fieldName;
        if (field == null) {
            JavaeeServerModel.$$$reportNull$$$0(3);
        }
        if (this.isPasswordField(fieldName = field.getName())) {
            return !this.TEMPLATE && !isPersistent;
        }
        if ("CREDENTIAL_ALIAS".equals(fieldName)) {
            return !this.TEMPLATE;
        }
        if ("TEMPLATE".equals(fieldName)) {
            return !isPersistent;
        }
        return true;
    }

    protected boolean isPasswordField(@NotNull String fieldName) {
        if (fieldName == null) {
            JavaeeServerModel.$$$reportNull$$$0(4);
        }
        return "PASSWORD".equals(fieldName);
    }

    @Override
    public boolean isTemplate() {
        return this.TEMPLATE;
    }

    public void setTemplate(boolean isTemplate) {
        this.TEMPLATE = isTemplate;
    }

    @Override
    @Nullable
    public String getPassword() {
        return this.PASSWORD;
    }

    @Override
    public void setPassword(@NotNull String password) {
        if (password == null) {
            JavaeeServerModel.$$$reportNull$$$0(5);
        }
        this.PASSWORD = password;
    }

    @Override
    protected boolean isDefaultPasswords() {
        return Objects.equals(this.getDefaultPassword(), this.PASSWORD);
    }

    @Override
    @Nullable
    protected String getCredentialAlias() {
        return this.CREDENTIAL_ALIAS;
    }

    @Override
    protected void setCredentialAlias(@Nullable String credentialAlias) {
        this.CREDENTIAL_ALIAS = credentialAlias;
    }

    public String getHome() {
        return new JavaeeServerHomeProvider(this).getValue();
    }

    public String getVersion() {
        return new JavaeeServerVersionProvider(this).getValue();
    }

    public String getVmArguments() {
        return this.config instanceof CommonStrategy ? ((CommonStrategy)this.config).getSettingsBean().COMMON_VM_ARGUMENTS : "";
    }

    @NonNls
    private static String getVmArgumentPrefix(String name) {
        return "-D" + name + "=";
    }

    @NonNls
    private String[] getVmArgumentsList() {
        return this.getVmArguments().split("\\s+");
    }

    @Nullable
    public String getVmArgument(String name) {
        String prefix = JavaeeServerModel.getVmArgumentPrefix(name);
        for (String arg : this.getVmArgumentsList()) {
            if (!arg.startsWith(prefix)) continue;
            return StringUtil.unquoteString((String)arg.substring(prefix.length()));
        }
        return null;
    }

    public void setVmArgument(String name, String value) {
        if (!(this.config instanceof CommonStrategy)) {
            return;
        }
        @NonNls String prefix = JavaeeServerModel.getVmArgumentPrefix(name);
        String newArg = value == null ? null : prefix + value;
        ArrayList<Object> newArgs = new ArrayList<Object>();
        for (String arg : this.getVmArgumentsList()) {
            if (arg.startsWith(prefix)) {
                if (newArg == null) continue;
                newArgs.add(newArg);
                newArg = null;
                continue;
            }
            newArgs.add(arg);
        }
        if (newArg != null) {
            newArgs.add(newArg);
        }
        ((CommonStrategy)this.config).getSettingsBean().COMMON_VM_ARGUMENTS = StringUtil.join(newArgs, (String)" ");
    }

    protected boolean isEmptyPasswordAllowed() {
        return false;
    }

    @NonNls
    protected abstract String getDefaultUsername();

    @NonNls
    protected abstract String getDefaultPassword();

    protected abstract int getServerPort();

    protected abstract JavaeeAdmin createServerAdmin(JavaeeServerInstance var1) throws Exception;

    protected String getServerHost() {
        return this.config.getHost();
    }

    @Override
    public CommonModel getCommonModel() {
        return this.config;
    }

    protected List<File> getLibraries() throws ExecutionException {
        ArrayList<File> libraries = new ArrayList<File>();
        for (VirtualFile file : this.config.getApplicationServer().getLibrary().getFiles(OrderRootType.CLASSES)) {
            libraries.add(new File(file.getPresentableUrl()));
        }
        return libraries;
    }

    public File getPathUnderHome(String relativePath) {
        return new JavaeeServerHomeProvider(this).getPathUnderHome(relativePath);
    }

    public PredefinedLogFile @NotNull [] getPredefinedLogFiles() {
        ArrayList<PredefinedLogFile> result = new ArrayList<PredefinedLogFile>();
        for (LogFileFactory factory : this.getLogFileFactories()) {
            result.add(factory.createPredefinedLogFile());
        }
        PredefinedLogFile[] predefinedLogFileArray = result.toArray(new PredefinedLogFile[0]);
        if (predefinedLogFileArray == null) {
            JavaeeServerModel.$$$reportNull$$$0(6);
        }
        return predefinedLogFileArray;
    }

    @Nullable
    public LogFileOptions getOptionsForPredefinedLogFile(PredefinedLogFile file) {
        for (LogFileFactory factory : this.getLogFileFactories()) {
            LogFileOptions result = factory.createOptions(file);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    protected List<LogFileFactory> getLogFileFactories() {
        return Collections.singletonList(new DefaultLogFileFactory());
    }

    @Nullable
    protected String getLogFilePath(String home) {
        return null;
    }

    protected boolean isTruncateLogFile() {
        return false;
    }

    public void updateChangedFiles(Set<String> changedFilesPaths) {
    }

    protected PositionManager createPositionManager(DebugProcess process, JavaeeFacet[] scopeFacetsWithIncluded) {
        return new DefaultJSPPositionManager(process, scopeFacetsWithIncluded){

            @NonNls
            protected String getGeneratedClassesPackage() {
                return "org.apache.jsp";
            }
        };
    }

    public boolean undeployBeforeDeploy(DeploymentModel deploymentModel) {
        return this.undeployBeforeDeploy();
    }

    public boolean undeployBeforeDeploy() {
        return true;
    }

    public void initProcessDebug(ProcessHandler handler) {
        final CommonModel commonModel = this.getCommonModel();
        DebuggerManager.getInstance((Project)commonModel.getProject()).addDebugProcessListener(handler, new DebugProcessListener(){
            PositionManager myPositionManager;

            public void processAttached(@NotNull DebugProcess process) {
                if (process == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.myPositionManager = JavaeeServerModel.this.createPositionManager(process, DefaultServerInstance.getScopeFacetsWithIncluded((CommonModel)commonModel));
                process.appendPositionManager(this.myPositionManager);
            }

            public void processDetached(@NotNull DebugProcess process, boolean closedByUser) {
                if (process == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (this.myPositionManager instanceof DisposablePositionManager) {
                    ((DisposablePositionManager)this.myPositionManager).dispose();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "process";
                objectArray2[1] = "com/intellij/javaee/oss/server/JavaeeServerModel$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processAttached";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processDetached";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public boolean isDetectableLocalPort() {
        return true;
    }

    public boolean isDetectableServerPort() {
        return true;
    }

    public Sdk getJre() {
        return ((CommonStrategy)this.config).getJre();
    }

    public String getJrePath() {
        Sdk jre = this.getJre();
        if (jre == null) {
            return null;
        }
        String jrePath = jre.getHomePath();
        return jrePath == null ? null : FileUtil.toSystemDependentName((String)jrePath);
    }

    protected void checkHasJdk() throws RuntimeConfigurationError {
        if (this.getJre() == null) {
            throw new RuntimeConfigurationError(this.getJdkRequiredMessage());
        }
    }

    protected void checkJdkAtMost7() throws RuntimeConfigurationError {
        JavaSdkVersion sdkVersion;
        Sdk jre = this.getJre();
        if (jre != null && (sdkVersion = JavaSdkVersionUtil.getJavaSdkVersion((Sdk)jre)) != null && sdkVersion.isAtLeast(JavaSdkVersion.JDK_1_8)) {
            throw new RuntimeConfigurationError(this.getJdkTooNewMessage());
        }
    }

    @Nls
    protected String getJdkTooNewMessage() {
        return this.isLocal() ? AppServersCommonBundle.getText("JavaeeServerModel.local.error.runtime.jdk.too.new", new Object[0]) : AppServersCommonBundle.getText("JavaeeServerModel.remote.error.runtime.jdk.too.new", new Object[0]);
    }

    protected void checkJdkAtLeast7() throws RuntimeConfigurationError {
        this.doCheckJdkAtLeast(JavaSdkVersion.JDK_1_7);
    }

    protected void doCheckJdkAtLeast(JavaSdkVersion jdkVersion) throws RuntimeConfigurationError {
        Sdk jre = this.getJre();
        JavaSdkVersion sdkVersion = JavaSdkVersionUtil.getJavaSdkVersion((Sdk)jre);
        if (sdkVersion != null && !sdkVersion.isAtLeast(jdkVersion)) {
            throw new RuntimeConfigurationError(this.getJdkTooOldMessage(jdkVersion.getDescription()));
        }
    }

    @Nls
    protected String getJdkTooOldMessage(String version) {
        return this.isLocal() ? AppServersCommonBundle.getText("JavaeeServerModel.local.error.runtime.jdk.too.old", version) : AppServersCommonBundle.getText("JavaeeServerModel.remote.error.runtime.jdk.too.old", version);
    }

    @Nls
    protected String getJdkRequiredMessage() {
        return this.isLocal() ? AppServersCommonBundle.getText("JavaeeServerModel.local.error.runtime.jdk.required", new Object[0]) : AppServersCommonBundle.getText("JavaeeServerModel.remote.error.runtime.jdk.required", new Object[0]);
    }

    public String getServerSpecificContext(DeploymentModel model) {
        File source = model.getDeploymentSource().getFile();
        return source == null ? null : this.getServerSpecificContext(source);
    }

    public String getServerSpecificContext(File source) {
        return source.getName();
    }

    public static String cutWarExtension(File source) {
        return FileUtilRt.extensionEquals((String)source.getName(), (String)"war") ? FileUtilRt.getNameWithoutExtension((String)source.getName()) : source.getName();
    }

    @NonNls
    protected abstract String getLogFileId();

    public boolean isPingSupported() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/oss/server/JavaeeServerModel";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "password";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultUrlForBrowser";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/oss/server/JavaeeServerModel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedLogFiles";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAccept";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isPasswordField";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setPassword";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class DefaultLogFileFactory
    extends LogFileFactory {
        protected DefaultLogFileFactory() {
        }

        @Override
        protected String getId() {
            return JavaeeServerModel.this.getLogFileId();
        }

        @Override
        protected String getPath() {
            return JavaeeServerModel.this.getLogFilePath(JavaeeServerModel.this.getHome());
        }
    }

    protected static abstract class LogFileFactory {
        private final boolean myEnabled;

        protected LogFileFactory(boolean enabled) {
            this.myEnabled = enabled;
        }

        protected LogFileFactory() {
            this(true);
        }

        protected LogFileOptions createOptions(PredefinedLogFile file) {
            String path;
            if (this.getId().equals(file.getId()) && (path = this.getPath()) != null) {
                String name = AppServersCommonBundle.getText("ServerModel.logfile", this.getName());
                return new LogFileOptions(name, path, file.isEnabled());
            }
            return null;
        }

        public PredefinedLogFile createPredefinedLogFile() {
            return new PredefinedLogFile(this.getId(), this.myEnabled);
        }

        protected String getName() {
            return this.getId();
        }

        protected abstract String getId();

        protected abstract String getPath();
    }
}

