/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.cloud.agent;

import com.intellij.javaee.oss.cloud.agent.CloudListItemWrapper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public abstract class CloudListWrapper<M, I, W extends CloudListItemWrapper> {
    public M getModel() {
        List<I> items = this.loadItems();
        if (items == null) {
            return null;
        }
        ArrayList<W> wrappers = new ArrayList<W>();
        for (I item : this.loadItems()) {
            wrappers.add(this.wrapItem(item));
        }
        return this.createModel(wrappers);
    }

    public void setModel(M model) {
        HashSet<String> oldIds = new HashSet<String>();
        List<I> items = this.loadItems();
        if (items == null) {
            return;
        }
        for (I item : this.loadItems()) {
            W wrapper2 = this.wrapItem(item);
            oldIds.add(wrapper2.getId());
        }
        ArrayList<CloudListItemWrapper> newWrappers = new ArrayList<CloudListItemWrapper>();
        for (CloudListItemWrapper wrapper3 : this.getWrappers(model)) {
            if (wrapper3.isNew()) {
                newWrappers.add(wrapper3);
            }
            oldIds.remove(wrapper3.getId());
        }
        for (String oldId : oldIds) {
            this.deleteItem(oldId);
        }
        for (CloudListItemWrapper wrapper4 : newWrappers) {
            this.createItem(wrapper4);
        }
    }

    protected abstract List<I> loadItems();

    protected abstract void deleteItem(String var1);

    protected abstract void createItem(W var1);

    protected abstract W wrapItem(I var1);

    protected abstract M createModel(List<W> var1);

    protected abstract W[] getWrappers(M var1);
}

