/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.agent;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ShortenCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.javaee.oss.AppServersCommonBundle;
import com.intellij.javaee.oss.agent.AgentCallback;
import com.intellij.javaee.oss.agent.AgentDeploymentCallback;
import com.intellij.javaee.oss.agent.AgentExtension;
import com.intellij.javaee.oss.agent.AgentProxyFactory;
import com.intellij.javaee.oss.agent.ParametersMap;
import com.intellij.javaee.oss.agent.VendorSpecificAgent;
import com.intellij.javaee.oss.process.JavaeeProcess;
import com.intellij.javaee.oss.server.JavaeeServerInstance;
import com.intellij.javaee.process.JavaeeProcessConnection;
import com.intellij.javaee.process.JavaeeProcessObject;
import com.intellij.javaee.process.JavaeeProcessObjectBase;
import com.intellij.javaee.process.common.Base64EncodingUtil;
import com.intellij.javaee.process.common.JavaeeProcessUtilException;
import com.intellij.javaee.process.common.MethodResultTypeSerializer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.agent.impl.util.UrlCollector;
import com.intellij.util.PathUtil;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProcessAgentProxyFactory
implements AgentProxyFactory {
    private static final Logger LOG = Logger.getInstance(ProcessAgentProxyFactory.class);
    private static final String INCOMPATIBLE_JDK_MARK = "java.lang.UnsupportedClassVersionError";
    private final JavaeeServerInstance myServer;

    public ProcessAgentProxyFactory(JavaeeServerInstance server) {
        this.myServer = server;
    }

    public <T> T createProxy(List<File> libraries, Class<T> agentInterface, String agentClassName) throws Exception {
        LOG.assertTrue(VendorSpecificAgent.class.equals(agentInterface), (Object)"VendorSpecificAgent is the only interface supported by ProcessAgentProxyFactory");
        final JavaeeProcessConnection connection = new JavaeeProcessConnection(this.getClass().getClassLoader());
        Disposer.register((Disposable)this.myServer.getProject(), (Disposable)new Disposable(){

            public void dispose() {
                connection.close();
            }
        });
        return agentInterface.cast(new ProcessAgentProxy(connection, libraries, agentClassName));
    }

    protected final boolean isJava9Plus() {
        Sdk jdk = this.getJdk();
        return jdk != null && jdk.getSdkType() instanceof JavaSdkType && JavaSdk.getInstance().isOfVersionOrHigher(jdk, JavaSdkVersion.JDK_1_9);
    }

    private void createProcess(final JavaeeProcessConnection connection, List<File> libraries, String agentClassName) throws ExecutionException {
        Class<?> processClass = this.getProcessClass();
        JavaParameters javaParameters = new JavaParameters();
        javaParameters.setMainClass(processClass.getName());
        javaParameters.setJdk(this.getJdk());
        javaParameters.getClassPath().addAllFiles(new UrlCollector().collectFiles(libraries));
        javaParameters.getClassPath().add(PathUtil.getJarPathForClass(processClass));
        javaParameters.getClassPath().add(PathUtil.getJarPathForClass(this.getProcessObjectClass()));
        javaParameters.getProgramParametersList().add(String.valueOf(connection.getSocketConnection().getPort()));
        javaParameters.getProgramParametersList().add(agentClassName);
        Sdk jdk = this.getJdk();
        if (jdk != null) {
            ShortenCommandLine mode = ShortenCommandLine.getDefaultMethod((Project)this.myServer.getProject(), (String)jdk.getHomePath());
            if (this.isJava9Plus()) {
                mode = ShortenCommandLine.MANIFEST;
            }
            if (mode == ShortenCommandLine.NONE) {
                mode = ShortenCommandLine.CLASSPATH_FILE;
            }
            javaParameters.setShortenCommandLine(mode, this.myServer.getProject());
        } else {
            javaParameters.setUseDynamicClasspath(this.myServer.getProject());
        }
        this.customizeParameters(javaParameters);
        OSProcessHandler processHandler = javaParameters.createOSProcessHandler();
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                connection.close();
                ProcessAgentProxyFactory.this.myServer.shutdown();
            }

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                ProcessHandler processHandler;
                String text;
                if (event == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (outputType == null) {
                    2.$$$reportNull$$$0(2);
                }
                if ((text = StringUtil.notNullize((String)event.getText())).startsWith("<Non-response-exception>")) {
                    text = StringUtil.trimStart((String)text, (String)"<Non-response-exception>").replaceAll("\\s+", " ");
                    text = AppServersCommonBundle.getText("ProcessAgentProxyFactory.non.response.exception", text);
                }
                if ((processHandler = ProcessAgentProxyFactory.this.myServer.getProcessHandler()) == null) {
                    LOG.info(text);
                } else {
                    LOG.debug(text);
                    processHandler.notifyTextAvailable(text, outputType);
                    if (text.contains(ProcessAgentProxyFactory.INCOMPATIBLE_JDK_MARK)) {
                        processHandler.notifyTextAvailable(AppServersCommonBundle.getText("ProcessAgentProxyFactory.incompatible.jdk", new Object[0]), outputType);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/javaee/oss/agent/ProcessAgentProxyFactory$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        processHandler.startNotify();
    }

    @Nullable
    protected Sdk getJdk() {
        return ProjectRootManager.getInstance((Project)this.myServer.getProject()).getProjectSdk();
    }

    protected void customizeParameters(JavaParameters javaParameters) {
    }

    protected Class<?> getProcessClass() {
        return JavaeeProcess.class;
    }

    protected Class<?> getProcessObjectClass() {
        return JavaeeProcessObject.class;
    }

    private class ProcessAgentProxy
    implements VendorSpecificAgent {
        private final JavaeeProcessConnection myConnection;
        private final List<File> myLibraries;
        private final String myAgentClassName;
        private final ProcessAgentProxyDelegate myDelegate;

        ProcessAgentProxy(JavaeeProcessConnection connection, List<File> libraries, String agentClassName) {
            this.myConnection = connection;
            this.myLibraries = libraries;
            this.myAgentClassName = agentClassName;
            this.myDelegate = new ProcessAgentProxyDelegate(connection);
        }

        private VendorSpecificAgent getProxy() {
            return this.myDelegate.getAgentProxy();
        }

        @Override
        public void init(String host, int port, String username, String password, ParametersMap initParameters, final AgentCallback callback) throws Exception {
            ProcessAgentProxyFactory.this.createProcess(this.myConnection, this.myLibraries, this.myAgentClassName);
            AgentCallback loggerWrapper = new AgentCallback(){

                public void debugEx(Exception e) {
                    callback.debugEx(e);
                }

                public void errorEx(Exception e) {
                    callback.errorEx(e);
                }

                public void debug(String message) {
                    callback.debug(Base64EncodingUtil.decodeBase64((String)message));
                }

                public void error(String message) {
                    callback.error(Base64EncodingUtil.decodeBase64((String)message));
                }

                public void info(String message) {
                    callback.info(Base64EncodingUtil.decodeBase64((String)message));
                }

                @Override
                public void fireUpdateDeploymentStatus() {
                    callback.fireUpdateDeploymentStatus();
                }
            };
            this.getProxy().init(host, port, username, password, initParameters, loggerWrapper);
        }

        @Override
        public void destroy() {
            this.getProxy().destroy();
            this.myConnection.close();
        }

        @Override
        public void startDeploy(String deploymentName, File source, ParametersMap deployParameters, AgentDeploymentCallback callback) {
            this.getProxy().startDeploy(deploymentName, source, deployParameters, callback);
        }

        @Override
        public void startUndeploy(String deploymentName, AgentDeploymentCallback callback) {
            this.getProxy().startUndeploy(deploymentName, callback);
        }

        @Override
        public void updateDeploymentStatus(String deploymentName, AgentDeploymentCallback callback) {
            this.getProxy().updateDeploymentStatus(deploymentName, callback);
        }

        @Override
        public boolean connect() {
            return this.getProxy().connect();
        }

        @Override
        public void disconnect() {
            this.getProxy().disconnect();
        }

        @Override
        public AgentExtension getExtension() {
            return this.getProxy().getExtension();
        }
    }

    private static class ProcessAgentProxyDelegate
    extends JavaeeProcessObjectBase<VendorSpecificAgent> {
        ProcessAgentProxyDelegate(JavaeeProcessConnection connection) {
            super(VendorSpecificAgent.class, connection, "");
            this.getMethodParamSerializer().addType((MethodResultTypeSerializer)new JavaeeProcessObjectBase.MethodListenerParamSerializer((JavaeeProcessObjectBase)this, AgentDeploymentCallback.class));
            this.getMethodParamSerializer().addType((MethodResultTypeSerializer)new JavaeeProcessObjectBase.MethodListenerParamSerializer((JavaeeProcessObjectBase)this, AgentCallback.class));
            this.getMethodParamSerializer().addType((MethodResultTypeSerializer)new MethodResultTypeSerializer<ParametersMap>(ParametersMap.class){

                protected String doSerializeResult(ParametersMap methodResult) throws JavaeeProcessUtilException {
                    return methodResult.save();
                }
            });
        }

        public VendorSpecificAgent getAgentProxy() {
            return (VendorSpecificAgent)this.getProxy();
        }
    }
}

