/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.appServers.run.localRun;

import com.intellij.icons.AllIcons;
import com.intellij.javaee.appServers.AppServersIntegrationBundle;
import com.intellij.javaee.appServers.run.localRun.ScriptParser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class UserScriptPanel {
    private final TextFieldWithBrowseButton myPathField = new TextFieldWithBrowseButton();
    private final JPanel myPanel;
    private final FixedSizeButton mySetParametersButton;
    private String myInitialProgramParameters;

    public UserScriptPanel(@Nls String title, FileChooserDescriptor fileChooserDescriptor) {
        this.myPathField.addBrowseFolderListener(title, null, null, fileChooserDescriptor, (TextComponentAccessor)new TextComponentAccessor<JTextField>(){

            public String getText(JTextField component) {
                return new ScriptParser(component.getText()).getPath();
            }

            public void setText(JTextField component, @NotNull String text) {
                ScriptParser scriptParser;
                if (text == null) {
                    1.$$$reportNull$$$0(0);
                }
                String parameters = (scriptParser = new ScriptParser(component.getText())).isValid() ? scriptParser.getParameters() : UserScriptPanel.this.myInitialProgramParameters;
                component.setText(new ScriptParser(text, parameters).combine());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/javaee/appServers/run/localRun/UserScriptPanel$1", "setText"));
            }
        });
        FileChooserFactory.getInstance().installFileCompletion(this.myPathField.getTextField(), fileChooserDescriptor, true, null);
        this.myPanel = new JPanel(new BorderLayout());
        this.myPanel.add((Component)this.myPathField, "Center");
        this.mySetParametersButton = new FixedSizeButton((JComponent)this.myPathField.getTextField());
        this.mySetParametersButton.setIcon(AllIcons.Actions.ShowViewer);
        this.mySetParametersButton.setToolTipText(AppServersIntegrationBundle.message((String)"tooltip.text.script.parameters", (Object[])new Object[0]));
        this.myPanel.add((Component)this.mySetParametersButton, "East");
    }

    public JPanel getComponent() {
        return this.myPanel;
    }

    public JTextField getTextField() {
        return this.myPathField.getTextField();
    }

    public void setText(String text) {
        this.myPathField.getTextField().setText(text);
    }

    public String getText() {
        return this.getTextField().getText();
    }

    public void addCustomizeParametersActionListener(ActionListener actionListener) {
        this.mySetParametersButton.addActionListener(actionListener);
    }

    public void setInitialProgramParameters(String initialProgramParameters) {
        this.myInitialProgramParameters = initialProgramParameters;
    }

    public ScriptParser createScriptParser() {
        return new ScriptParser(this.getText());
    }
}

