/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.appServers.run.configuration;

import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.debugger.impl.GenericDebuggerRunnerSettings;
import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.diagnostic.logging.LogConsole;
import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.configuration.PersistentAwareRunConfiguration;
import com.intellij.execution.configurations.AdditionalTabComponentManager;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.LocatableConfiguration;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.LogFileOptions;
import com.intellij.execution.configurations.PredefinedLogFile;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunConfigurationWithRunnerSettings;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.JvmPatchableProgramRunner;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.ide.impl.convert.JDomConvertingUtil;
import com.intellij.javaee.appServerIntegrations.AppServerIntegration;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.appServers.AppServersIntegrationBundle;
import com.intellij.javaee.appServers.deployment.ui.DeploymentSettingsPanel;
import com.intellij.javaee.appServers.ex.openapi.ex.DeploymentManagerEx;
import com.intellij.javaee.appServers.run.configuration.AdditionalTabsProvider;
import com.intellij.javaee.appServers.run.configuration.CheckUtil;
import com.intellij.javaee.appServers.run.configuration.DeploymentSettingsImpl;
import com.intellij.javaee.appServers.run.configuration.DeploysArtifactsOnStartupOnly;
import com.intellij.javaee.appServers.run.configuration.JavaCommandLineStartupPolicy;
import com.intellij.javaee.appServers.run.configuration.JavaeeRunConfigurationCommonSettingsBean;
import com.intellij.javaee.appServers.run.configuration.LogCustomizer;
import com.intellij.javaee.appServers.run.configuration.MarkArtifactForDeploymentQuickFix;
import com.intellij.javaee.appServers.run.configuration.PredefinedLogFilesProvider;
import com.intellij.javaee.appServers.run.configuration.RunnerSpecificLocalConfigurationBit;
import com.intellij.javaee.appServers.run.configuration.RunnerSpecificRemoteConfigurationBit;
import com.intellij.javaee.appServers.run.configuration.ServerModel;
import com.intellij.javaee.appServers.run.configuration.view.J2EERunConfigurationEditor;
import com.intellij.javaee.appServers.run.configuration.view.JavaeeRunConfigurationEditorContext;
import com.intellij.javaee.appServers.run.configuration.view.RunnerSpecificLocalPanel;
import com.intellij.javaee.appServers.run.configuration.view.RunnerSpecificRemotePanel;
import com.intellij.javaee.appServers.run.execution.ExecutionHelper;
import com.intellij.javaee.appServers.run.execution.J2EERemoteState;
import com.intellij.javaee.appServers.run.execution.JavaCommandLineLocalState;
import com.intellij.javaee.appServers.run.execution.OutputProcessor;
import com.intellij.javaee.appServers.run.execution.PatchedLocalState;
import com.intellij.javaee.appServers.run.execution.update.HotSwapClassesUpdatingPolicy;
import com.intellij.javaee.appServers.run.execution.update.ReloadClassesAndResourcesUpdatingPolicy;
import com.intellij.javaee.appServers.run.execution.update.ReloadResourcesUpdatingPolicy;
import com.intellij.javaee.appServers.run.execution.update.SelectUpdatingPolicyDialog;
import com.intellij.javaee.appServers.run.execution.update.UpdatingPolicy;
import com.intellij.javaee.appServers.run.execution.update.UpdatingRunningApplicationUtil;
import com.intellij.javaee.appServers.run.localRun.EnvironmentHelper;
import com.intellij.javaee.appServers.run.localRun.ExecutableObject;
import com.intellij.javaee.appServers.run.localRun.ExecutableObjectStartupPolicy;
import com.intellij.javaee.appServers.run.localRun.ScriptHelper;
import com.intellij.javaee.appServers.run.localRun.ScriptsHelper;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.deployment.DeploymentProvider;
import com.intellij.javaee.deployment.DeploymentSettings;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetType;
import com.intellij.javaee.facet.JavaeeFacetUtil;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.serverInstances.ApplicationServersManager;
import com.intellij.javaee.serverInstances.J2EEServerInstance;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationQuickFix;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectModelBuildableElement;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskManager;
import com.intellij.task.impl.ProjectTaskList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonStrategy
extends LocatableConfigurationBase
implements CommonModel,
LocatableConfiguration,
RunConfigurationWithRunnerSettings,
RefactoringListenerProvider,
PersistentAwareRunConfiguration {
    private static final Logger LOG = Logger.getInstance(CommonStrategy.class);
    @NonNls
    public static final String FACET_ID_ATTRIBUTE = "FACET_ID";
    @NonNls
    public static final String FACET_ELEMENT = "JAVAEE_FACET";
    @NonNls
    private static final String APPLICATION_SERVER_NAME = "APPLICATION_SERVER_NAME";
    @NonNls
    private static final String ALTERNATIVE_JRE_ENABLED = "ALTERNATIVE_JRE_ENABLED";
    @NonNls
    private static final String ALTERNATIVE_JRE_PATH = "ALTERNATIVE_JRE_PATH";
    @NonNls
    private static final String SERVER_SETTINGS_ELEMENT = "server-settings";
    private final AppServerIntegration myIntegration;
    private ApplicationServer myApplicationServer;
    @NlsSafe
    private String myApplicationServerName;
    private JavaeeRunConfigurationCommonSettingsBean mySettingsBean = new JavaeeRunConfigurationCommonSettingsBean();
    private ServerModel myServerModel;
    private final JavaCommandLineStartupPolicy myJavaCommandLineStartupPolicy;
    private final ExecutableObjectStartupPolicy myExecutableObjectStartupPolicy;
    private DeploymentSettingsImpl myDeploymentSettings;
    private boolean myAlternativeJreEnabled;
    private String myAlternativeJrePath;

    public CommonStrategy(String name, AppServerIntegration integration, Project project, ConfigurationFactory factory, ServerModel serverModel, boolean isLocal, JavaCommandLineStartupPolicy javaPolicy) {
        this(name, integration, project, factory, serverModel, isLocal, javaPolicy, null);
    }

    public CommonStrategy(String name, AppServerIntegration integration, Project project, ConfigurationFactory factory, ServerModel serverModel, boolean isLocal, ExecutableObjectStartupPolicy executablePolicy) {
        this(name, integration, project, factory, serverModel, isLocal, null, executablePolicy);
    }

    private CommonStrategy(String name, AppServerIntegration integration, Project project, ConfigurationFactory factory, ServerModel serverModel, boolean isLocal, JavaCommandLineStartupPolicy javaPolicy, ExecutableObjectStartupPolicy executablePolicy) {
        super(project, factory, name != null ? name : AppServersIntegrationBundle.message((String)"default.run.configuration.name.unnamed", (Object[])new Object[0]));
        this.myIntegration = integration;
        this.myServerModel = serverModel;
        this.myServerModel.setCommonModel((CommonModel)this);
        this.mySettingsBean.PORT = this.myServerModel.getDefaultPort();
        this.setLocal(isLocal);
        this.myDeploymentSettings = CommonStrategy.createDeploymentSettings(project, this);
        this.myJavaCommandLineStartupPolicy = javaPolicy;
        this.myExecutableObjectStartupPolicy = executablePolicy;
        this.addPredefinedLogFiles();
    }

    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        return RunConfigurationExtension.wrapRefactoringElementListener((PsiElement)element, (RunConfigurationBase)this, null);
    }

    private static DeploymentSettingsImpl createDeploymentSettings(Project project, CommonStrategy commonStrategy) {
        DeploymentProvider deploymentProvider = commonStrategy.getDeploymentProvider();
        return deploymentProvider != null ? new DeploymentSettingsImpl(project, commonStrategy, deploymentProvider) : null;
    }

    private void addPredefinedLogFiles() {
        if (this.myServerModel instanceof PredefinedLogFilesProvider) {
            for (PredefinedLogFile predefined : ((PredefinedLogFilesProvider)this.myServerModel).getPredefinedLogFiles()) {
                this.addPredefinedLogFile(predefined);
            }
        }
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        JavaeeRunConfigurationEditorContext editorContext = new JavaeeRunConfigurationEditorContext((SettingsEditorGroup<CommonStrategy>)group, this.getFactory(), this.getProject());
        LogConfigurationPanel logConfigurationPanel = new LogConfigurationPanel();
        J2EERunConfigurationEditor commonSettingsEditor = new J2EERunConfigurationEditor(this, (LogConfigurationPanel<? extends RunConfigurationBase>)logConfigurationPanel, editorContext);
        group.addEditor(AppServersIntegrationBundle.message((String)"title.run.configuration.editor.server", (Object[])new Object[0]), (SettingsEditor)commonSettingsEditor);
        SettingsEditor<CommonStrategy> newDeploymentSettingsEditor = this.createArtifactDeploymentSettingsEditor(editorContext);
        if (newDeploymentSettingsEditor != null) {
            group.addEditor(AppServersIntegrationBundle.message((String)"title.run.configuration.editor.deployment", (Object[])new Object[0]), newDeploymentSettingsEditor);
        }
        group.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), (SettingsEditor)logConfigurationPanel);
        JavaRunConfigurationExtensionManager.getInstance().appendEditors((RunConfigurationBase)this, group);
        SettingsEditorGroup settingsEditorGroup = group;
        if (settingsEditorGroup == null) {
            CommonStrategy.$$$reportNull$$$0(0);
        }
        return settingsEditorGroup;
    }

    public String suggestedName() {
        if (this.myApplicationServer != null) {
            return this.myApplicationServer.getName();
        }
        return this.myApplicationServerName;
    }

    @Nullable
    public UpdatingPolicy selectUpdatingPolicy(@NotNull Executor executor) {
        if (executor == null) {
            CommonStrategy.$$$reportNull$$$0(1);
        }
        UpdatingPolicy policy = this.getUpdatingPolicy();
        Collection<? extends UpdatingPolicy> policies = UpdatingRunningApplicationUtil.getAvailablePolicies(executor, this, false);
        if (policies.isEmpty()) {
            return null;
        }
        if (this.mySettingsBean.SHOW_DIALOG_ON_UPDATE || policy == null || !policies.contains(policy)) {
            SelectUpdatingPolicyDialog dialog = new SelectUpdatingPolicyDialog(this.getProject(), this.getName(), null, true, policies, policy);
            dialog.show();
            if (dialog.getExitCode() != 0) {
                return null;
            }
            policy = dialog.getSelectedPolicy();
            this.mySettingsBean.UPDATING_POLICY = policy.getId();
            this.mySettingsBean.SHOW_DIALOG_ON_UPDATE = dialog.isShowDialogAgain();
        }
        return policy;
    }

    @Nullable
    public UpdatingPolicy getUpdateOnFrameDeactivationPolicy() {
        return CommonStrategy.getUpdateOnFrameDeactivationPolicy(this.mySettingsBean);
    }

    @Nullable
    public UpdatingPolicy getUpdatingPolicy() {
        return UpdatingRunningApplicationUtil.findPolicy(this.mySettingsBean.UPDATING_POLICY);
    }

    @Nullable
    private SettingsEditor<CommonStrategy> createArtifactDeploymentSettingsEditor(@NotNull JavaeeRunConfigurationEditorContext editorContext) {
        DeploymentProvider deploymentProvider;
        if (editorContext == null) {
            CommonStrategy.$$$reportNull$$$0(2);
        }
        if ((deploymentProvider = this.getDeploymentProvider()) == null) {
            return null;
        }
        return new DeploymentSettingsPanel(this, deploymentProvider, editorContext);
    }

    public List<Artifact> getDeployedArtifacts() {
        if (this.myDeploymentSettings != null) {
            return this.myDeploymentSettings.getDeployedArtifacts();
        }
        if (this.myServerModel instanceof DeploysArtifactsOnStartupOnly) {
            return ((DeploysArtifactsOnStartupOnly)this.myServerModel).getArtifactsToDeploy();
        }
        return Collections.emptyList();
    }

    public List<Artifact> getArtifactsToBuild() {
        if (this.myDeploymentSettings != null) {
            return this.myDeploymentSettings.getArtifactsToBuild();
        }
        if (this.myServerModel instanceof DeploysArtifactsOnStartupOnly) {
            return ((DeploysArtifactsOnStartupOnly)this.myServerModel).getArtifactsToDeploy();
        }
        return Collections.emptyList();
    }

    @Nullable
    public DeploymentModel getDeploymentModel(Artifact artifact) {
        return this.myDeploymentSettings != null ? this.myDeploymentSettings.getModel(artifact) : null;
    }

    public final AppServerIntegration getIntegration() {
        return this.myIntegration;
    }

    public JavaeeRunConfigurationCommonSettingsBean getSettingsBean() {
        return this.mySettingsBean;
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) {
        if (executor == null) {
            CommonStrategy.$$$reportNull$$$0(3);
        }
        if (env == null) {
            CommonStrategy.$$$reportNull$$$0(4);
        }
        if (env.getConfigurationSettings() instanceof GenericDebuggerRunnerSettings) {
            GenericDebuggerRunnerSettings debuggerSettings = (GenericDebuggerRunnerSettings)env.getConfigurationSettings();
            debuggerSettings.LOCAL = this.isLocal();
        }
        return this.isLocal() ? this.getLocalState(executor, env) : this.getRemoteState();
    }

    @NotNull
    private RunProfileState getRemoteState() {
        return new J2EERemoteState(this);
    }

    @NotNull
    private RunProfileState getLocalState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) {
        if (executor == null) {
            CommonStrategy.$$$reportNull$$$0(5);
        }
        if (env == null) {
            CommonStrategy.$$$reportNull$$$0(6);
        }
        ExecutionHelper executionHelper = new ExecutionHelper(this);
        if (this.myJavaCommandLineStartupPolicy != null) {
            return new JavaCommandLineLocalState(this.myJavaCommandLineStartupPolicy, this, executor, env, executionHelper);
        }
        return new PatchedLocalState((RunnerSpecificLocalConfigurationBit)env.getConfigurationSettings(), this, env.getRunnerSettings(), env.getExecutor(), executionHelper);
    }

    public boolean isLocal() {
        return this.mySettingsBean.LOCAL;
    }

    public void checkRunnerSettings(@NotNull ProgramRunner runner, @Nullable RunnerSettings runnerSettings, @Nullable ConfigurationPerRunnerSettings configurationPerRunnerSettings) throws RuntimeConfigurationException {
        if (runner == null) {
            CommonStrategy.$$$reportNull$$$0(7);
        }
        if (configurationPerRunnerSettings != null && configurationPerRunnerSettings instanceof RunnerSpecificLocalConfigurationBit) {
            ((RunnerSpecificLocalConfigurationBit)configurationPerRunnerSettings).checkConfiguration(runnerSettings);
        }
    }

    public final void checkConfiguration() throws RuntimeConfigurationException {
        ApplicationServer applicationServer = this.getApplicationServer();
        if (this.isApplicationServerNeeded() && (applicationServer == null || applicationServer.isDisposed())) {
            String serverName = this.getApplicationServerName();
            if (StringUtil.isEmpty((String)serverName)) {
                throw new RuntimeConfigurationError(AppServersIntegrationBundle.message((String)"exception.text.application.server.not.specified", (Object[])new Object[0]));
            }
            throw new RuntimeConfigurationError(AppServersIntegrationBundle.message((String)"exception.text.application.server.0.not.configured", (Object[])new Object[]{serverName}));
        }
        if (this.isAlternativeJreEnabled()) {
            String jrePath = this.getAlternativeJrePath();
            if (StringUtil.isEmpty((String)jrePath)) {
                throw new RuntimeConfigurationError(AppServersIntegrationBundle.message((String)"exception.text.alternative.jre.not.specified", (Object[])new Object[0]));
            }
            if (ProjectJdkTable.getInstance().findJdk(jrePath) != null) {
                return;
            }
            if (!JdkUtil.checkForJre((String)jrePath)) {
                throw new RuntimeConfigurationError(ExecutionBundle.message((String)"jre.path.is.not.valid.jre.home.error.message", (Object[])new Object[]{jrePath}));
            }
        }
        if (this.isLocal() && this.mySettingsBean.WORKING_DIRECTORY != null) {
            CheckUtil.checkExists((String)AppServersIntegrationBundle.message((String)"directory.description.working.directory", (Object[])new Object[0]), (String)this.mySettingsBean.WORKING_DIRECTORY.replace('/', File.separatorChar), (boolean)true);
        }
        this.myServerModel.checkConfiguration();
        String urlString = this.getUrlToOpenInBrowser();
        if (this.mySettingsBean.OPEN_IN_BROWSER) {
            try {
                URL url = new URL(urlString);
                if (url.getPort() > 65535 || url.getHost() == null) {
                    throw new MalformedURLException();
                }
            }
            catch (MalformedURLException e) {
                throw new RuntimeConfigurationWarning(AppServersIntegrationBundle.message((String)"exception.text.malformed.url", (Object[])new Object[]{urlString}));
            }
        }
        if (!this.getProject().isDefault()) {
            this.checkDeploymentModels();
            this.checkAllDescriptorsDefined();
        }
    }

    public boolean isApplicationServerNeeded() {
        return this.myServerModel.isApplicationServerNeeded();
    }

    private void checkAllDescriptorsDefined() throws RuntimeConfigurationWarning {
        List<Artifact> artifacts = this.getDeployedArtifacts();
        LinkedHashSet facets = new LinkedHashSet();
        for (Artifact artifact : artifacts) {
            facets.addAll(JavaeeArtifactUtil.getInstance().getFacetsIncludedInArtifact(this.getProject(), artifact, null));
        }
        for (JavaeeFacet facet : facets) {
            ConfigFile[] defined = facet.getDescriptorsContainer().getConfigFiles();
            HashSet<ConfigFileMetaData> definedMetadatas = new HashSet<ConfigFileMetaData>();
            for (ConfigFile descriptor : defined) {
                definedMetadatas.add(descriptor.getMetaData());
            }
            Collection descriptions = ((JavaeeFacetType)facet.getType()).getDescriptorsMetaDataProvider().getMetaData(this.myIntegration);
            for (ConfigFileMetaData data : descriptions) {
                if (data.isOptional() || definedMetadatas.contains(data)) continue;
                RuntimeConfigurationWarning warning = new RuntimeConfigurationWarning(AppServersIntegrationBundle.message((String)"exception.text.descriptor.not.defined", (Object[])new Object[]{data.getTitle()}));
                warning.setQuickFix(() -> JavaeeFacetUtil.getInstance().showFacetDescriptorsSettingsEditor(facet));
                throw warning;
            }
        }
    }

    private void checkDeploymentModels() throws RuntimeConfigurationException {
        DeploymentProvider deploymentProvider = this.getDeploymentProvider();
        if (deploymentProvider == null) {
            return;
        }
        List<DeploymentModel> models = this.myDeploymentSettings.getDeploymentModels();
        if (models.isEmpty() && this.isLocal()) {
            MarkArtifactForDeploymentQuickFix quickFix = new MarkArtifactForDeploymentQuickFix(this.getProject(), deploymentProvider);
            throw new RuntimeConfigurationWarning(quickFix.getWarningMessage(), (ConfigurationQuickFix)quickFix);
        }
    }

    public final void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            CommonStrategy.$$$reportNull$$$0(8);
        }
        this.read(element, arg_0 -> ((ServerModel)this.myServerModel).readExternal(arg_0));
    }

    public void setTemplate(boolean isTemplate) {
        this.myServerModel.setTemplate(isTemplate);
    }

    public final void readPersistent(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            CommonStrategy.$$$reportNull$$$0(9);
        }
        this.read(element, serverSettingsElement -> this.myServerModel.readPersistent(serverSettingsElement));
    }

    private void read(@NotNull Element element, @NotNull Consumer<Element> serverSettingsReader) throws InvalidDataException {
        if (element == null) {
            CommonStrategy.$$$reportNull$$$0(10);
        }
        if (serverSettingsReader == null) {
            CommonStrategy.$$$reportNull$$$0(11);
        }
        JDomConvertingUtil.removeDuplicatedOptions((Element)element);
        Element serverSettingsElement = element.getChild(SERVER_SETTINGS_ELEMENT);
        if (serverSettingsElement == null) {
            serverSettingsElement = element;
        }
        serverSettingsReader.accept(serverSettingsElement);
        this.myApplicationServerName = element.getAttributeValue(APPLICATION_SERVER_NAME);
        this.myApplicationServer = ApplicationServersManager.getInstance().findByName(this.myApplicationServerName);
        this.myAlternativeJreEnabled = Boolean.parseBoolean(element.getAttributeValue(ALTERNATIVE_JRE_ENABLED));
        this.myAlternativeJrePath = element.getAttributeValue(ALTERNATIVE_JRE_PATH);
        this.expandServerModelMacros(element);
        XmlSerializer.deserializeInto((Object)this.mySettingsBean, (Element)element);
        if (this.myDeploymentSettings != null) {
            this.myDeploymentSettings.readFrom(element);
        }
        super.readExternal(element);
        if (this.getPredefinedLogFiles().isEmpty() && this.getLogFiles().isEmpty()) {
            this.addPredefinedLogFiles();
        }
        JavaRunConfigurationExtensionManager.getInstance().readExternal((RunConfigurationBase)this, element);
    }

    public void expandServerModelMacros(Element element) {
        List macros = this.myServerModel.getExternalizationMacros();
        if (!macros.isEmpty()) {
            ExpandMacroToPathMap map = new ExpandMacroToPathMap();
            for (Pair macro : macros) {
                map.put(CommonStrategy.getMacroName((String)macro.getFirst()), (String)macro.getSecond());
            }
            map.substitute(element, true, true);
        }
    }

    private static String getMacroName(String name) {
        return "%IDEA_RUN:" + name + "%";
    }

    public final void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            CommonStrategy.$$$reportNull$$$0(12);
        }
        this.write(element, arg_0 -> ((ServerModel)this.myServerModel).writeExternal(arg_0));
    }

    public final void writePersistent(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            CommonStrategy.$$$reportNull$$$0(13);
        }
        this.write(element, arg_0 -> ((ServerModel)this.myServerModel).writePersistent(arg_0));
    }

    private void write(@NotNull Element element, @NotNull Consumer<Element> serverSettingsWriter) throws WriteExternalException {
        if (element == null) {
            CommonStrategy.$$$reportNull$$$0(14);
        }
        if (serverSettingsWriter == null) {
            CommonStrategy.$$$reportNull$$$0(15);
        }
        XmlSerializer.serializeInto((Object)this.mySettingsBean, (Element)element, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
        if (this.myDeploymentSettings != null) {
            this.myDeploymentSettings.writeTo(element);
        }
        if (this.myApplicationServer != null) {
            element.setAttribute(APPLICATION_SERVER_NAME, this.myApplicationServer.getName());
        } else if (this.myApplicationServerName != null) {
            element.setAttribute(APPLICATION_SERVER_NAME, this.myApplicationServerName);
        }
        element.setAttribute(ALTERNATIVE_JRE_ENABLED, Boolean.toString(this.myAlternativeJreEnabled));
        if (this.myAlternativeJrePath != null) {
            element.setAttribute(ALTERNATIVE_JRE_PATH, this.myAlternativeJrePath);
        }
        Element serverSettingsElement = new Element(SERVER_SETTINGS_ELEMENT);
        serverSettingsWriter.accept(serverSettingsElement);
        element.addContent(serverSettingsElement);
        super.writeExternal(element);
        this.collapseServerModelMacros(element);
        JavaRunConfigurationExtensionManager.getInstance().writeExternal((RunConfigurationBase)this, element);
    }

    public void collapseServerModelMacros(Element element) {
        List macros = this.myServerModel.getExternalizationMacros();
        if (!macros.isEmpty()) {
            ReplacePathToMacroMap macroMap = new ReplacePathToMacroMap();
            for (Pair macro : macros) {
                macroMap.put((String)macro.getSecond(), CommonStrategy.getMacroName((String)macro.getFirst()));
            }
            macroMap.substitute(element, SystemInfo.isFileSystemCaseSensitive, true);
        }
    }

    public final Module @NotNull [] getModules() {
        List<Artifact> artifacts = this.getDeployedArtifacts();
        if (artifacts.isEmpty()) {
            if (Module.EMPTY_ARRAY == null) {
                CommonStrategy.$$$reportNull$$$0(16);
            }
            return Module.EMPTY_ARRAY;
        }
        Set modules = ArtifactUtil.getModulesIncludedInArtifacts(artifacts, (Project)this.getProject());
        Module[] moduleArray = modules.toArray(Module.EMPTY_ARRAY);
        if (moduleArray == null) {
            CommonStrategy.$$$reportNull$$$0(17);
        }
        return moduleArray;
    }

    public CommonStrategy clone() {
        Element element = new Element("tag");
        try {
            this.writeExternal(element);
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
        }
        CommonStrategy result = (CommonStrategy)super.clone();
        RunConfigurationExtension.cleanExtensionsUserData((RunConfigurationBase)result);
        try {
            result.myServerModel = (ServerModel)this.myServerModel.clone();
        }
        catch (Throwable e) {
            LOG.error(e);
            throw new InternalError();
        }
        result.myServerModel.setCommonModel((CommonModel)result);
        result.mySettingsBean = new JavaeeRunConfigurationCommonSettingsBean();
        result.myDeploymentSettings = CommonStrategy.createDeploymentSettings(this.getProject(), result);
        try {
            result.readExternal(element);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
        return result;
    }

    public final void setLocal(boolean b) {
        this.mySettingsBean.LOCAL = b;
    }

    public final ApplicationServer getApplicationServer() {
        return this.myApplicationServer;
    }

    @NlsSafe
    public String getApplicationServerName() {
        return this.myApplicationServer != null ? this.myApplicationServer.getName() : this.myApplicationServerName;
    }

    public String getHost() {
        return this.isLocal() ? "localhost" : this.getRemoteHost();
    }

    public int getPort() {
        return this.isLocal() ? this.getServerModel().getLocalPort() : this.getRemotePort();
    }

    public final void setApplicationServer(ApplicationServer applicationServer) {
        this.myApplicationServer = applicationServer;
        this.myApplicationServerName = applicationServer != null ? applicationServer.getName() : null;
    }

    public void setApplicationServerName(@Nls String applicationServerName) {
        this.myApplicationServerName = applicationServerName;
        this.myApplicationServer = ApplicationServersManager.getInstance().findByName(applicationServerName, this.myIntegration);
    }

    public String getWorkingDirectory() {
        return this.mySettingsBean.WORKING_DIRECTORY;
    }

    public Collection<? extends DeploymentModel> getDeploymentModels() {
        if (this.myDeploymentSettings != null) {
            return this.myDeploymentSettings.getDeploymentModels();
        }
        return Collections.emptyList();
    }

    @Nullable
    public DeploymentSettings getDeploymentSettings() {
        return this.myDeploymentSettings;
    }

    public final String getRemoteHost() {
        if (this.isLocal()) {
            return "localhost";
        }
        return this.mySettingsBean.HOST;
    }

    public final String getUrlToOpenInBrowser() {
        String url = this.mySettingsBean.OPEN_IN_BROWSER_URL;
        return url == null ? this.getDefaultUrlForBrowser() : url;
    }

    @NotNull
    public ProjectTask getCompileTask() {
        Set modules = ArtifactUtil.getModulesIncludedInArtifacts(this.getDeployedArtifacts(), (Project)this.getProject());
        ProjectTaskManager taskManager = ProjectTaskManager.getInstance((Project)this.getProject());
        ProjectTask modulesBuildTask = taskManager.createModulesBuildTask(modules.toArray(Module.EMPTY_ARRAY), true, true, false);
        ProjectTask buildArtifactsTask = taskManager.createBuildTask(true, (ProjectModelBuildableElement[])this.getArtifactsToBuild().toArray(new Artifact[0]));
        ProjectTaskList baseTask = ProjectTaskList.asList((ProjectTask[])new ProjectTask[]{modulesBuildTask, buildArtifactsTask});
        ProjectTask projectTask = this.myServerModel.getCompileTask(this.getProject(), (ProjectTask)baseTask);
        if (projectTask == null) {
            CommonStrategy.$$$reportNull$$$0(18);
        }
        return projectTask;
    }

    public DeploymentProvider getDeploymentProvider() {
        return DeploymentManagerEx.getProvider(this);
    }

    @Nullable
    public ScriptHelper createStartupHelper(ConfigurationInfoProvider provider) {
        if (this.myExecutableObjectStartupPolicy != null) {
            try {
                return this.myExecutableObjectStartupPolicy.createStartupScriptHelper(provider.getRunner());
            }
            catch (AbstractMethodError e) {
                return new ScriptHelperWrapper(this.myExecutableObjectStartupPolicy.getStartupHelper());
            }
        }
        return null;
    }

    @Nullable
    public ScriptHelper createShutdownHelper(ConfigurationInfoProvider provider) {
        if (this.myExecutableObjectStartupPolicy != null) {
            try {
                return this.myExecutableObjectStartupPolicy.createShutdownScriptHelper(provider.getRunner());
            }
            catch (AbstractMethodError e) {
                return new ScriptHelperWrapper(this.myExecutableObjectStartupPolicy.getShutdownHelper());
            }
        }
        return null;
    }

    @Nullable
    public EnvironmentHelper getHelper() {
        if (this.myExecutableObjectStartupPolicy != null) {
            return this.myExecutableObjectStartupPolicy.getEnvironmentHelper();
        }
        return null;
    }

    public String getDefaultUrlForBrowser() {
        return this.myServerModel.getDefaultUrlForBrowser();
    }

    public SettingsEditor<CommonStrategy> getServerSpecificEditor() {
        return this.myServerModel.getEditor();
    }

    public J2EEServerInstance createServerInstance() throws ExecutionException {
        return this.myServerModel.createServerInstance();
    }

    public List<Pair<String, Integer>> getAddressesToCheck() {
        return this.myServerModel.getAddressesToCheck();
    }

    public OutputProcessor createOutputProcessor(ProcessHandler handler, J2EEServerInstance serverInstance) {
        return this.myServerModel.createOutputProcessor(handler, serverInstance);
    }

    public ServerModel getServerModel() {
        return this.myServerModel;
    }

    public int getRemotePort() {
        return this.mySettingsBean.PORT;
    }

    @Nullable
    public LogFileOptions getOptionsForPredefinedLogFile(PredefinedLogFile predefinedLogFile) {
        if (this.myServerModel instanceof PredefinedLogFilesProvider) {
            return ((PredefinedLogFilesProvider)this.myServerModel).getOptionsForPredefinedLogFile(predefinedLogFile);
        }
        return null;
    }

    public ConfigurationPerRunnerSettings createRunnerSettings(ConfigurationInfoProvider provider) {
        if (this.isLocal()) {
            return new RunnerSpecificLocalConfigurationBit(provider);
        }
        return new RunnerSpecificRemoteConfigurationBit(provider);
    }

    public void customizeLogConsole(LogConsole console) {
        if (this.myServerModel instanceof LogCustomizer) {
            ((LogCustomizer)this.myServerModel).customizeLogConsole(console);
        }
    }

    @Nullable
    public SettingsEditor<ConfigurationPerRunnerSettings> getRunnerSettingsEditor(ProgramRunner runner) {
        if (this.myJavaCommandLineStartupPolicy == null) {
            if (this.isLocal()) {
                return new RunnerSpecificLocalPanel();
            }
            if (runner instanceof JvmPatchableProgramRunner) {
                return new RunnerSpecificRemotePanel((JvmPatchableProgramRunner)runner);
            }
        }
        return null;
    }

    public void initialize() {
        this.removeAllLogFiles();
    }

    public boolean isSettingsNeeded() {
        return !this.isJavaPolicy();
    }

    public boolean isJavaPolicy() {
        return this.myJavaCommandLineStartupPolicy != null;
    }

    public void setUrlToOpenInBrowser(@Nullable String newUrl) {
        this.mySettingsBean.OPEN_IN_BROWSER_URL = this.getDefaultUrlForBrowser().equals(newUrl) ? null : newUrl;
    }

    public void createAdditionalTabComponents(AdditionalTabComponentManager manager, ProcessHandler startedProcess) {
        if (this.myServerModel instanceof AdditionalTabsProvider) {
            ((AdditionalTabsProvider)this.myServerModel).createAdditionalTabs(manager, startedProcess);
        }
    }

    public boolean isAlternativeJreEnabled() {
        return this.myAlternativeJreEnabled;
    }

    public void setAlternativeJreEnabled(boolean alternativeJreEnabled) {
        this.myAlternativeJreEnabled = alternativeJreEnabled;
    }

    @Nullable
    public String getAlternativeJrePath() {
        return this.myAlternativeJrePath;
    }

    public void setAlternativeJrePath(@Nullable String alternativeJrePath) {
        this.myAlternativeJrePath = alternativeJrePath;
    }

    @Nullable
    public Sdk getJre() {
        Project project;
        if (this.isAlternativeJreEnabled()) {
            try {
                Sdk alternativeJre = this.getAlternativeJre();
                if (alternativeJre != null) {
                    return alternativeJre;
                }
            }
            catch (CantRunException alternativeJre) {
                // empty catch block
            }
        }
        if ((project = this.getProject()).isDisposed()) {
            return null;
        }
        Sdk projectJdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        if (projectJdk != null && projectJdk.getSdkType() instanceof JavaSdkType) {
            return projectJdk;
        }
        LOG.debug("Neither alternative nor project JRE are configured");
        return null;
    }

    @Nullable
    private Sdk getAlternativeJre() throws CantRunException {
        String jrePath = this.getAlternativeJrePath();
        Project project = this.getProject();
        if (jrePath != null && !project.isDisposed()) {
            return JavaParametersUtil.createProjectJdk((Project)project, (String)jrePath);
        }
        return null;
    }

    @Nullable
    public static UpdatingPolicy getUpdateOnFrameDeactivationPolicy(JavaeeRunConfigurationCommonSettingsBean settingsBean) {
        if (settingsBean.UPDATE_ON_FRAME_DEACTIVATION) {
            if (settingsBean.UPDATE_CLASSES_ON_FRAME_DEACTIVATION) {
                return ReloadClassesAndResourcesUpdatingPolicy.getInstance();
            }
            if (settingsBean.HOT_SWAP_CLASSES_ON_FRAME_DEACTIVATION) {
                return HotSwapClassesUpdatingPolicy.getInstance();
            }
            return ReloadResourcesUpdatingPolicy.getInstance();
        }
        return null;
    }

    public void onNewConfigurationCreated() {
        super.onNewConfigurationCreated();
        if (this.getApplicationServer() == null) {
            List servers = ApplicationServersManager.getInstance().getApplicationServers(new AppServerIntegration[]{this.getIntegration()});
            this.setApplicationServer((ApplicationServer)ContainerUtil.getFirstItem((Collection)servers, null));
        }
        this.myServerModel.onNewConfigurationCreated();
    }

    public void onConfigurationCopied() {
        this.myServerModel.onConfigurationCopied();
    }

    public RunConfiguration.RestartSingletonResult restartSingleton(@NotNull ExecutionEnvironment environment) {
        if (environment == null) {
            CommonStrategy.$$$reportNull$$$0(19);
        }
        if (!this.isLocal()) {
            return RunConfiguration.RestartSingletonResult.ASK_AND_RESTART;
        }
        return ExecutionHelper.restart(this, environment.getExecutor());
    }

    public boolean needsToBeMigrated() {
        return this.myServerModel.needsToBeMigrated();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/appServers/run/configuration/CommonStrategy";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorContext";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverSettingsReader";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverSettingsWriter";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/appServers/run/configuration/CommonStrategy";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompileTask";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "selectUpdatingPolicy";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createArtifactDeploymentSettingsEditor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLocalState";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkRunnerSettings";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "readPersistent";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "writePersistent";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "restartSingleton";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ScriptHelperWrapper
    extends ScriptHelper {
        private final ScriptsHelper myDelegate;

        ScriptHelperWrapper(ScriptsHelper delegate) {
            this.myDelegate = delegate;
        }

        public ExecutableObject getDefaultScript(CommonModel commonModel) {
            return this.myDelegate.getDefaultScript(commonModel);
        }
    }
}

