/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.appServers.deployment;

import com.intellij.javaee.appServers.deployment.ExternalFileDeploymentProviderImpl;
import com.intellij.javaee.appServers.deployment.ExternalFileDeploymentSource;
import com.intellij.javaee.appServers.deployment.JavaeeArtifactDeploymentSourceImpl;
import com.intellij.javaee.appServers.deployment.ModuleDeploymentSourceImpl;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.deployment.ArtifactDeploymentSource;
import com.intellij.javaee.deployment.DeploymentSource;
import com.intellij.javaee.deployment.ExternalFileDeploymentProvider;
import com.intellij.javaee.deployment.JavaeeDeploymentUtil;
import com.intellij.javaee.deployment.ModuleDeploymentSource;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.artifacts.ArtifactType;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class JavaeeDeploymentUtilImpl
extends JavaeeDeploymentUtil {
    @NotNull
    public ArtifactDeploymentSource createArtifactDeploymentSource(@NotNull ArtifactPointer artifactPointer) {
        if (artifactPointer == null) {
            JavaeeDeploymentUtilImpl.$$$reportNull$$$0(0);
        }
        return new JavaeeArtifactDeploymentSourceImpl(artifactPointer);
    }

    @NotNull
    public DeploymentSource createExternalFileDeploymentSource(@NotNull File file) {
        if (file == null) {
            JavaeeDeploymentUtilImpl.$$$reportNull$$$0(1);
        }
        return new ExternalFileDeploymentSource(file);
    }

    @NotNull
    public ModuleDeploymentSource createModuleDeploymentSource(@NotNull ModulePointer modulePointer) {
        if (modulePointer == null) {
            JavaeeDeploymentUtilImpl.$$$reportNull$$$0(2);
        }
        return new ModuleDeploymentSourceImpl(modulePointer);
    }

    @NotNull
    public ExternalFileDeploymentProvider createExternalFileDeploymentProvider(@NotNull Collection<? extends ArtifactType> artifactTypes) {
        if (artifactTypes == null) {
            JavaeeDeploymentUtilImpl.$$$reportNull$$$0(3);
        }
        boolean directoriesAllowed = false;
        HashSet<String> allowedExtensions = new HashSet<String>();
        JavaeeArtifactUtil artifactUtil = JavaeeArtifactUtil.getInstance();
        for (ArtifactType artifactType : artifactTypes) {
            if (!artifactUtil.isArchive(artifactType)) {
                directoriesAllowed = true;
                continue;
            }
            if (artifactUtil.isEjbApplication(artifactType)) {
                allowedExtensions.add("jar");
                continue;
            }
            if (artifactUtil.isJavaeeApplication(artifactType)) {
                allowedExtensions.add("ear");
                continue;
            }
            if (!artifactUtil.isWebApplication(artifactType)) continue;
            allowedExtensions.add("war");
        }
        return new ExternalFileDeploymentProviderImpl(directoriesAllowed, allowedExtensions);
    }

    @NotNull
    public ExternalFileDeploymentProvider createExternalFileDeploymentProvider(boolean directoriesAllowed, String ... allowedExtensions) {
        return new ExternalFileDeploymentProviderImpl(directoriesAllowed, Arrays.asList(allowedExtensions));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactPointer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulePointer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactTypes";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javaee/appServers/deployment/JavaeeDeploymentUtilImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createArtifactDeploymentSource";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createExternalFileDeploymentSource";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createModuleDeploymentSource";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createExternalFileDeploymentProvider";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

