/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.appServers.deployment;

import com.intellij.javaee.deployment.ExternalFileDeploymentProvider;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.containers.CollectionFactory;
import java.io.File;
import java.io.FileFilter;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ExternalFileDeploymentProviderImpl
extends ExternalFileDeploymentProvider {
    private final FileFilter myFileFilter;
    private final boolean myDirectoriesAllowed;

    public ExternalFileDeploymentProviderImpl(boolean directoriesAllowed, Collection<String> allowedExtensions) {
        this.myDirectoriesAllowed = directoriesAllowed;
        this.myFileFilter = new DeployableFileFilter(allowedExtensions);
    }

    public boolean isDirectoriesAllowed() {
        return this.myDirectoriesAllowed;
    }

    @NotNull
    public FileFilter getDeployableFileFilter() {
        FileFilter fileFilter = this.myFileFilter;
        if (fileFilter == null) {
            ExternalFileDeploymentProviderImpl.$$$reportNull$$$0(0);
        }
        return fileFilter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/appServers/deployment/ExternalFileDeploymentProviderImpl", "getDeployableFileFilter"));
    }

    private static class DeployableFileFilter
    implements FileFilter {
        private final Set<String> myAllowedExtensions;

        DeployableFileFilter(Collection<String> allowedExtensions) {
            this.myAllowedExtensions = CollectionFactory.createFilePathSet(allowedExtensions);
        }

        @Override
        public boolean accept(File file) {
            return this.myAllowedExtensions.contains(FileUtilRt.getExtension((String)file.getName()));
        }
    }
}

