/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util.http;

import com.yourkit.util.IoUtil;
import com.yourkit.util.Strings;
import com.yourkit.util.http.HttpUri;
import com.yourkit.util.http.MediaType;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpClient {
    @NotNull
    private HttpUri uri;
    @NotNull
    private final HashMap<String, String> myRequestHeaders;
    private boolean followRedirects;
    @Nullable
    private Method method;
    private int statusCode;
    private int contentLength;
    @NotNull
    private String contentType;
    @NotNull
    private Map<String, List<String>> myResponseHeaders;
    @NotNull
    private String content;
    @Nullable
    private InvocationHandler handler;

    public HttpClient(@NotNull HttpUri uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myRequestHeaders = new HashMap();
        this.followRedirects = true;
        this.statusCode = -1;
        this.contentLength = -1;
        this.contentType = "";
        this.myResponseHeaders = Collections.emptyMap();
        this.content = "";
        this.uri = uri;
        this.reset();
        this.handler = new InvocationHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void invoke(@NotNull HttpURLConnection conn) throws IOException {
                if (conn == null) {
                    throw new IllegalArgumentException("Parameter 1 must not be null");
                }
                String contentType = HttpClient.this.getContentType();
                if (contentType.contains(MediaType.APPLICATION_JSON.type) || contentType.contains(MediaType.APPLICATION_XML.type) || contentType.contains(MediaType.TEXT_HTML.type) || contentType.contains(MediaType.TEXT_PLAIN.type)) {
                    InputStream in;
                    try {
                        in = conn.getInputStream();
                    }
                    catch (IOException e) {
                        in = conn.getErrorStream();
                    }
                    if (in == null) {
                        return;
                    }
                    String _charsetName = HttpClient.this.getContentCharset();
                    String charsetName = _charsetName != null ? _charsetName : Strings.UTF_8.name();
                    try {
                        StringBuilder _content = new StringBuilder(4096);
                        IoUtil.readContent(new InputStreamReader(in, Charset.forName(charsetName)), _content);
                        HttpClient.this.setContent(_content.toString());
                    }
                    finally {
                        in.close();
                    }
                }
            }
        };
    }

    private void reset() {
        this.setStatusCode(-1);
        this.setContentLength(-1);
        this.setContentType("");
        this.resetResponseHeaders();
        this.setContent("");
    }

    @NotNull
    public final HttpUri getUri() {
        HttpUri httpUri = this.uri;
        if (httpUri == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return httpUri;
    }

    public void setUri(@NotNull HttpUri uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.uri = uri;
    }

    @Nullable
    public final String getRequestHeader(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        return this.myRequestHeaders.get(name);
    }

    public final HttpClient setRequestHeader(@NotNull String name, @Nullable String value) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myRequestHeaders.put(name, value);
        return this;
    }

    @NotNull
    public Map<String, List<String>> getResponseHeaders() {
        Map<String, List<String>> map = this.myResponseHeaders;
        if (map == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return map;
    }

    private void resetResponseHeaders() {
        this.myResponseHeaders = Collections.emptyMap();
    }

    public final int getStatusCode() {
        return this.statusCode;
    }

    protected final void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public final int getContentLength() {
        return this.contentLength;
    }

    protected final void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    @NotNull
    public final String getContentType() {
        String string = this.contentType;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    protected final void setContentType(@NotNull String contentType) {
        if (contentType == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.contentType = contentType;
    }

    @Nullable
    public final String getContentCharset() {
        String contentType = this.getContentType();
        String charsetPrefix = "charset=";
        int idx = contentType.indexOf("charset=");
        return idx != -1 ? contentType.substring(idx + "charset=".length()) : null;
    }

    @NotNull
    public final String getContent() {
        String string = this.content;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    protected final void setContent(@NotNull String content) {
        if (content == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.content = content;
    }

    public final boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public final void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public final void setHandler(@NotNull InvocationHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.handler = handler;
    }

    private void setMethod(@Nullable Method method) {
        this.method = method;
    }

    public final HttpClient doGet() {
        this.setMethod(new Get(null));
        return this;
    }

    public final HttpClient doPost() {
        this.setMethod(new Post());
        return this;
    }

    public final HttpClient doJson(@NotNull String json) {
        if (json == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.setMethod(new PostJson(json));
        return this;
    }

    public final int invoke() throws IOException {
        if (this.method == null) {
            throw new IllegalStateException("Request method is not set");
        }
        this.method.invoke();
        return this.getStatusCode();
    }

    public static interface Body {
        @NotNull
        public MediaType getMediaType();

        @NotNull
        public byte[] getContent();
    }

    public static interface InvocationHandler {
        public void invoke(@NotNull HttpURLConnection var1) throws IOException;
    }

    private final class PostJson
    extends Method {
        @NotNull
        private final String json;

        public PostJson(String json) {
            if (json == null) {
                throw new IllegalArgumentException("Parameter 1 must not be null");
            }
            this.json = json;
        }

        @Override
        @NotNull
        protected String getMethod() {
            return "POST";
        }

        @Override
        @NotNull
        protected String getUrlEncodedQuery() {
            String string = HttpClient.this.uri.getUrlEncodedQuery();
            if (string == null) {
                throw new IllegalStateException("Method must not return null");
            }
            return string;
        }

        @Override
        @NotNull
        protected Body getBody() {
            return new Body(){

                @Override
                @NotNull
                public MediaType getMediaType() {
                    MediaType mediaType = MediaType.APPLICATION_JSON;
                    if (mediaType == null) {
                        throw new IllegalStateException("Method must not return null");
                    }
                    return mediaType;
                }

                @Override
                @NotNull
                public byte[] getContent() {
                    byte[] byArray = PostJson.this.json.getBytes(Strings.UTF_8);
                    if (byArray == null) {
                        throw new IllegalStateException("Method must not return null");
                    }
                    return byArray;
                }
            };
        }
    }

    private final class Post
    extends Method {
        private Post() {
        }

        @Override
        @NotNull
        protected String getMethod() {
            return "POST";
        }

        @Override
        @NotNull
        protected String getUrlEncodedQuery() {
            return "";
        }

        @Override
        @NotNull
        protected Body getBody() {
            return new Body(){

                @Override
                @NotNull
                public MediaType getMediaType() {
                    MediaType mediaType = MediaType.APPLICATION_X_WWW_FORM_URLENCODED;
                    if (mediaType == null) {
                        throw new IllegalStateException("Method must not return null");
                    }
                    return mediaType;
                }

                @Override
                @NotNull
                public byte[] getContent() {
                    String queryString = HttpClient.this.uri.getUrlEncodedQuery();
                    byte[] byArray = queryString.getBytes(Strings.ASCII);
                    if (byArray == null) {
                        throw new IllegalStateException("Method must not return null");
                    }
                    return byArray;
                }
            };
        }
    }

    private final class Get
    extends Method {
        private Get() {
        }

        @Override
        @NotNull
        protected String getMethod() {
            return "GET";
        }

        @Override
        @NotNull
        protected String getUrlEncodedQuery() {
            String string = HttpClient.this.uri.getUrlEncodedQuery();
            if (string == null) {
                throw new IllegalStateException("Method must not return null");
            }
            return string;
        }

        @Override
        @Nullable
        protected Body getBody() {
            return null;
        }

        public /* synthetic */ Get(1 x1) {
            this();
        }
    }

    private abstract class Method {
        private Method() {
        }

        @NotNull
        protected abstract String getMethod();

        @NotNull
        protected abstract String getUrlEncodedQuery();

        @Nullable
        protected abstract Body getBody();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void invoke() throws IOException {
            HttpClient.this.reset();
            StringBuilder urlAndQuery = new StringBuilder();
            urlAndQuery.append(HttpClient.this.uri.asStringWithoutQuery());
            String query = this.getUrlEncodedQuery();
            if (query.length() > 0) {
                urlAndQuery.append("?").append(query);
            }
            URL url = new URL(urlAndQuery.toString());
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setUseCaches(false);
            conn.setInstanceFollowRedirects(HttpClient.this.followRedirects);
            conn.setRequestMethod(this.getMethod());
            Body body = this.getBody();
            if (body != null) {
                conn.setDoOutput(true);
                conn.setRequestProperty("Content-Type", body.getMediaType().getContentTypeAndEncoding());
                byte[] content = body.getContent();
                conn.setRequestProperty("Content-Length", Integer.toString(content.length));
                for (Map.Entry e : HttpClient.this.myRequestHeaders.entrySet()) {
                    String value = (String)e.getValue();
                    if (Strings.isNullOrEmpty(value)) continue;
                    conn.setRequestProperty((String)e.getKey(), value);
                }
                try (OutputStream out = conn.getOutputStream();){
                    out.write(content);
                    out.flush();
                }
            }
            try {
                HttpClient.this.setStatusCode(conn.getResponseCode());
                HttpClient.this.setContentLength(conn.getContentLength());
                HttpClient.this.setContentType(Strings.notNull(conn.getContentType()));
                HttpClient.this.myResponseHeaders = conn.getHeaderFields();
                if (HttpClient.this.handler != null) {
                    HttpClient.this.handler.invoke(conn);
                }
            }
            finally {
                conn.disconnect();
            }
        }
    }
}

