/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.util;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.ide.common.util.DeviceUtils;
import com.android.ide.common.util.Receiver;
import com.android.sdklib.AndroidVersion;
import java.io.IOException;
import java.time.Duration;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0001\u001a\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0001\u001a\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\n*\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\fH\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0003\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\"\u0015\u0010\u0007\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0006\u00a8\u0006\r"}, d2={"MDNS_TLS_SUFFIX", "", "MDNS_UNENCRYPTED_SUFFIX", "isMdnsAutoConnectTls", "", "Lcom/android/ddmlib/IDevice;", "(Lcom/android/ddmlib/IDevice;)Z", "isMdnsAutoConnectUnencrypted", "serialNumber", "getLanguages", "", "timeOut", "Ljava/time/Duration;", "android.sdktools.sdk-common"})
@JvmName(name="DeviceUtils")
public final class DeviceUtils {
    private static final String MDNS_TLS_SUFFIX = "_adb-tls-connect._tcp.";
    private static final String MDNS_UNENCRYPTED_SUFFIX = "_adb._tcp.";

    @JvmOverloads
    @NotNull
    public static final Set<String> getLanguages(@NotNull IDevice $this$getLanguages, @NotNull Duration timeOut) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        Intrinsics.checkParameterIsNotNull((Object)$this$getLanguages, (String)"$this$getLanguages");
        Intrinsics.checkParameterIsNotNull((Object)timeOut, (String)"timeOut");
        AndroidVersion androidVersion = $this$getLanguages.getVersion();
        Intrinsics.checkExpressionValueIsNotNull((Object)androidVersion, (String)"this.version");
        if (androidVersion.getApiLevel() < 21) {
            return SetsKt.emptySet();
        }
        Receiver receiver = new Receiver();
        $this$getLanguages.executeShellCommand("am get-config", (IShellOutputReceiver)receiver, timeOut.toMillis(), TimeUnit.MILLISECONDS);
        return SequencesKt.toSet((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)receiver.getLines()), (Function1)getLanguages.1.INSTANCE), (Function1)getLanguages.2.INSTANCE), (Function1)getLanguages.3.INSTANCE));
    }

    public static /* synthetic */ Set getLanguages$default(IDevice iDevice, Duration duration, int n, Object object) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        if ((n & 1) != 0) {
            Duration duration2 = Duration.ZERO;
            Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"Duration.ZERO");
            duration = duration2;
        }
        return DeviceUtils.getLanguages(iDevice, duration);
    }

    @JvmOverloads
    @NotNull
    public static final Set<String> getLanguages(@NotNull IDevice $this$getLanguages) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        return DeviceUtils.getLanguages$default($this$getLanguages, null, 1, null);
    }

    public static final boolean isMdnsAutoConnectTls(@NotNull IDevice $this$isMdnsAutoConnectTls) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isMdnsAutoConnectTls, (String)"$this$isMdnsAutoConnectTls");
        String string = $this$isMdnsAutoConnectTls.getSerialNumber();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this.serialNumber");
        return DeviceUtils.isMdnsAutoConnectTls(string);
    }

    public static final boolean isMdnsAutoConnectUnencrypted(@NotNull IDevice $this$isMdnsAutoConnectUnencrypted) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isMdnsAutoConnectUnencrypted, (String)"$this$isMdnsAutoConnectUnencrypted");
        String string = $this$isMdnsAutoConnectUnencrypted.getSerialNumber();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this.serialNumber");
        return DeviceUtils.isMdnsAutoConnectUnencrypted(string);
    }

    public static final boolean isMdnsAutoConnectTls(@NotNull String serialNumber) {
        Intrinsics.checkParameterIsNotNull((Object)serialNumber, (String)"serialNumber");
        return StringsKt.endsWith$default((String)serialNumber, (String)MDNS_TLS_SUFFIX, (boolean)false, (int)2, null);
    }

    public static final boolean isMdnsAutoConnectUnencrypted(@NotNull String serialNumber) {
        Intrinsics.checkParameterIsNotNull((Object)serialNumber, (String)"serialNumber");
        return StringsKt.endsWith$default((String)serialNumber, (String)MDNS_UNENCRYPTED_SUFFIX, (boolean)false, (int)2, null);
    }
}

