/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.resources.AssetFile;
import com.android.ide.common.resources.AssetItem;
import com.android.ide.common.resources.MergeConsumer;
import com.android.ide.common.resources.MergeWriter;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.GZIPInputStream;
import javax.inject.Inject;

public class MergedAssetWriter
extends MergeWriter<AssetItem, AssetWorkParameters> {
    public MergedAssetWriter(File rootFolder, WorkerExecutorFacade facade) {
        super(rootFolder, facade);
    }

    @Override
    public void addItem(AssetItem item) throws MergeConsumer.ConsumerException {
        if (item.isTouched()) {
            this.getExecutor().submit(new AssetWorkAction(new AssetWorkParameters(item, this.getRootFolder())));
        }
    }

    @Override
    public void removeItem(AssetItem removedItem, AssetItem replacedBy) throws MergeConsumer.ConsumerException {
        if (replacedBy == null) {
            File removedFile = new File(this.getRootFolder(), removedItem.getName());
            removedFile.delete();
        }
    }

    @Override
    public boolean ignoreItemInMerge(AssetItem item) {
        return false;
    }

    public static class AssetWorkAction
    implements WorkerExecutorFacade.WorkAction {
        private final AssetItem item;
        private final File rootFolder;

        @Inject
        public AssetWorkAction(AssetWorkParameters parameters) {
            this.item = parameters.assetItem;
            this.rootFolder = parameters.rootFolder;
        }

        @Override
        public void run() {
            block8: {
                try {
                    AssetFile assetFile = (AssetFile)Preconditions.checkNotNull((Object)((AssetFile)this.item.getSourceFile()));
                    Path fromFile = assetFile.getFile().toPath();
                    Path toFile = new File(this.rootFolder, this.item.getKey().replace('/', File.separatorChar)).toPath();
                    Files.createDirectories(toFile.getParent(), new FileAttribute[0]);
                    if (this.item.shouldBeUnGzipped()) {
                        try (GZIPInputStream gzipInputStream = new GZIPInputStream(new BufferedInputStream(Files.newInputStream(fromFile, new OpenOption[0])));){
                            Files.copy(gzipInputStream, toFile, StandardCopyOption.REPLACE_EXISTING);
                            break block8;
                        }
                    }
                    Files.copy(fromFile, toFile, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static class AssetWorkParameters
    implements Serializable {
        public final AssetItem assetItem;
        public final File rootFolder;

        private AssetWorkParameters(AssetItem assetItem, File rootFolder) {
            this.assetItem = assetItem;
            this.rootFolder = rootFolder;
        }
    }
}

