/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.utils;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.performancePlugin.Timer;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AsyncProfilerCommandBuilder {
    private static final List<String> DEFAULT_PROFILING_OPTIONS = ContainerUtil.immutableList((Object[])new String[]{"event=cpu", "framebuf=10000000", "interval=10000000", "jfr"});
    private static final List<String> DUMP_OPTIONS = ContainerUtil.immutableList((Object[])new String[]{"summary", "traces", "flat", "jfr", "collapsed", "flamegraph", "tree"});
    @NotNull
    private final String mySnapshotsPath = System.getProperty("snapshots.path") != null ? System.getProperty("snapshots.path") : FileUtil.createTempDirectory((String)"async", (String)"snapshot", (boolean)false).getAbsolutePath();
    private List<String> myStartOptions;

    @NotNull
    public String getSnapshotsPath() {
        String string = this.mySnapshotsPath;
        if (string == null) {
            AsyncProfilerCommandBuilder.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String buildStartCommand(@NotNull List<String> options) {
        if (options == null) {
            AsyncProfilerCommandBuilder.$$$reportNull$$$0(1);
        }
        this.myStartOptions = options;
        options = ContainerUtil.append(options, (Object[])new String[]{"file=" + this.getDumpFileName("jfr")});
        return AsyncProfilerCommandBuilder.buildCommand("start", AsyncProfilerCommandBuilder.mergeParameters(options, DEFAULT_PROFILING_OPTIONS));
    }

    @NotNull
    private static String buildCommand(String initialCommand, @NotNull List<String> options) {
        if (options == null) {
            AsyncProfilerCommandBuilder.$$$reportNull$$$0(2);
        }
        StringBuilder builder = new StringBuilder(initialCommand);
        for (String option : options) {
            builder.append(",").append(option);
        }
        String string = builder.toString();
        if (string == null) {
            AsyncProfilerCommandBuilder.$$$reportNull$$$0(3);
        }
        return string;
    }

    public List<String> buildStopAndDumpCommands(@NotNull List<String> options) {
        if (options == null) {
            AsyncProfilerCommandBuilder.$$$reportNull$$$0(4);
        }
        if (options.isEmpty()) {
            return Collections.singletonList(AsyncProfilerCommandBuilder.buildCommand("stop", Arrays.asList("collapsed", "file=" + this.getDumpFileName("collapsed"))));
        }
        ArrayList<CallSite> dumpOptions = new ArrayList<CallSite>();
        ArrayList<String> profilingOptions = new ArrayList<String>();
        for (String option : options) {
            String string = option.split("=")[0].trim();
            if (DUMP_OPTIONS.contains(string)) {
                dumpOptions.add((CallSite)((Object)(option + ",file=" + this.getDumpFileName(string))));
                continue;
            }
            profilingOptions.add(option);
        }
        ArrayList<String> stopCommands = new ArrayList<String>();
        for (String string : dumpOptions) {
            stopCommands.add(AsyncProfilerCommandBuilder.buildCommand("stop", AsyncProfilerCommandBuilder.mergeParameters(profilingOptions, Arrays.asList(string.split(",")))));
        }
        return stopCommands;
    }

    private static Map<String, String> parseParametersList(@NotNull List<String> options) {
        if (options == null) {
            AsyncProfilerCommandBuilder.$$$reportNull$$$0(5);
        }
        return options.stream().map(option -> option.split("=")).collect(Collectors.toMap(element -> element[0].trim(), element -> ((String[])element).length > 1 ? element[1].trim() : ""));
    }

    @NotNull
    private String getDumpFileName(@NotNull String profilingType) {
        if (profilingType == null) {
            AsyncProfilerCommandBuilder.$$$reportNull$$$0(6);
        }
        String buildNumber = ApplicationInfo.getInstance().getBuild().asString();
        String userName = SystemProperties.getUserName();
        String interval = this.getProfilingInterval();
        String profilingInterval = interval != null ? AsyncProfilerCommandBuilder.parseUnits(interval) / 1000000L + "ms" : "";
        String activityName = Timer.instance.getActivityName();
        String time = new SimpleDateFormat("yyyyMMddHHmm").format(new Date(Timer.instance.getStopTime()));
        String fileExtension = profilingType.equals("jfr") ? "jfr" : (profilingType.equals("flamegraph") || profilingType.equals("tree") ? "html" : "txt");
        String string = String.format("%s%s%s-%s-%s-%s-%s-%s.%s", this.mySnapshotsPath, File.separator, buildNumber, userName, profilingInterval, activityName, profilingType, time, fileExtension);
        if (string == null) {
            AsyncProfilerCommandBuilder.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static List<String> mergeParameters(@NotNull List<String> options, @NotNull List<String> defaultOptions) {
        if (options == null) {
            AsyncProfilerCommandBuilder.$$$reportNull$$$0(8);
        }
        if (defaultOptions == null) {
            AsyncProfilerCommandBuilder.$$$reportNull$$$0(9);
        }
        Map<String, String> userOptions = AsyncProfilerCommandBuilder.parseParametersList(options);
        Map<String, String> defOptions = AsyncProfilerCommandBuilder.parseParametersList(defaultOptions);
        HashMap<String, String> mergedOptions = new HashMap<String, String>(defOptions);
        mergedOptions.putAll(userOptions);
        return ContainerUtil.map(mergedOptions.keySet(), key -> ((String)mergedOptions.get(key)).isEmpty() ? key : key + "=" + (String)mergedOptions.get(key));
    }

    @Nullable
    private String getProfilingInterval() {
        return this.myStartOptions.stream().filter(option -> option.contains("interval")).map(option -> option.split("=")[1]).findFirst().orElse(null);
    }

    private static long parseUnits(@NotNull String str) {
        if (str == null) {
            AsyncProfilerCommandBuilder.$$$reportNull$$$0(10);
        }
        ParsePosition position = new ParsePosition(0);
        long result = NumberFormat.getInstance().parse(str, position).longValue();
        if (position.getIndex() == 0) {
            return 1L;
        }
        if (position.getIndex() == str.length()) {
            return result;
        }
        switch (str.charAt(position.getIndex())) {
            case 'K': 
            case 'U': 
            case 'k': 
            case 'u': {
                return result * 1000L;
            }
            case 'M': 
            case 'm': {
                return result * 1000000L;
            }
            case 'G': 
            case 'S': 
            case 'g': 
            case 's': {
                return result * 1000000000L;
            }
        }
        return -1L;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/utils/AsyncProfilerCommandBuilder";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilingType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultOptions";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSnapshotsPath";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/utils/AsyncProfilerCommandBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildCommand";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDumpFileName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildStartCommand";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildCommand";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildStopAndDumpCommands";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseParametersList";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDumpFileName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "mergeParameters";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseUnits";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

