/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.tracing.ui;

import com.intellij.diagnostic.tracing.MethodTracer;
import com.intellij.util.ui.ColumnInfo;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public class DataById<Data> {
    private final ConcurrentMap<MethodTracer.TracerId, Data> dataBuffer = new ConcurrentHashMap<MethodTracer.TracerId, Data>();
    private final Function<Data, MethodTracer.TracerId> idFunction;

    public DataById(Function<Data, MethodTracer.TracerId> function) {
        this.idFunction = function;
    }

    public MethodTracer.TracerId getId(Data data) {
        return this.idFunction.apply(data);
    }

    public Data getData(MethodTracer.TracerId id) {
        return (Data)this.dataBuffer.get(id);
    }

    public void forEachId(Consumer<MethodTracer.TracerId> action) {
        this.dataBuffer.keySet().forEach(action);
    }

    public void clear() {
        this.dataBuffer.clear();
    }

    public void refresh(List<Data> newData) {
        newData.forEach(d -> this.dataBuffer.put(this.getId(d), d));
    }

    public <T extends Comparable<T>> ColumnInfo<MethodTracer.TracerId, T> column(@Nls String name, final Function<Data, T> valueFunction) {
        return new ColumnInfo<MethodTracer.TracerId, T>(name){

            @Nullable
            public T valueOf(MethodTracer.TracerId id) {
                return (Comparable)valueFunction.apply(DataById.this.getData(id));
            }

            @Nullable
            public Comparator<MethodTracer.TracerId> getComparator() {
                return Comparator.comparing(id -> this.valueOf((MethodTracer.TracerId)id), Comparator.naturalOrder());
            }
        };
    }
}

