/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.tracing;

import com.intellij.codeInsight.hints.filtering.StringMatcher;
import com.intellij.codeInsight.hints.filtering.StringMatcherBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.performancePlugin.tracing.MethodTracing;
import com.jetbrains.performancePlugin.tracing.agent.Config;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MethodPatternsConfig
implements Config {
    private final List<MethodPattern> myPatterns;

    private MethodPatternsConfig(List<MethodPattern> patterns) {
        this.myPatterns = patterns;
    }

    @Override
    public boolean shouldTransform(String className) {
        return this.myPatterns.stream().anyMatch(p -> p.matchesClassName(className));
    }

    @Override
    public boolean shouldTransform(String className, String methodName) {
        return this.myPatterns.stream().anyMatch(p -> p.matchesClassName(className) && p.matchesMethodName(methodName));
    }

    @Override
    @Nullable
    public String getSuffix(String className, String methodName) {
        return this.myPatterns.stream().filter(p -> p.matchesClassName(className) && p.matchesMethodName(methodName)).findFirst().map(rec$ -> ((MethodPattern)rec$).getSuffix()).orElse(null);
    }

    @Nullable
    public static Config readFromDocumentOrFile(@NotNull Path file) {
        List<String> lines;
        if (file == null) {
            MethodPatternsConfig.$$$reportNull$$$0(0);
        }
        return (lines = MethodPatternsConfig.linesFromDocument(file)) != null ? MethodPatternsConfig.config(lines) : MethodPatternsConfig.readFromFile(file);
    }

    @Nullable
    static Config readFromFile(@NotNull Path file) {
        if (file == null) {
            MethodPatternsConfig.$$$reportNull$$$0(1);
        }
        try {
            return MethodPatternsConfig.config(Files.readAllLines(file));
        }
        catch (IOException e) {
            MethodTracing.LOG.error((Throwable)e);
            return null;
        }
    }

    @Nullable
    private static List<String> linesFromDocument(@NotNull Path file) {
        VirtualFile vfile;
        if (file == null) {
            MethodPatternsConfig.$$$reportNull$$$0(2);
        }
        Document document = (vfile = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(file)) == null ? null : FileDocumentManager.getInstance().getDocument(vfile);
        return document == null ? null : Arrays.asList(StringUtil.splitByLines((String)document.getText()));
    }

    private static Config config(@NotNull List<String> lines) {
        if (lines == null) {
            MethodPatternsConfig.$$$reportNull$$$0(3);
        }
        List<MethodPattern> patterns = lines.stream().map(s -> StringUtil.trim((String)s)).filter(s -> StringUtil.isNotEmpty((String)s)).map(s -> MethodPattern.fromLine(s.trim())).filter(Objects::nonNull).collect(Collectors.toList());
        return new MethodPatternsConfig(patterns);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/performancePlugin/tracing/MethodPatternsConfig";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "readFromDocumentOrFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "readFromFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "linesFromDocument";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "config";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MethodPattern {
        StringMatcher classNameMatcher;
        StringMatcher methodNameMatcher;
        String suffix;

        private MethodPattern(String className, String methodName, @Nullable String suffix) {
            this.classNameMatcher = StringMatcherBuilder.INSTANCE.create(className);
            this.methodNameMatcher = StringMatcherBuilder.INSTANCE.create(methodName);
            this.suffix = suffix;
        }

        public boolean matchesClassName(String name) {
            return this.classNameMatcher != null && this.classNameMatcher.isMatching(name);
        }

        public boolean matchesMethodName(String name) {
            return this.methodNameMatcher != null && this.methodNameMatcher.isMatching(name);
        }

        @Nullable
        private String getSuffix() {
            return this.suffix;
        }

        static MethodPattern fromLine(String line) {
            int methodNameSeparatorIdx = line.indexOf(35);
            if (methodNameSeparatorIdx < 0) {
                methodNameSeparatorIdx = line.lastIndexOf(46);
            }
            if (methodNameSeparatorIdx > 0) {
                String methodName = line.substring(methodNameSeparatorIdx + 1);
                String className = line.substring(0, methodNameSeparatorIdx);
                String suffix = null;
                int suffixStart = methodName.indexOf("/");
                if (suffixStart >= 0) {
                    suffix = methodName.substring(suffixStart + 1).trim();
                    methodName = methodName.substring(0, suffixStart).trim();
                }
                return new MethodPattern(className, methodName, suffix);
            }
            return null;
        }
    }
}

