/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class SetupProjectSdkCommand
extends AbstractCommand {
    public static final String PREFIX = "%setupSDK";
    private final String mySdkName;
    private final String mySdkType;
    private final String mySdkHome;

    private static String nextArg(Iterator<String> args, @NotNull String text) {
        if (text == null) {
            SetupProjectSdkCommand.$$$reportNull$$$0(0);
        }
        if (!args.hasNext()) {
            throw new RuntimeException("Too few arguments in " + text);
        }
        return args.next();
    }

    public SetupProjectSdkCommand(String text, int line) {
        super(text, line);
        Iterator<String> args = StringUtil.splitHonorQuotes((String)text, (char)' ').stream().map(StringUtil::unquoteString).iterator();
        SetupProjectSdkCommand.nextArg(args, text);
        this.mySdkName = SetupProjectSdkCommand.nextArg(args, text);
        this.mySdkType = SetupProjectSdkCommand.nextArg(args, text);
        this.mySdkHome = SetupProjectSdkCommand.nextArg(args, text);
    }

    private void runUnderPromiseInEDT(@NotNull Consumer<String> logMessage, @NotNull Project project) {
        if (logMessage == null) {
            SetupProjectSdkCommand.$$$reportNull$$$0(1);
        }
        if (project == null) {
            SetupProjectSdkCommand.$$$reportNull$$$0(2);
        }
        logMessage.accept("Settings up SDK: name: " + this.mySdkName + ", type: " + this.mySdkType + ", home: " + this.mySdkHome);
        Sdk sdk = this.setupOrDetectSdk(logMessage);
        ProjectRootManager rootManager = ProjectRootManager.getInstance((Project)project);
        Sdk projectSdk = rootManager.getProjectSdk();
        if (!Objects.equals(projectSdk, sdk)) {
            logMessage.accept("Project uses different SDK: " + projectSdk + " (sdkName is " + rootManager.getProjectSdkName() + ", type " + rootManager.getProjectSdkTypeName() + "). Updating...");
            rootManager.setProjectSdk(sdk);
        }
        logMessage.accept("Project SDK is set to use the new SDK");
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            Sdk moduleSdk = ModuleRootManager.getInstance((Module)module).getSdk();
            if (Objects.equals(moduleSdk, sdk)) continue;
            logMessage.accept("Module " + module.getName() + " uses different SDK: " + moduleSdk + " IGNORING!");
        }
    }

    @NotNull
    private Sdk setupOrDetectSdk(@NotNull Consumer<String> logMessage) {
        boolean isValidSdkHome;
        SdkType sdkType;
        Sdk oldSdk;
        if (logMessage == null) {
            SetupProjectSdkCommand.$$$reportNull$$$0(3);
        }
        if ((oldSdk = ProjectJdkTable.getInstance().findJdk(this.mySdkName)) != null) {
            if (Objects.equals(oldSdk.getSdkType().getName(), this.mySdkName) && FileUtil.pathsEqual((String)oldSdk.getHomePath(), (String)this.mySdkHome)) {
                logMessage.accept("Existing SDK is already configure the expected way");
                Sdk sdk = oldSdk;
                if (sdk == null) {
                    SetupProjectSdkCommand.$$$reportNull$$$0(4);
                }
                return sdk;
            }
            logMessage.accept("Existing different SDK will be removed: " + oldSdk);
            ProjectJdkTable.getInstance().removeJdk(oldSdk);
        }
        if ((sdkType = SdkType.findByName((String)this.mySdkType)) == null) {
            throw new IllegalArgumentException("Failed to find SdkType: " + this.mySdkType);
        }
        try {
            isValidSdkHome = sdkType.isValidSdkHome(this.mySdkHome);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Sdk home " + this.mySdkHome + " for " + sdkType + " is not valid. " + t.getMessage(), t);
        }
        if (!isValidSdkHome) {
            throw new IllegalArgumentException("Sdk home " + this.mySdkHome + " for " + sdkType + " is not valid");
        }
        Sdk newSdk = ProjectJdkTable.getInstance().createSdk(this.mySdkName, (SdkTypeId)sdkType);
        SdkModificator mod = newSdk.getSdkModificator();
        try {
            mod.setVersionString(sdkType.getVersionString(this.mySdkHome));
            mod.setHomePath(this.mySdkHome);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Failed to configure Sdk instance home for " + this.mySdkHome + " for " + sdkType + " is not valid. " + t.getMessage(), t);
        }
        finally {
            mod.commitChanges();
        }
        try {
            sdkType.setupSdkPaths(newSdk);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Failed to setup Sdk home for " + this.mySdkHome + " for " + sdkType + " is not valid. " + t.getMessage(), t);
        }
        this.registerNewSdk(newSdk);
        logMessage.accept("Registered new SDK to ProjectJdkTable: " + newSdk);
        Sdk sdk = newSdk;
        if (sdk == null) {
            SetupProjectSdkCommand.$$$reportNull$$$0(5);
        }
        return sdk;
    }

    protected void registerNewSdk(@NotNull Sdk newSdk) {
        if (newSdk == null) {
            SetupProjectSdkCommand.$$$reportNull$$$0(6);
        }
        ProjectJdkTable.getInstance().addJdk(newSdk);
    }

    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        if (context == null) {
            SetupProjectSdkCommand.$$$reportNull$$$0(7);
        }
        AsyncPromise promise = new AsyncPromise();
        ApplicationManager.getApplication().invokeLater(() -> Promises.compute((AsyncPromise)promise, () -> {
            this.computePromise(s -> context.message(s, this.getLine()), context.getProject());
            return null;
        }));
        return promise;
    }

    public void computePromise(@NotNull Consumer<String> logMessage, @NotNull Project project) {
        if (logMessage == null) {
            SetupProjectSdkCommand.$$$reportNull$$$0(8);
        }
        if (project == null) {
            SetupProjectSdkCommand.$$$reportNull$$$0(9);
        }
        WriteAction.run(() -> this.runUnderPromiseInEDT(logMessage, project));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logMessage";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/commands/SetupProjectSdkCommand";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSdk";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/commands/SetupProjectSdkCommand";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "setupOrDetectSdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "nextArg";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "runUnderPromiseInEDT";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setupOrDetectSdk";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerNewSdk";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "computePromise";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

