/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ClassLoaderUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public class RunClassInPlugin
extends AbstractCommand {
    public static final String PREFIX = "%runClassInPlugin";
    private final String myPluginId;
    private final String myClazzName;
    private final String myMethodName;
    private final List<File> myClasspath;

    private static String nextArg(Iterator<String> args, @NotNull String text) {
        if (text == null) {
            RunClassInPlugin.$$$reportNull$$$0(0);
        }
        if (!args.hasNext()) {
            throw new RuntimeException("Too few arguments in " + text);
        }
        return args.next();
    }

    public RunClassInPlugin(@NotNull String text, int line) {
        if (text == null) {
            RunClassInPlugin.$$$reportNull$$$0(1);
        }
        super(text, line);
        Iterator<String> args = StringUtil.splitHonorQuotes((String)text, (char)' ').stream().map(StringUtil::unquoteString).iterator();
        RunClassInPlugin.nextArg(args, text);
        this.myPluginId = RunClassInPlugin.nextArg(args, text);
        this.myClazzName = RunClassInPlugin.nextArg(args, text);
        this.myMethodName = RunClassInPlugin.nextArg(args, text);
        ArrayList classpath = new ArrayList();
        args.forEachRemaining(arg -> classpath.add(new File((String)arg)));
        this.myClasspath = Collections.unmodifiableList(classpath);
    }

    protected Promise<Object> _execute(PlaybackContext context) {
        AsyncPromise promise = new AsyncPromise();
        AppExecutorUtil.getAppExecutorService().execute(() -> {
            try {
                this.computePromise(context.getProject());
                promise.setResult((Object)"completed");
            }
            catch (Throwable t) {
                promise.setError(t);
            }
        });
        return promise;
    }

    public void computePromise(@NotNull Project project) throws Exception {
        IdeaPluginDescriptor plugin;
        if (project == null) {
            RunClassInPlugin.$$$reportNull$$$0(2);
        }
        if ((plugin = PluginManagerCore.getPlugin((PluginId)PluginId.getId((String)this.myPluginId))) == null) {
            throw new RuntimeException("Failed to find plugin: " + this.myPluginId);
        }
        ClassLoader loader = plugin.getPluginClassLoader();
        URL[] cp = (URL[])this.myClasspath.stream().map(f -> {
            try {
                return f.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Failed to get URL for " + f + ". " + e.getMessage(), e);
            }
        }).toArray(URL[]::new);
        URLClassLoader classLoader = new URLClassLoader(cp, loader);
        ClassLoaderUtil.runWithClassLoader((ClassLoader)classLoader, () -> {
            Class<?> aClass = classLoader.loadClass(this.myClazzName);
            Object newInstance = aClass.newInstance();
            try {
                Method method = aClass.getMethod(this.myMethodName, Project.class);
                method.invoke(newInstance, project);
                return;
            }
            catch (NoSuchMethodException method) {
                try {
                    Method method2 = aClass.getMethod(this.myMethodName, new Class[0]);
                    method2.invoke(newInstance, new Object[0]);
                    return;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new RuntimeException("Class " + this.myClazzName + " does not have " + this.myMethodName + " with with no or Project parameter");
                }
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/performancePlugin/commands/RunClassInPlugin";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "nextArg";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "computePromise";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

