/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.nio.file.Paths;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class OpenProjectCommand
extends AbstractCommand {
    public static final String PREFIX = "%openProject";

    public OpenProjectCommand(@NotNull String text, int line) {
        if (text == null) {
            OpenProjectCommand.$$$reportNull$$$0(0);
        }
        super(text, line, true);
    }

    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        Project newProject;
        if (context == null) {
            OpenProjectCommand.$$$reportNull$$$0(1);
        }
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        String projectToOpen = this.getText().substring(PREFIX.length()).trim();
        @NotNull Project project = context.getProject();
        if (!project.isDefault()) {
            WindowManager.getInstance().updateDefaultFrameInfoOnProjectClose(project);
            context.setProject(null);
            ApplicationManager.getApplication().invokeAndWait(() -> {
                ProjectManagerEx.getInstanceEx().closeAndDispose(project);
                RecentProjectsManager.getInstance().updateLastProjectPath();
                WelcomeFrame.showIfNoProjectOpened();
            }, ModalityState.NON_MODAL);
        }
        if (projectToOpen.isEmpty()) {
            if (project.isDefault()) {
                throw new IllegalArgumentException("Path to open or an opened project required");
            }
            newProject = ProjectManagerEx.getInstanceEx().openProject(Paths.get(Objects.requireNonNull(project.getBasePath()), new String[0]), new OpenProjectTask());
        } else {
            newProject = ProjectManagerEx.getInstanceEx().openProject(Paths.get(projectToOpen, new String[0]), new OpenProjectTask());
        }
        context.setProject(newProject);
        if (newProject == null) {
            actionCallback.reject("Failed to open the project");
        } else if (OpenProjectCommand.shouldOpenInSmartMode(newProject)) {
            DumbService.getInstance((Project)newProject).smartInvokeLater(() -> actionCallback.setDone());
        } else {
            actionCallback.setDone();
        }
        return Promises.toPromise((ActionCallback)actionCallback);
    }

    public static boolean shouldOpenInSmartMode(@NotNull Project project) {
        if (project == null) {
            OpenProjectCommand.$$$reportNull$$$0(2);
        }
        return System.getProperty("performance.execute.during.indexing") == null && !LightEdit.owns((Project)project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/performancePlugin/commands/OpenProjectCommand";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "_execute";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldOpenInSmartMode";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

