/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.ide.DataManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.KeyCodeTypeCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class EnterCommand
extends KeyCodeTypeCommand {
    public static final String PREFIX = "%pressKey";
    private String actionID;

    public EnterCommand(@NotNull String text, int line) {
        if (text == null) {
            EnterCommand.$$$reportNull$$$0(0);
        }
        super(text, line);
    }

    public Promise<Object> _execute(PlaybackContext context) {
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        String input = this.getText().substring(PREFIX.length()).trim();
        switch (StringUtil.toUpperCase((String)input)) {
            case "ENTER": {
                this.actionID = "EditorEnter";
                break;
            }
            case "BACKSPACE": {
                this.actionID = "EditorBackSpace";
                break;
            }
            case "TAB": {
                this.actionID = "EditorTab";
                break;
            }
            case "ESCAPE": {
                this.actionID = "EditorEscape";
                break;
            }
            default: {
                actionCallback.reject("Unknown special character. Please use: ENTER, BACKSPACE, ESCAPE or TAB");
                return Promises.toPromise((ActionCallback)actionCallback);
            }
        }
        @Nullable Project project = context.getProject();
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (editor != null) {
            ApplicationManager.getApplication().invokeLater(() -> {
                CommandProcessor.getInstance().executeCommand(project, () -> EnterCommand.executeAction(editor, this.actionID), "", null, editor.getDocument());
                actionCallback.setDone();
            });
        } else {
            actionCallback.reject("Editor is not opened");
        }
        return Promises.toPromise((ActionCallback)actionCallback);
    }

    public static void executeAction(@NotNull Editor editor, @NotNull String actionId) {
        if (editor == null) {
            EnterCommand.$$$reportNull$$$0(1);
        }
        if (actionId == null) {
            EnterCommand.$$$reportNull$$$0(2);
        }
        AnAction action = ActionManagerEx.getInstanceEx().getAction(actionId);
        AnActionEvent event = AnActionEvent.createFromAnAction((AnAction)action, null, (String)"", (DataContext)EnterCommand.createEditorContext(editor));
        action.actionPerformed(event);
    }

    private static DataContext createEditorContext(@NotNull Editor editor) {
        if (editor == null) {
            EnterCommand.$$$reportNull$$$0(3);
        }
        Editor hostEditor = editor instanceof EditorWindow ? ((EditorWindow)editor).getDelegate() : editor;
        DataContext parent = DataManager.getInstance().getDataContext((Component)editor.getContentComponent());
        return SimpleDataContext.builder().setParent(parent).add(CommonDataKeys.HOST_EDITOR, (Object)hostEditor).add(CommonDataKeys.EDITOR, (Object)editor).build();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/performancePlugin/commands/EnterCommand";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "executeAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createEditorContext";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

