/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.TypingTarget;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.KeyCodeTypeCommand;
import com.intellij.util.ConcurrencyUtil;
import com.jetbrains.performancePlugin.commands.Waiter;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public class DelayTypeCommand
extends KeyCodeTypeCommand {
    public static final String PREFIX = "%delayType";
    private static final Logger LOG = Logger.getInstance(DelayTypeCommand.class);
    public static final char END_CHAR = '#';
    private final ScheduledExecutorService myExecutor;

    public DelayTypeCommand(@NotNull String text, int line) {
        if (text == null) {
            DelayTypeCommand.$$$reportNull$$$0(0);
        }
        super(text, line);
        this.myExecutor = ConcurrencyUtil.newSingleScheduledThreadExecutor((String)"Performance plugin delayed type");
    }

    public Promise<Object> _execute(PlaybackContext context) {
        AsyncPromise result = new AsyncPromise();
        String input = this.getText().substring(PREFIX.length()).trim();
        String[] delayText = input.split("\\|");
        long delay = Integer.parseInt(delayText[0]);
        String text = delayText[1] + "#";
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                LOG.debug("Calling find target first time in DelayTypeCommand");
                Waiter.checkCondition(() -> DelayTypeCommand.findTarget((PlaybackContext)context) != null).await(1L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                result.setError((Throwable)e);
                LOG.debug((Throwable)e);
                return;
            }
            CountDownLatch allScheduled = new CountDownLatch(1);
            for (int i = 0; i < text.length(); ++i) {
                char currentChar = text.charAt(i);
                this.myExecutor.schedule(() -> ApplicationManager.getApplication().invokeAndWait(() -> {
                    if (currentChar == '#') {
                        allScheduled.countDown();
                        this.myExecutor.shutdown();
                    } else {
                        LOG.debug("Calling find target second time in DelayTypeCommand");
                        TypingTarget typingTarget = DelayTypeCommand.findTarget((PlaybackContext)context);
                        if (typingTarget != null) {
                            LOG.debug("Typing " + currentChar);
                            typingTarget.type(String.valueOf(currentChar));
                        }
                    }
                }), (long)i * delay, TimeUnit.MILLISECONDS);
            }
            try {
                allScheduled.await();
                this.myExecutor.awaitTermination(1L, TimeUnit.MINUTES);
                result.setResult(null);
            }
            catch (InterruptedException e) {
                result.setError((Throwable)e);
            }
        });
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/performancePlugin/commands/DelayTypeCommand", "<init>"));
    }
}

