/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionPhase;
import com.intellij.codeInsight.completion.CompletionPhaseListener;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.jetbrains.performancePlugin.Timer;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class CompletionCommand
extends AbstractCommand {
    public static final String PREFIX = "%doComplete";
    private static final Logger LOG = Logger.getInstance(CompletionCommand.class);

    public CompletionCommand(@NotNull String text, int line) {
        if (text == null) {
            CompletionCommand.$$$reportNull$$$0(0);
        }
        super(text, line);
    }

    protected Promise<Object> _execute(final PlaybackContext context) {
        final Timer timer = new Timer();
        final ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        final Disposable listenerDisposable = Disposer.newDisposable();
        ApplicationManager.getApplication().getMessageBus().connect(listenerDisposable).subscribe(CompletionPhaseListener.TOPIC, (Object)new CompletionPhaseListener(){

            public void completionPhaseChanged(boolean isCompletionRunning) {
                if (!isCompletionRunning && !CompletionServiceImpl.isPhase((Class[])new Class[]{CompletionPhase.CommittingDocuments.class})) {
                    if (CompletionServiceImpl.getCurrentCompletionProgressIndicator() == null) {
                        actionCallback.reject("CompletionServiceImpl.getCurrentCompletionProgressIndicator() is null on " + CompletionServiceImpl.getCompletionPhase());
                    } else {
                        int size = CompletionServiceImpl.getCurrentCompletionProgressIndicator().getLookup().getItems().size();
                        context.message("Number of elements: " + size, CompletionCommand.this.getLine());
                        if (timer != null && timer.isStarted()) {
                            timer.stop();
                            LOG.info("Completion execution time = " + timer.getTotalTime());
                        }
                        actionCallback.setDone();
                    }
                    Disposer.dispose((Disposable)listenerDisposable);
                }
            }
        });
        ApplicationManager.getApplication().invokeLater(() -> {
            Project project = context.getProject();
            Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
            timer.start();
            new CodeCompletionHandlerBase(CompletionType.BASIC, true, false, true).invokeCompletion(project, editor);
        });
        return Promises.toPromise((ActionCallback)actionCallback);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/performancePlugin/commands/CompletionCommand", "<init>"));
    }
}

