/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.diagnostic.dump.IndexContentDiagnostic;
import com.intellij.util.indexing.diagnostic.dump.IndexContentDiagnosticDumper;
import com.intellij.util.indexing.diagnostic.dump.paths.IndexedFilePath;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePath;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePathsKt;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import com.jetbrains.performancePlugin.commands.CompareProjectFiles;
import com.jetbrains.performancePlugin.commands.StoreIndices;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import com.jetbrains.performancePlugin.utils.errors.ErrorCollector;
import com.jetbrains.performancePlugin.utils.errors.ToDirectoryWritingErrorCollector;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 *2\u00020\u0001:\u0001*B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\\\u0010\u001b\u001a\u00020\u00142\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020 0\u001f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00050\u001d2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0003H\u0002J$\u0010&\u001a\u00020\u00142\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00030\b2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00030\bH\u0002J\b\u0010)\u001a\u00020\u0016H\u0002R!\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/jetbrains/performancePlugin/commands/CompareProjectFiles;", "Lcom/intellij/openapi/ui/playback/commands/AbstractCommand;", "text", "", "line", "", "(Ljava/lang/String;I)V", "ignoredFilesPatterns", "", "getIgnoredFilesPatterns", "()Ljava/util/List;", "ignoredFilesPatterns$delegate", "Lkotlin/Lazy;", "meaningfulDebugNames", "_execute", "Lorg/jetbrains/concurrency/Promise;", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "compareProjectFiles", "", "expectedDirectory", "Ljava/nio/file/Path;", "actualDirectory", "failureDiagnosticDirectory", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "compareSetsOfFiles", "expectedIds", "", "expectedFileIdToFile", "", "Lcom/intellij/util/indexing/diagnostic/dump/paths/IndexedFilePath;", "actualIds", "actualFileIdToFile", "errorCollector", "Lcom/jetbrains/performancePlugin/utils/errors/ToDirectoryWritingErrorCollector;", "iteratorName", "compareSetsOfIndexableIterators", "expectedIteratorNames", "actualIteratorNames", "getFailureDiagnosticDirectory", "Companion", "intellij.performanceTesting"})
public final class CompareProjectFiles
extends AbstractCommand {
    private final List<String> meaningfulDebugNames;
    private final Lazy ignoredFilesPatterns$delegate;
    @NotNull
    public static final String PREFIX = "%compareProjectFiles";
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        String string = this.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
        String string2 = string;
        int n = PREFIX.length();
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        string2 = string4;
        n = 0;
        String string5 = string2;
        if (string5 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String input = ((Object)StringsKt.trim((CharSequence)string5)).toString();
        List index = StringsKt.split$default((CharSequence)input, (String[])new String[]{" "}, (boolean)false, (int)0, (int)6, null);
        Path expectedDirectory = Paths.get((String)index.get(0), new String[0]);
        Path actualDirectory = Paths.get((String)index.get(1), new String[0]);
        Path failureDiagnosticDirectory = this.getFailureDiagnosticDirectory();
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"context.project");
        Project project2 = project;
        DumbService.getInstance((Project)project2).smartInvokeLater(new Runnable(this, expectedDirectory, actualDirectory, failureDiagnosticDirectory, actionCallback, project2){
            final /* synthetic */ CompareProjectFiles this$0;
            final /* synthetic */ Path $expectedDirectory;
            final /* synthetic */ Path $actualDirectory;
            final /* synthetic */ Path $failureDiagnosticDirectory;
            final /* synthetic */ ActionCallbackProfilerStopper $actionCallback;
            final /* synthetic */ Project $project;

            public final void run() {
                new Task.Modal(this, this.$project, PerformanceTestingBundle.message("comparing.project.files", new Object[0]), false){
                    final /* synthetic */ _execute.1 this$0;

                    public void run(@NotNull ProgressIndicator indicator) {
                        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                        try {
                            CompareProjectFiles compareProjectFiles2 = this.this$0.this$0;
                            Path path = this.this$0.$expectedDirectory;
                            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"expectedDirectory");
                            Path path2 = this.this$0.$actualDirectory;
                            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"actualDirectory");
                            CompareProjectFiles.access$compareProjectFiles(compareProjectFiles2, path, path2, this.this$0.$failureDiagnosticDirectory, indicator);
                            this.this$0.$actionCallback.setDone();
                        }
                        catch (Throwable e) {
                            CompareProjectFiles.access$getLOG$cp().error(e);
                            Intrinsics.checkNotNullExpressionValue((Object)this.this$0.$actionCallback.reject(e.getMessage()), (String)"actionCallback.reject(e.message)");
                        }
                    }
                    {
                        this.this$0 = this$0;
                        super($super_call_param$1, $super_call_param$2, $super_call_param$3);
                    }
                }.queue();
            }
            {
                this.this$0 = compareProjectFiles2;
                this.$expectedDirectory = path;
                this.$actualDirectory = path2;
                this.$failureDiagnosticDirectory = path3;
                this.$actionCallback = actionCallbackProfilerStopper;
                this.$project = project;
            }
        });
        return Promises.toPromise((ActionCallback)actionCallback);
    }

    /*
     * WARNING - void declaration
     */
    private final void compareProjectFiles(Path expectedDirectory, Path actualDirectory, Path failureDiagnosticDirectory, ProgressIndicator indicator) {
        boolean bl;
        block24: {
            Collection $this$flatMapTo$iv$iv;
            void $this$flatMapTo$iv$iv2;
            Object expectedIds;
            Collection $this$associateByTo$iv$iv;
            Integer n;
            Map map;
            void $this$associateByTo$iv$iv2;
            void actualIteratorNames;
            void expectedIteratorNames;
            Object it;
            FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
            if (fileBasedIndex == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.util.indexing.FileBasedIndexImpl");
            }
            ((FileBasedIndexImpl)fileBasedIndex).flushIndexes();
            IndexContentDiagnostic expectedContentDiagnostic = IndexContentDiagnosticDumper.INSTANCE.readFrom(StoreIndices.Companion.getFileForDiagnostic(expectedDirectory));
            IndexContentDiagnostic actualContentDiagnostic = IndexContentDiagnosticDumper.INSTANCE.readFrom(StoreIndices.Companion.getFileForDiagnostic(actualDirectory));
            Iterable $this$partition$iv = expectedContentDiagnostic.getProjectIndexedFileProviderDebugNameToFileIds().keySet();
            boolean $i$f$partition22 = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                boolean bl2;
                block22: {
                    String name = (String)element$iv;
                    boolean bl3 = false;
                    Iterable $this$any$iv = this.meaningfulDebugNames;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv2 : $this$any$iv) {
                            it = (String)element$iv2;
                            boolean bl4 = false;
                            if (!StringsKt.startsWith$default((String)name, (String)it, (boolean)false, (int)2, null)) continue;
                            bl2 = true;
                            break block22;
                        }
                        bl2 = false;
                    }
                }
                if (bl2) {
                    first$iv.add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            Object object = new Pair(first$iv, second$iv);
            List list = (List)object.component1();
            List expectedUnstableNames = (List)object.component2();
            Iterable $this$partition$iv22 = actualContentDiagnostic.getProjectIndexedFileProviderDebugNameToFileIds().keySet();
            boolean $i$f$partition = false;
            ArrayList first$iv2 = new ArrayList();
            ArrayList second$iv2 = new ArrayList();
            for (Object element$iv : $this$partition$iv22) {
                boolean bl5;
                block23: {
                    String name = (String)element$iv;
                    boolean bl6 = false;
                    Iterable $this$any$iv = this.meaningfulDebugNames;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl5 = false;
                    } else {
                        it = $this$any$iv.iterator();
                        while (it.hasNext()) {
                            Object element$iv3 = it.next();
                            String it2 = (String)element$iv3;
                            boolean bl7 = false;
                            if (!StringsKt.startsWith$default((String)name, (String)it2, (boolean)false, (int)2, null)) continue;
                            bl5 = true;
                            break block23;
                        }
                        bl5 = false;
                    }
                }
                if (bl5) {
                    first$iv2.add(element$iv);
                    continue;
                }
                second$iv2.add(element$iv);
            }
            Pair $i$f$partition22 = new Pair(first$iv2, second$iv2);
            object = (List)$i$f$partition22.component1();
            List actualUnstableNames = (List)$i$f$partition22.component2();
            boolean $this$partition$iv22 = false;
            ArrayList<ToDirectoryWritingErrorCollector> errorCollectors = new ArrayList<ToDirectoryWritingErrorCollector>();
            Path path = failureDiagnosticDirectory.resolve("errors-for-set-of-iterators");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"failureDiagnosticDirecto\u2026rs-for-set-of-iterators\")");
            ToDirectoryWritingErrorCollector collector = new ToDirectoryWritingErrorCollector("set-of-iterators", path, 100);
            errorCollectors.add(collector);
            collector.runCatchingError((Function0)new Function0<Unit>(this, (List)expectedIteratorNames, (List)actualIteratorNames){
                final /* synthetic */ CompareProjectFiles this$0;
                final /* synthetic */ List $expectedIteratorNames;
                final /* synthetic */ List $actualIteratorNames;

                public final void invoke() {
                    CompareProjectFiles.access$compareSetsOfIndexableIterators(this.this$0, this.$expectedIteratorNames, this.$actualIteratorNames);
                }
                {
                    this.this$0 = compareProjectFiles2;
                    this.$expectedIteratorNames = list;
                    this.$actualIteratorNames = list2;
                    super(0);
                }
            });
            Iterable $this$associateBy$iv = expectedContentDiagnostic.getAllIndexedFilePaths();
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable element$iv = $this$associateBy$iv;
            Object destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv2) {
                it = (IndexedFilePath)element$iv$iv;
                map = destination$iv$iv;
                boolean bl8 = false;
                n = it.getOriginalFileSystemId();
                map.put(n, element$iv$iv);
            }
            Map expectedFileIdToFile = destination$iv$iv;
            Iterable $this$associateBy$iv2 = actualContentDiagnostic.getAllIndexedFilePaths();
            boolean $i$f$associateBy2 = false;
            int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv2, (int)10)), (int)16);
            destination$iv$iv = $this$associateBy$iv2;
            Object destination$iv$iv22 = new LinkedHashMap(capacity$iv2);
            boolean $i$f$associateByTo22 = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it3;
                IndexedFilePath bl8 = (IndexedFilePath)element$iv$iv;
                map = destination$iv$iv22;
                boolean bl9 = false;
                n = it3.getOriginalFileSystemId();
                map.put(n, element$iv$iv);
            }
            Map actualFileIdToFile = destination$iv$iv22;
            for (String iteratorName : expectedIteratorNames) {
                Path path2 = failureDiagnosticDirectory.resolve("errors-for-" + FileUtil.sanitizeFileName((String)iteratorName));
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"failureDiagnosticDirecto\u2026FileName(iteratorName)}\")");
                ToDirectoryWritingErrorCollector errorCollector = new ToDirectoryWritingErrorCollector(iteratorName, path2, 100);
                $this$associateByTo$iv$iv = errorCollectors;
                boolean destination$iv$iv22 = false;
                $this$associateByTo$iv$iv.add(errorCollector);
                indicator.setText(PerformanceTestingBundle.message("comparing.project.files.for.0", iteratorName));
                destination$iv$iv22 = (Set)expectedContentDiagnostic.getProjectIndexedFileProviderDebugNameToFileIds().get(iteratorName);
                $i$f$associateByTo22 = false;
                Object object2 = destination$iv$iv22;
                if (object2 == null) {
                    object2 = SetsKt.emptySet();
                }
                expectedIds = object2;
                Set $i$f$associateByTo22 = (Set)actualContentDiagnostic.getProjectIndexedFileProviderDebugNameToFileIds().get(iteratorName);
                boolean element$iv$iv = false;
                Set set = $i$f$associateByTo22;
                if (set == null) {
                    set = SetsKt.emptySet();
                }
                Set actualIds = set;
                this.compareSetsOfFiles((Iterable)expectedIds, expectedFileIdToFile, actualIds, actualFileIdToFile, errorCollector, iteratorName);
            }
            Iterable $this$flatMap$iv = expectedUnstableNames;
            boolean $i$f$flatMap = false;
            expectedIds = $this$flatMap$iv;
            destination$iv$iv22 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
                String it4 = (String)element$iv$iv;
                boolean bl10 = false;
                Iterable list$iv$iv = (Set)MapsKt.getValue((Map)expectedContentDiagnostic.getProjectIndexedFileProviderDebugNameToFileIds(), (Object)it4);
                CollectionsKt.addAll((Collection)destination$iv$iv22, (Iterable)list$iv$iv);
            }
            List expectedUnstableIds = (List)destination$iv$iv22;
            Iterable $this$flatMap$iv2 = actualUnstableNames;
            boolean $i$f$flatMap2 = false;
            destination$iv$iv22 = $this$flatMap$iv2;
            Collection destination$iv$iv32 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                String it5 = (String)element$iv$iv;
                boolean bl11 = false;
                Iterable list$iv$iv = (Set)MapsKt.getValue((Map)actualContentDiagnostic.getProjectIndexedFileProviderDebugNameToFileIds(), (Object)it5);
                CollectionsKt.addAll((Collection)destination$iv$iv32, (Iterable)list$iv$iv);
            }
            List actualUnstableIds = (List)destination$iv$iv32;
            String unstableIteratorsName = "iterators-with-unstable-names";
            Path path3 = failureDiagnosticDirectory.resolve("errors-for-" + unstableIteratorsName);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"failureDiagnosticDirecto\u2026-$unstableIteratorsName\")");
            ToDirectoryWritingErrorCollector errorCollector = new ToDirectoryWritingErrorCollector(unstableIteratorsName, path3, 100);
            $this$flatMapTo$iv$iv = errorCollectors;
            boolean destination$iv$iv32 = false;
            $this$flatMapTo$iv$iv.add(errorCollector);
            this.compareSetsOfFiles(expectedUnstableIds, expectedFileIdToFile, actualUnstableIds, actualFileIdToFile, errorCollector, unstableIteratorsName);
            Iterable $this$any$iv = errorCollectors;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv4 : $this$any$iv) {
                    ErrorCollector it6 = (ErrorCollector)element$iv4;
                    boolean bl12 = false;
                    if (!(it6.getNumberOfErrors() > 0)) continue;
                    bl = true;
                    break block24;
                }
                bl = false;
            }
        }
        if (bl) {
            throw (Throwable)new RuntimeException("Some errors during files comparison have been collected. See details in " + failureDiagnosticDirectory);
        }
        LOG.info("Success. Project files are equal");
    }

    /*
     * WARNING - void declaration
     */
    private final void compareSetsOfFiles(Iterable<Integer> expectedIds, Map<Integer, IndexedFilePath> expectedFileIdToFile, Iterable<Integer> actualIds, Map<Integer, IndexedFilePath> actualFileIdToFile, ToDirectoryWritingErrorCollector errorCollector, String iteratorName) {
        Unit unit;
        boolean bl;
        Map actualFiles;
        Map expectedFiles;
        Object object;
        block24: {
            Object element$iv4;
            boolean bl2;
            Set redundantFilePaths;
            Set missingFilePaths;
            boolean destination$iv$iv332;
            block23: {
                void $this$filterKeys$iv;
                void $this$associateByTo$iv$iv;
                Map $this$associateBy$iv;
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv;
                void $this$filterKeys$iv2;
                PortableFilePath portableFilePath;
                void $this$associateByTo$iv$iv2;
                Map $this$associateBy$iv2;
                boolean bl3;
                Object element$iv$iv$iv;
                void $this$mapNotNullTo$iv$iv2;
                Iterable $this$mapNotNull$iv2;
                Iterable<Integer> iterable = expectedIds;
                boolean $i$f$mapNotNull = false;
                void var10_10 = $this$mapNotNull$iv2;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    IndexedFilePath indexedFilePath;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl4 = false;
                    int it = ((Number)element$iv$iv).intValue();
                    boolean bl5 = false;
                    if (expectedFileIdToFile.get(it) == null) continue;
                    boolean bl6 = false;
                    bl3 = false;
                    IndexedFilePath it$iv$iv = indexedFilePath;
                    boolean bl7 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv2 = (List)destination$iv$iv;
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$associateBy$iv2), (int)10)), (int)16);
                destination$iv$iv = $this$associateBy$iv2;
                Map destination$iv$iv232 = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (Object t : $this$associateByTo$iv$iv2) {
                    void it;
                    element$iv$iv$iv = (IndexedFilePath)t;
                    object = destination$iv$iv232;
                    boolean bl8 = false;
                    portableFilePath = it.getPortableFilePath();
                    object.put(portableFilePath, t);
                }
                $this$associateBy$iv2 = destination$iv$iv232;
                boolean $i$f$filterKeys232 = false;
                LinkedHashMap result$iv = new LinkedHashMap();
                $this$associateByTo$iv$iv2 = $this$filterKeys$iv2;
                boolean destination$iv$iv232 = false;
                for (Map.Entry entry$iv2 : $this$associateByTo$iv$iv2.entrySet()) {
                    boolean bl7;
                    block21: {
                        PortableFilePath portableFilePath2 = (PortableFilePath)entry$iv2.getKey();
                        boolean bl10 = false;
                        Iterable $this$none$iv = this.getIgnoredFilesPatterns();
                        boolean $i$f$none = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            bl7 = true;
                        } else {
                            for (Object element$iv2 : $this$none$iv) {
                                String it = (String)element$iv2;
                                boolean bl11 = false;
                                if (!PortableFilePathsKt.hasPresentablePathMatching((PortableFilePath)portableFilePath2, (String)it)) continue;
                                bl7 = false;
                                break block21;
                            }
                            bl7 = true;
                        }
                    }
                    if (!bl7) continue;
                    result$iv.put(entry$iv2.getKey(), entry$iv2.getValue());
                }
                expectedFiles = result$iv;
                Iterable<Integer> $i$f$filterKeys232 = actualIds;
                boolean $i$f$mapNotNull2 = false;
                $this$associateByTo$iv$iv2 = $this$mapNotNull$iv;
                Collection destination$iv$iv4 = new ArrayList();
                boolean $i$f$mapNotNullTo2 = false;
                void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
                boolean bl8 = false;
                Iterator bl10 = $this$forEach$iv$iv$iv2.iterator();
                while (bl10.hasNext()) {
                    IndexedFilePath bl11;
                    Object element$iv$iv$iv2;
                    Object element$iv$iv = element$iv$iv$iv2 = bl10.next();
                    boolean bl12 = false;
                    int it = ((Number)element$iv$iv).intValue();
                    boolean bl13 = false;
                    if (actualFileIdToFile.get(it) == null) continue;
                    bl3 = false;
                    boolean bl9 = false;
                    IndexedFilePath it$iv$iv = bl11;
                    boolean bl15 = false;
                    destination$iv$iv4.add(it$iv$iv);
                }
                $this$mapNotNull$iv = (List)destination$iv$iv4;
                boolean $i$f$associateBy2 = false;
                int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$associateBy$iv), (int)10)), (int)16);
                destination$iv$iv4 = $this$associateBy$iv;
                Map destination$iv$iv332 = new LinkedHashMap(capacity$iv2);
                boolean $i$f$associateByTo2 = false;
                for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                    void it;
                    IndexedFilePath element$iv$iv$iv2 = (IndexedFilePath)element$iv$iv;
                    object = destination$iv$iv332;
                    boolean bl16 = false;
                    portableFilePath = it.getPortableFilePath();
                    object.put(portableFilePath, element$iv$iv);
                }
                $this$associateBy$iv = destination$iv$iv332;
                boolean $i$f$filterKeys = false;
                Object result$iv2 = new LinkedHashMap();
                void var12_23 = $this$filterKeys$iv;
                destination$iv$iv332 = false;
                for (Map.Entry entry : var12_23.entrySet()) {
                    boolean bl11;
                    block22: {
                        PortableFilePath file = (PortableFilePath)entry.getKey();
                        boolean bl18 = false;
                        Iterable $this$none$iv = this.getIgnoredFilesPatterns();
                        boolean $i$f$none = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            bl11 = true;
                        } else {
                            for (Object element$iv3 : $this$none$iv) {
                                String it = (String)element$iv3;
                                boolean bl19 = false;
                                if (!PortableFilePathsKt.hasPresentablePathMatching((PortableFilePath)file, (String)it)) continue;
                                bl11 = false;
                                break block22;
                            }
                            bl11 = true;
                        }
                    }
                    if (!bl11) continue;
                    ((HashMap)result$iv2).put(entry.getKey(), entry.getValue());
                }
                actualFiles = (Map)result$iv2;
                missingFilePaths = SetsKt.minus(expectedFiles.keySet(), (Iterable)actualFiles.keySet());
                redundantFilePaths = SetsKt.minus(actualFiles.keySet(), (Iterable)expectedFiles.keySet());
                result$iv2 = missingFilePaths;
                bl2 = false;
                if (!result$iv2.isEmpty()) break block23;
                result$iv2 = redundantFilePaths;
                bl2 = false;
                if (!(!result$iv2.isEmpty())) break block24;
            }
            boolean result$iv2 = false;
            bl2 = false;
            StringBuilder stringBuilder = new StringBuilder();
            destination$iv$iv332 = false;
            boolean $i$f$associateByTo2 = false;
            StringBuilder stringBuilder2 = stringBuilder;
            object = errorCollector;
            boolean bl20 = false;
            StringBuilder bl18 = stringBuilder2;
            String $this$none$iv = "The sets of indexed files for " + iteratorName + " do not match";
            boolean bl12 = false;
            StringBuilder stringBuilder3 = bl18.append($this$none$iv);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
            StringBuilder it = stringBuilder3;
            boolean element$iv3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it.append('\n'), (String)"append('\\n')");
            bl18 = stringBuilder2;
            $this$none$iv = "  Missing file paths:";
            bl12 = false;
            StringBuilder stringBuilder4 = bl18.append($this$none$iv);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
            it = stringBuilder4;
            element$iv3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it.append('\n'), (String)"append('\\n')");
            Object $this$forEach$iv = missingFilePaths;
            boolean $i$f$forEach232 = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                StringBuilder stringBuilder5;
                element$iv4 = iterator.next();
                PortableFilePath it2 = (PortableFilePath)element$iv4;
                boolean bl22 = false;
                StringBuilder stringBuilder6 = stringBuilder2;
                String string = "    " + it2.getPresentablePath();
                boolean bl13 = false;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append(string), (String)"append(value)");
                bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append('\\n')");
            }
            $this$forEach$iv = stringBuilder2;
            String $i$f$forEach232 = "  Redundant file paths:";
            boolean bl14 = false;
            StringBuilder stringBuilder7 = ((StringBuilder)$this$forEach$iv).append($i$f$forEach232);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(value)");
            element$iv4 = stringBuilder7;
            boolean it2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)element$iv4).append('\n'), (String)"append('\\n')");
            $this$forEach$iv = redundantFilePaths;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                StringBuilder stringBuilder8;
                Object element$iv = iterator2.next();
                PortableFilePath it3 = (PortableFilePath)element$iv;
                boolean bl25 = false;
                StringBuilder stringBuilder9 = stringBuilder2;
                String string = "    " + it3.getPresentablePath();
                boolean bl15 = false;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9.append(string), (String)"append(value)");
                bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8.append('\n'), (String)"append('\\n')");
            }
            unit = Unit.INSTANCE;
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            String string2 = string;
            ((ToDirectoryWritingErrorCollector)object).addError(new RuntimeException(string2));
        }
        if (errorCollector.getNumberOfErrors() > 0) {
            return;
        }
        for (PortableFilePath filePath : expectedFiles.keySet()) {
            IndexedFilePath actualData;
            IndexedFilePath expectedIndexedFile = (IndexedFilePath)MapsKt.getValue((Map)expectedFiles, (Object)filePath);
            IndexedFilePath actualIndexedFile = (IndexedFilePath)MapsKt.getValue((Map)actualFiles, (Object)filePath);
            IndexedFilePath indexedFilePath = IndexedFilePath.copy$default((IndexedFilePath)expectedIndexedFile, (int)0, null, null, null, (String)"", null, null, null, null, (int)494, null);
            if (Intrinsics.areEqual((Object)indexedFilePath, (Object)(actualData = IndexedFilePath.copy$default((IndexedFilePath)actualIndexedFile, (int)0, null, null, null, (String)"", null, null, null, null, (int)494, null))) ^ true) {
                String string;
                void $this$buildString;
                boolean bl16 = false;
                boolean bl17 = false;
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl18 = false;
                boolean bl19 = false;
                StringBuilder it3 = stringBuilder;
                object = errorCollector;
                boolean bl31 = false;
                void var23_108 = $this$buildString;
                String string3 = "Indexed file " + filePath.getPresentablePath() + " data mismatch";
                boolean bl20 = false;
                StringBuilder stringBuilder10 = var23_108.append(string3);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10, (String)"append(value)");
                StringBuilder stringBuilder11 = stringBuilder10;
                bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11.append('\n'), (String)"append('\\n')");
                var23_108 = $this$buildString;
                string3 = "  Expected:";
                bl20 = false;
                StringBuilder stringBuilder12 = var23_108.append(string3);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder12, (String)"append(value)");
                stringBuilder11 = stringBuilder12;
                bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11.append('\n'), (String)"append('\\n')");
                var23_108 = $this$buildString;
                string3 = SequencesKt.joinToString$default((Sequence)StringsKt.lineSequence((CharSequence)expectedIndexedFile.toString()), (CharSequence)"\n", null, null, (int)0, null, (Function1)compareSetsOfFiles.2.1.INSTANCE, (int)30, null);
                bl20 = false;
                StringBuilder stringBuilder13 = var23_108.append(string3);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder13, (String)"append(value)");
                stringBuilder11 = stringBuilder13;
                bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11.append('\n'), (String)"append('\\n')");
                var23_108 = $this$buildString;
                string3 = "  Actual:";
                bl20 = false;
                StringBuilder stringBuilder14 = var23_108.append(string3);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder14, (String)"append(value)");
                stringBuilder11 = stringBuilder14;
                bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11.append('\n'), (String)"append('\\n')");
                var23_108 = $this$buildString;
                string3 = SequencesKt.joinToString$default((Sequence)StringsKt.lineSequence((CharSequence)actualIndexedFile.toString()), (CharSequence)"\n", null, null, (int)0, null, (Function1)compareSetsOfFiles.2.2.INSTANCE, (int)30, null);
                bl20 = false;
                StringBuilder stringBuilder15 = var23_108.append(string3);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder15, (String)"append(value)");
                stringBuilder11 = stringBuilder15;
                bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11.append('\n'), (String)"append('\\n')");
                unit = Unit.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.toString(), (String)"StringBuilder().apply(builderAction).toString()");
                ((ToDirectoryWritingErrorCollector)object).addError(new RuntimeException(string));
            }
            if (errorCollector.getNumberOfErrors() <= 100) continue;
            break;
        }
    }

    private final void compareSetsOfIndexableIterators(List<String> expectedIteratorNames, List<String> actualIteratorNames) {
        block3: {
            boolean bl;
            List redundantIteratorNames;
            List missingIteratorNames;
            block2: {
                missingIteratorNames = CollectionsKt.minus((Iterable)expectedIteratorNames, (Iterable)actualIteratorNames);
                redundantIteratorNames = CollectionsKt.minus((Iterable)actualIteratorNames, (Iterable)expectedIteratorNames);
                Collection collection = missingIteratorNames;
                bl = false;
                if (!collection.isEmpty()) break block2;
                collection = redundantIteratorNames;
                bl = false;
                if (!(!collection.isEmpty())) break block3;
            }
            boolean bl2 = false;
            bl = false;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl3 = false;
            boolean bl4 = false;
            StringBuilder $this$buildString = stringBuilder;
            boolean bl5 = false;
            StringBuilder stringBuilder2 = $this$buildString;
            String string = "The sets of indexable file iterators do not match";
            boolean bl6 = false;
            StringBuilder stringBuilder3 = stringBuilder2.append(string);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
            StringBuilder stringBuilder4 = stringBuilder3;
            boolean bl7 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
            stringBuilder2 = $this$buildString;
            string = "  Missing iterators: [" + CollectionsKt.joinToString$default((Iterable)missingIteratorNames, null, null, null, (int)0, null, null, (int)63, null) + "]";
            bl6 = false;
            StringBuilder stringBuilder5 = stringBuilder2.append(string);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
            stringBuilder4 = stringBuilder5;
            bl7 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
            stringBuilder2 = $this$buildString;
            string = "  Redundant iterators: [" + CollectionsKt.joinToString$default((Iterable)redundantIteratorNames, null, null, null, (int)0, null, null, (int)63, null) + "]";
            bl6 = false;
            StringBuilder stringBuilder6 = stringBuilder2.append(string);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
            stringBuilder4 = stringBuilder6;
            bl7 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
            String string2 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
            String string3 = string2;
            boolean bl8 = false;
            throw (Throwable)new IllegalStateException(string3.toString());
        }
    }

    private final Path getFailureDiagnosticDirectory() {
        String property = System.getProperty("compare.project.files.command.failure.diagnostic.directory");
        if (property != null) {
            Path path = Paths.get(property, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(property)");
            return path;
        }
        Path path = FileUtil.createTempDirectory((String)"compare-project-files", (String)"failure").toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"FileUtil.createTempDirec\u2026les\", \"failure\").toPath()");
        return path;
    }

    private final List<String> getIgnoredFilesPatterns() {
        Lazy lazy = this.ignoredFilesPatterns$delegate;
        CompareProjectFiles compareProjectFiles2 = this;
        Object var3_3 = null;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    public CompareProjectFiles(@NotNull String text, int line) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text, line);
        this.meaningfulDebugNames = CollectionsKt.listOf((Object[])new String[]{"Module", "Library", "SDK", "JDK", "Synthetic library", "Go SDK module"});
        this.ignoredFilesPatterns$delegate = LazyKt.lazy((Function0)ignoredFilesPatterns.2.INSTANCE);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(CompareProjectFiles.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Compa\u2026ProjectFiles::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ void access$compareProjectFiles(CompareProjectFiles $this, Path expectedDirectory, Path actualDirectory, Path failureDiagnosticDirectory, ProgressIndicator indicator) {
        $this.compareProjectFiles(expectedDirectory, actualDirectory, failureDiagnosticDirectory, indicator);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ void access$compareSetsOfIndexableIterators(CompareProjectFiles $this, List expectedIteratorNames, List actualIteratorNames) {
        $this.compareSetsOfIndexableIterators(expectedIteratorNames, actualIteratorNames);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/performancePlugin/commands/CompareProjectFiles$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "PREFIX", "", "intellij.performanceTesting"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

