/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.cachedValueProfiler;

import com.intellij.ide.DataManager;
import com.intellij.internal.cachedValueProfiler.CachedValueProfilerDumpHelper;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.util.CachedValueProfiler;
import com.intellij.reference.SoftReference;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableViewSpeedSearch;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.table.TableView;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import com.jetbrains.performancePlugin.cachedValueProfiler.CVPEditor;
import com.jetbrains.performancePlugin.cachedValueProfiler.NavigationHelper;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CVPPanel
extends JBLoadingPanel
implements Disposable {
    private static final Key<SoftReference<TableView<CVPInfo>>> PREV_TABLE = Key.create((String)"PREV_TABLE");
    private final VirtualFile myFile;
    private final TableView<CVPInfo> myTable;
    private static final ColorKey HOVER_BACKGROUND = ColorKey.createColorKey((String)"Table.hoverBackground", (Color)JBUI.CurrentTheme.Table.Hover.background((boolean)true));
    private static final NumberFormat FORMAT = NumberFormat.getInstance(Locale.US);

    CVPPanel(@NotNull Project project, @NotNull VirtualFile file, @NotNull Disposable parent) {
        if (project == null) {
            CVPPanel.$$$reportNull$$$0(0);
        }
        if (file == null) {
            CVPPanel.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            CVPPanel.$$$reportNull$$$0(2);
        }
        super((LayoutManager)new BorderLayout(), parent);
        this.myFile = file;
        Disposer.register((Disposable)parent, (Disposable)this);
        TableView<CVPInfo> prevTable = (TableView<CVPInfo>)SoftReference.deref((Supplier)((Supplier)PREV_TABLE.get((UserDataHolder)file)));
        PREV_TABLE.set((UserDataHolder)file, null);
        CVPPanel existingPanel = (CVPPanel)((Object)JBIterable.of((Object[])FileEditorManager.getInstance((Project)project).getEditors(file)).filter(CVPEditor.class).filterMap(o -> (CVPPanel)((Object)((Object)o.getComponent()))).first());
        TableView<CVPInfo> tableView = this.myTable = prevTable != null ? prevTable : CVPPanel.createTable(project, existingPanel);
        if (file instanceof LightVirtualFile || prevTable != null || existingPanel != null) {
            this.add(ScrollPaneFactory.createScrollPane(this.myTable, (boolean)true), "Center");
            return;
        }
        this.startLoading();
        AppExecutorUtil.getAppExecutorService().execute(() -> {
            IOException error = null;
            try {
                this.loadInfos(VfsUtilCore.virtualToIoFile((VirtualFile)file));
            }
            catch (IOException ex) {
                error = ex;
            }
            finally {
                IOException finalError = error;
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (this.myTable.getListTableModel().getRowCount() > 0) {
                        this.myTable.getRowSorter().setSortKeys(Collections.singletonList(new RowSorter.SortKey(1, SortOrder.DESCENDING)));
                        this.add(ScrollPaneFactory.createScrollPane(this.myTable, (boolean)true), "Center");
                    } else {
                        this.add((Component)new JBLabel(finalError != null ? finalError.getMessage() : LangBundle.message((String)"status.text.nothing.to.show", (Object[])new Object[0])));
                    }
                    this.stopLoading();
                }, o -> Disposer.isDisposed((Disposable)parent));
            }
        });
    }

    @NotNull
    VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            CVPPanel.$$$reportNull$$$0(3);
        }
        return virtualFile;
    }

    @NotNull
    MyEventConsumer createEventConsumer() {
        this.updateModel(Collections.emptyList());
        return new MyEventConsumer(this::updateModel);
    }

    public void dispose() {
        PREV_TABLE.set((UserDataHolder)this.myFile, (Object)(Boolean.TRUE.equals(FileEditorManagerImpl.CLOSING_TO_REOPEN.get((UserDataHolder)this.myFile)) ? new SoftReference(this.myTable) : null));
    }

    private void updateModel(@NotNull List<CVPInfo> infos) {
        if (infos == null) {
            CVPPanel.$$$reportNull$$$0(4);
        }
        ArrayList<CVPInfo> selection = Collections.emptyList();
        MyTableModel model = (MyTableModel)this.myTable.getListTableModel();
        ColumnInfo[] columns = model.getColumnInfos();
        List prevItems = model.getItems();
        if (!prevItems.isEmpty()) {
            model.changeBits = new long[infos.size()];
            HashMap<StackTraceElement, Object> prevMap = new HashMap<StackTraceElement, Object>();
            for (Object prev : prevItems) {
                prevMap.put(((CVPInfo)prev).place, prev);
            }
            HashSet<StackTraceElement> prevSelection = null;
            for (CVPInfo prev : this.myTable.getSelectedObjects()) {
                if (prevSelection == null) {
                    prevSelection = new HashSet<StackTraceElement>();
                }
                prevSelection.add(prev.place);
            }
            selection = prevSelection == null ? selection : new ArrayList<CVPInfo>(prevSelection.size());
            int i = 0;
            for (CVPInfo info : infos) {
                CVPInfo prev = (CVPInfo)prevMap.get(info.place);
                long l = model.changeBits[i++] = prev == null ? -1L : CVPPanel.columnsDiff(columns, info, prev);
                if (prev == null || prevSelection == null || !prevSelection.contains(info.place)) continue;
                selection.add(info);
            }
        }
        model.setItems(infos);
        this.myTable.setSelection(selection);
    }

    private static long columnsDiff(ColumnInfo<CVPInfo, ?>[] columns, CVPInfo info, CVPInfo prev) {
        long result = 0L;
        int length = columns.length;
        for (int i = 0; i < length; ++i) {
            Comparator comparator = Objects.requireNonNull(columns[i].getComparator());
            if (comparator.compare(info, prev) == 0) continue;
            result |= 1L << i;
        }
        return result;
    }

    static Color color(ColorKey key, Color def) {
        return (Color)ObjectUtils.coalesce((Object)CVPPanel.colorScheme().getColor(key), (Object)def);
    }

    static EditorColorsScheme colorScheme() {
        return EditorColorsManager.getInstance().getGlobalScheme();
    }

    @NotNull
    private static TableView<CVPInfo> createTable(@NotNull Project project, CVPPanel existingPanel) {
        if (project == null) {
            CVPPanel.$$$reportNull$$$0(5);
        }
        MyTableModel model = existingPanel != null ? existingPanel.myTable.getListTableModel() : new MyTableModel();
        TableView<CVPInfo> table = new TableView<CVPInfo>((ListTableModel)model){

            public Color getBackground() {
                return CVPPanel.colorScheme().getDefaultBackground();
            }

            public Color getForeground() {
                return CVPPanel.colorScheme().getDefaultForeground();
            }

            public Color getGridColor() {
                return CVPPanel.color(EditorColors.INDENT_GUIDE_COLOR, super.getGridColor());
            }

            public Color getSelectionForeground() {
                return CVPPanel.color(EditorColors.SELECTION_FOREGROUND_COLOR, this.getForeground());
            }

            public Color getSelectionBackground() {
                return CVPPanel.color(EditorColors.SELECTION_BACKGROUND_COLOR, this.getBackground());
            }

            protected Color getHoveredRowBackground() {
                return CVPPanel.color(HOVER_BACKGROUND, super.getHoveredRowBackground());
            }
        };
        table.setAutoResizeMode(0);
        table.setFillsViewportHeight(true);
        table.setAdditionalRowsCount(5);
        UIUtil.putClientProperty((JComponent)table, (Key)RenderingUtil.CUSTOM_SELECTION_BACKGROUND, () -> CVPPanel.lambda$createTable$4((TableView)table));
        UIUtil.putClientProperty((JComponent)table, (Key)RenderingUtil.CUSTOM_SELECTION_FOREGROUND, () -> CVPPanel.lambda$createTable$5((TableView)table));
        table.setDefaultRenderer(Object.class, (TableCellRenderer)new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(@NotNull JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
                Color bg;
                long bits;
                if (table == null) {
                    2.$$$reportNull$$$0(0);
                }
                MyTableModel model = (MyTableModel)((Object)table.getModel());
                int modelRow = table.convertRowIndexToModel(row);
                int modelCol = table.convertColumnIndexToModel(column);
                long l = bits = model.changeBits != null && modelRow < model.changeBits.length ? model.changeBits[modelRow] : 0L;
                Color color = selected ? null : (bits == -1L ? CVPPanel.color(EditorColors.ADDED_LINES_COLOR, null) : (bg = (bits & 1L << modelCol) != 0L ? CVPPanel.color(EditorColors.MODIFIED_LINES_COLOR, null) : null));
                if (bg != null) {
                    this.setBackground(bg);
                }
                this.setTextAlign(modelCol == 0 ? 2 : 4);
                SpeedSearchUtil.appendFragmentsForSpeedSearch((JComponent)table, (String)String.valueOf(value), (SimpleTextAttributes)SimpleTextAttributes.REGULAR_ATTRIBUTES, (boolean)selected, (SimpleColoredComponent)this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/jetbrains/performancePlugin/cachedValueProfiler/CVPPanel$2", "customizeCellRenderer"));
            }
        });
        new TableViewSpeedSearch<CVPInfo>((TableView)table){

            @Nullable
            protected String getItemText(@NotNull CVPInfo element) {
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                return String.valueOf(element.place);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/performancePlugin/cachedValueProfiler/CVPPanel$3", "getItemText"));
            }
        }.setFilteringMode(true);
        DataManager.registerDataProvider((JComponent)table, arg_0 -> CVPPanel.lambda$createTable$9((TableView)table, project, arg_0));
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent event) {
                Navigatable[] data;
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                if ((data = (Navigatable[])DataManager.getInstance().getDataContext(event.getComponent()).getData(CommonDataKeys.NAVIGATABLE_ARRAY)) == null || data.length == 0) {
                    return false;
                }
                for (Navigatable datum : data) {
                    datum.navigate(true);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/performancePlugin/cachedValueProfiler/CVPPanel$4", "onDoubleClick"));
            }
        }.installOn((Component)table);
        for (int i = 0; i < model.getColumnCount(); ++i) {
            int width = ((MyColumnInfo)model.getColumnInfos()[i]).width;
            int viewIdx = table.convertColumnIndexToView(i);
            TableColumn column = table.getColumnModel().getColumn(viewIdx);
            column.setPreferredWidth(width);
            if (existingPanel == null) continue;
            int otherViewIdx = existingPanel.myTable.convertColumnIndexToView(i);
            TableColumn otherColumn = existingPanel.myTable.getColumnModel().getColumn(otherViewIdx);
            column.setPreferredWidth(otherColumn.getWidth());
            table.getColumnModel().moveColumn(viewIdx, otherViewIdx);
        }
        if (existingPanel != null) {
            table.getRowSorter().setSortKeys(existingPanel.myTable.getRowSorter().getSortKeys());
        }
        TableView<CVPInfo> tableView = table;
        if (tableView == null) {
            CVPPanel.$$$reportNull$$$0(6);
        }
        return tableView;
    }

    private static MyColumnInfo[] getColumns() {
        return new MyColumnInfo[]{CVPPanel.columnInfoS(PerformanceTestingBundle.message("cached.value.profiler.column.place", new Object[0]), o -> String.valueOf(o.place), 800, null), CVPPanel.columnInfoL(PerformanceTestingBundle.message("cached.value.profiler.column.count", new Object[0]), o -> o.count, 80, "Number of computations of a value"), CVPPanel.columnInfoL(PerformanceTestingBundle.message("cached.value.profiler.column.total.cost", new Object[0]), o -> o.cost, 120, "Total time to compute a value (ns)"), CVPPanel.columnInfoD(PerformanceTestingBundle.message("cached.value.profiler.column.avg.cost", new Object[0]), o -> o.count == 0L ? 0.0 : (double)o.cost / (double)o.count, 120, "Average time to compute a value (ns)"), CVPPanel.columnInfoL(PerformanceTestingBundle.message("cached.value.profiler.column.total.use.count", new Object[0]), o -> o.used, 80, "Total number of times a value was read (1-based)"), CVPPanel.columnInfoD(PerformanceTestingBundle.message("cached.value.profiler.column.avg.use.count", new Object[0]), o -> o.count == 0L ? 0.0 : (double)o.used / (double)o.count, 80, "Average number of times a value was read (1-based)"), CVPPanel.columnInfoL(PerformanceTestingBundle.message("cached.value.profiler.column.aborted", new Object[0]), o -> o.aborted, 80, "Number of times a computation was cancelled or not finished"), CVPPanel.columnInfoL(PerformanceTestingBundle.message("cached.value.profiler.column.rejected", new Object[0]), o -> o.rejected, 80, "Number of times a computation result was rejected right away<br/>Several computations of a value may succeed at the same time"), CVPPanel.columnInfoL(PerformanceTestingBundle.message("cached.value.profiler.column.wasted", new Object[0]), o -> o.wasted, 100, "Total time of computations that were later aborted or rejected (ns)"), CVPPanel.columnInfoL(PerformanceTestingBundle.message("cached.value.profiler.column.max.life.time", new Object[0]), o -> o.lifetime, 200, "Longest period of time between value computation and usage (ns)"), CVPPanel.columnInfoL(PerformanceTestingBundle.message("cached.value.profiler.column.max.limbo.time", new Object[0]), o -> o.limbotime, 200, "Longest period of time between value invalidation and last usage (ns)<br/>'0' means a value was never explicitly invalidated when requested")};
    }

    @NotNull
    private static MyColumnInfo columnInfoL(@Nls String name, ToLongFunction<CVPInfo> value, int width, String tooltip) {
        return CVPPanel.columnInfo(name, o -> CVPPanel.format(value.applyAsLong((CVPInfo)o)), Comparator.comparingLong(value), width, tooltip);
    }

    @NotNull
    private static MyColumnInfo columnInfoS(@Nls String name, Function<CVPInfo, String> value, int width, String tooltip) {
        return CVPPanel.columnInfo(name, value, Comparator.comparing(value), width, tooltip);
    }

    @NotNull
    private static MyColumnInfo columnInfoD(@Nls String name, ToDoubleFunction<CVPInfo> value, int width, String tooltip) {
        return CVPPanel.columnInfo(name, o -> CVPPanel.format(Math.round(value.applyAsDouble((CVPInfo)o))), Comparator.comparingDouble(value), width, tooltip);
    }

    @NotNull
    private static MyColumnInfo columnInfo(@Nls String name, Function<CVPInfo, String> toString, Comparator<CVPInfo> comparator, int width, String tooltip) {
        return new MyColumnInfo(name, toString, comparator, width, tooltip);
    }

    private static String format(long value) {
        return FORMAT.format(value);
    }

    private void loadInfos(File file) throws IOException {
        try (MyEventConsumer consumer = this.createEventConsumer();){
            consumer.lastFlushMillis = Long.MAX_VALUE;
            CachedValueProfilerDumpHelper.loadDump((File)file, (CachedValueProfiler.EventConsumer)consumer);
        }
    }

    private static /* synthetic */ Object lambda$createTable$9(TableView table, Project project, String dataId) {
        if (PlatformDataKeys.SLOW_DATA_PROVIDERS.is(dataId)) {
            return Collections.singleton(slowDataId -> {
                if (CommonDataKeys.NAVIGATABLE_ARRAY.is(slowDataId)) {
                    NavigationHelper helper = NavigationHelper.getInstance();
                    if (helper == null) {
                        return null;
                    }
                    return table.getSelectedObjects().stream().map(o -> helper.getNavigatable(project, o.place)).filter(Objects::nonNull).toArray(Navigatable[]::new);
                }
                return null;
            });
        }
        return null;
    }

    private static /* synthetic */ Color lambda$createTable$5(TableView table) {
        return table.getSelectionForeground();
    }

    private static /* synthetic */ Color lambda$createTable$4(TableView table) {
        return table.getSelectionBackground();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/cachedValueProfiler/CVPPanel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/cachedValueProfiler/CVPPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createTable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateModel";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyEventConsumer
    implements CachedValueProfiler.EventConsumer,
    Closeable {
        final Consumer<List<CVPInfo>> updater;
        final Long2ObjectMap<StackTraceElement> frames;
        final Map<StackTraceElement, Computed> computedMap;
        final Map<StackTraceElement, Aborted> abortedMap;
        final Map<StackTraceElement, StackTraceElement> matchedPlaces;
        long lastFlushMillis;

        MyEventConsumer(@NotNull Consumer<List<CVPInfo>> updater) {
            if (updater == null) {
                MyEventConsumer.$$$reportNull$$$0(0);
            }
            this.frames = new Long2ObjectOpenHashMap();
            this.computedMap = FactoryMap.create(o -> new Computed());
            this.abortedMap = FactoryMap.create(o -> new Aborted());
            this.matchedPlaces = new HashMap<StackTraceElement, StackTraceElement>();
            this.lastFlushMillis = System.currentTimeMillis();
            this.updater = updater;
        }

        private void flush() {
            if (this.lastFlushMillis == Long.MAX_VALUE || System.currentTimeMillis() - this.lastFlushMillis <= 1000L) {
                return;
            }
            this.lastFlushMillis = System.currentTimeMillis();
            List<CVPInfo> infos = MyEventConsumer.buildInfos(this.computedMap);
            EdtExecutorService.getInstance().execute(() -> this.updater.accept(infos), ModalityState.any());
        }

        @NotNull
        private static List<CVPInfo> buildInfos(@NotNull Map<StackTraceElement, Computed> map) {
            if (map == null) {
                MyEventConsumer.$$$reportNull$$$0(1);
            }
            ArrayList<CVPInfo> result = new ArrayList<CVPInfo>(map.size());
            for (Map.Entry<StackTraceElement, Computed> entry : map.entrySet()) {
                if (entry.getKey() == null) continue;
                Computed c = entry.getValue();
                result.add(new CVPInfo(entry.getKey(), c.count, c.cost, c.used, c.aborted, c.rejected, c.wasted, c.lifetime, c.limbotime));
            }
            ArrayList<CVPInfo> arrayList = result;
            if (arrayList == null) {
                MyEventConsumer.$$$reportNull$$$0(2);
            }
            return arrayList;
        }

        public void onFrameEnter(long frameId, CachedValueProfiler.EventPlace place, long parentId, long time) {
            if (this.computedMap.isEmpty()) {
                this.computedMap.put(null, Computed.NULL);
            }
            this.frames.put(frameId, (Object)place.getStackFrame());
        }

        public void onFrameExit(long frameId, long start, long computed, long time) {
            StackTraceElement place = (StackTraceElement)this.frames.remove(frameId);
            Computed c = this.computedMap.get(this.matchedPlaces.get(place));
            if (computed == 0L) {
                if (c == Computed.NULL) {
                    Aborted a = this.abortedMap.get(place);
                    ++a.count;
                    a.cost += time - start;
                } else {
                    ++c.aborted;
                    c.wasted += time - start;
                }
            }
            this.flush();
        }

        public void onValueComputed(long frameId, CachedValueProfiler.EventPlace place, long start, long time) {
            Computed c = this.computedMap.get(place.getStackFrame());
            ++c.count;
            c.cost += time - start;
            StackTraceElement framePlace = (StackTraceElement)this.frames.get(frameId);
            if (!this.matchedPlaces.containsKey(framePlace)) {
                this.matchedPlaces.put(framePlace, place.getStackFrame());
                Aborted aborted = this.abortedMap.remove(framePlace);
                if (aborted != null) {
                    c.aborted += aborted.count;
                    c.wasted += aborted.cost;
                }
            }
            this.flush();
        }

        public void onValueUsed(long frameId, CachedValueProfiler.EventPlace place, long computed, long time) {
            Computed c = this.computedMap.get(place.getStackFrame());
            ++c.used;
            c.lifetime = Math.max(c.lifetime, time - computed);
            this.flush();
        }

        public void onValueInvalidated(long frameId, CachedValueProfiler.EventPlace place, long used, long time) {
            Computed c = this.computedMap.get(place.getStackFrame());
            c.limbotime = Math.max(c.limbotime, time - used);
            this.flush();
        }

        public void onValueRejected(long frameId, CachedValueProfiler.EventPlace place, long start, long computed, long time) {
            Computed c = this.computedMap.get(place.getStackFrame());
            ++c.rejected;
            c.wasted += time - start;
            this.flush();
        }

        @Override
        public void close() {
            this.lastFlushMillis = 0L;
            this.flush();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "map";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/performancePlugin/cachedValueProfiler/CVPPanel$MyEventConsumer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/performancePlugin/cachedValueProfiler/CVPPanel$MyEventConsumer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildInfos";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "buildInfos";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        static class Computed {
            static final Computed NULL = new Computed();
            long count;
            long cost;
            long used;
            long lifetime;
            long limbotime;
            long aborted;
            long rejected;
            long wasted;

            Computed() {
            }
        }

        static class Aborted {
            long count;
            long cost;

            Aborted() {
            }
        }
    }

    private static class CVPInfo {
        final StackTraceElement place;
        final long count;
        final long cost;
        final long used;
        final long aborted;
        final long rejected;
        final long wasted;
        final long lifetime;
        final long limbotime;

        /*
         * WARNING - void declaration
         */
        CVPInfo(@NotNull StackTraceElement place, long count, long cost, long used, long aborted, long l, long l2, long l3, long l4) {
            void limbotime;
            void lifetime;
            void wasted;
            void rejected;
            if (place == null) {
                CVPInfo.$$$reportNull$$$0(0);
            }
            this.place = place;
            this.count = count;
            this.cost = cost;
            this.used = used;
            this.aborted = aborted;
            this.rejected = rejected;
            this.wasted = wasted;
            this.lifetime = lifetime;
            this.limbotime = limbotime;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/jetbrains/performancePlugin/cachedValueProfiler/CVPPanel$CVPInfo", "<init>"));
        }
    }

    private static class MyColumnInfo
    extends ColumnInfo<CVPInfo, String> {
        final Function<CVPInfo, String> toString;
        final Comparator<CVPInfo> comparator;
        final int width;
        final String tooltip;

        MyColumnInfo(@Nls String name, Function<CVPInfo, String> toString, Comparator<CVPInfo> comparator, int width, String tooltip) {
            super(name);
            this.toString = toString;
            this.comparator = comparator;
            this.width = width;
            this.tooltip = tooltip;
        }

        public String valueOf(CVPInfo o) {
            return this.toString.apply(o);
        }

        @Nullable
        public Comparator<CVPInfo> getComparator() {
            return this.comparator;
        }

        @NlsContexts.Tooltip
        @Nullable
        public String getTooltipText() {
            return this.tooltip;
        }
    }

    private static class MyTableModel
    extends ListTableModel<CVPInfo> {
        long[] changeBits;

        private MyTableModel() {
            super((ColumnInfo[])CVPPanel.getColumns(), Collections.emptyList(), 0, SortOrder.ASCENDING);
        }
    }
}

