/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin;

import com.intellij.ide.plugins.CannotUnloadPluginException;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackCommand;
import com.intellij.openapi.ui.playback.PlaybackRunner;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.performancePlugin.CommandProvider;
import com.jetbrains.performancePlugin.CreateCommand;
import com.jetbrains.performancePlugin.RunCallbackHandler;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PlaybackRunnerExtended
extends PlaybackRunner {
    public static final String NOTIFICATION_GROUP = "PerformancePlugin";
    private Project myProject;
    private boolean myStopped;
    private final DynamicPluginListener myDynamicPluginListener;

    public PlaybackRunnerExtended(String script, PlaybackRunner.StatusCallback callback, @NotNull Project project) {
        if (project == null) {
            PlaybackRunnerExtended.$$$reportNull$$$0(0);
        }
        super(script, callback, Registry.is((String)"performance.plugin.playback.runner.useDirectActionCall", (boolean)false), false, true);
        this.setProject(project);
        this.myDynamicPluginListener = new DynamicPluginListener(){

            public void checkUnloadPlugin(@NotNull IdeaPluginDescriptor pluginDescriptor) throws CannotUnloadPluginException {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (PluginId.getId((String)"com.jetbrains.performancePlugin").equals((Object)pluginDescriptor.getPluginId())) {
                    throw new CannotUnloadPluginException("Cannot unload plugin during playback execution");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/jetbrains/performancePlugin/PlaybackRunnerExtended$1", "checkUnloadPlugin"));
            }
        };
    }

    public void setProject(@Nullable Project project) {
        this.myProject = project;
        if (project != null && !project.isDefault()) {
            Disposer.register((Disposable)project, () -> {
                if (project == this.myProject) {
                    Disposer.dispose((Disposable)this.myOnStop);
                }
            });
        }
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    protected void subscribeListeners(MessageBusConnection connection) {
        super.subscribeListeners(connection);
        connection.subscribe(DynamicPluginListener.TOPIC, (Object)this.myDynamicPluginListener);
    }

    protected void onStop() {
        super.onStop();
        this.myStopped = true;
    }

    @NotNull
    protected PlaybackCommand createCommand(@NotNull String _command, int line, @NotNull File scriptDir) {
        String commandName;
        CreateCommand createCommand;
        if (_command == null) {
            PlaybackRunnerExtended.$$$reportNull$$$0(1);
        }
        if (scriptDir == null) {
            PlaybackRunnerExtended.$$$reportNull$$$0(2);
        }
        String command = _command.replaceAll("[\r\n]+$", "");
        String[] cmdline = command.split("\\s+");
        PlaybackCommand playbackCommand = null;
        if (cmdline.length > 0 && (createCommand = CommandProvider.findCommandCreator(commandName = cmdline[0])) != null && (playbackCommand = createCommand.invoke(command, line)) instanceof AbstractCommand) {
            ((AbstractCommand)playbackCommand).setScriptDir(scriptDir);
        }
        if (playbackCommand == null) {
            playbackCommand = super.createCommand(command, line, scriptDir);
        }
        PlaybackCommand playbackCommand2 = playbackCommand;
        if (playbackCommand2 == null) {
            PlaybackRunnerExtended.$$$reportNull$$$0(3);
        }
        return playbackCommand2;
    }

    public ActionCallback run() {
        if (this.myStopped) {
            throw new IllegalStateException("PlaybackRunnerExtended can be run only once.");
        }
        ActionCallback callback = super.run();
        RunCallbackHandler.applyPatchesToCommandCallback(this.myProject, callback);
        return callback;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_command";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptDir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/PlaybackRunnerExtended";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/PlaybackRunnerExtended";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createCommand";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

